/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui.components.resize;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.WindowResizeListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.ui.components.resize.ResizeAbility;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/ui/components/resize/Resizer;", "", "component", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Resizer", "(Ljavax/swing/JComponent;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getComponent", "()Ljavax/swing/JComponent;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "resizeAbility", "Lcom/jetbrains/rider/ui/components/resize/ResizeAbility;", "getResizeAbility", "()Lcom/jetbrains/rider/ui/components/resize/ResizeAbility;", "setResizeAbility", "(Lcom/jetbrains/rider/ui/components/resize/ResizeAbility;)V", "intellij.rider"})
public final class Resizer {
    @NotNull
    private final JComponent component;
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private ResizeAbility resizeAbility;

    public Resizer(@NotNull JComponent component2, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.component = component2;
        this.lifetime = lifetime;
        JRootPane jRootPane = this.component.getRootPane();
        Component component3 = jRootPane.getGlassPane();
        Intrinsics.checkNotNull((Object)component3, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.IdeGlassPane");
        IdeGlassPane ideGlassPane = (IdeGlassPane)component3;
        JComponent jComponent = this.component;
        WindowResizeListener windowResizeListener = new WindowResizeListener(this, jComponent){
            final /* synthetic */ Resizer this$0;
            {
                this.this$0 = $receiver;
                super((Component)$super_call_param$1, null);
            }

            protected Component getView(Component component2) {
                return component2;
            }

            protected Insets getResizeOffset(Component view) {
                Insets insets = this.this$0.getComponent().getInsets();
                Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
                return insets;
            }

            protected Insets getResizeBorder(Component view) {
                if (view == null) {
                    return null;
                }
                ResizeAbility resizeAbility = this.this$0.getResizeAbility();
                return resizeAbility != null ? resizeAbility.getInsets() : null;
            }
        };
        jComponent = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null);
        ideGlassPane.addMousePreprocessor((MouseListener)windowResizeListener, (Disposable)jComponent);
        ideGlassPane.addMouseMotionPreprocessor((MouseMotionListener)windowResizeListener, (Disposable)jComponent);
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Nullable
    public final ResizeAbility getResizeAbility() {
        return this.resizeAbility;
    }

    public final void setResizeAbility(@Nullable ResizeAbility resizeAbility) {
        this.resizeAbility = resizeAbility;
    }
}

