/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui.components;

import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 @2\u00020\u00012\u00020\u0002:\u0002?@B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001e\u001a\u00020\u001dJ\b\u0010\u001f\u001a\u00020\u0019H\u0016J\b\u0010 \u001a\u00020\fH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0016J \u0010*\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001dH\u0002J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J*\u0010.\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010/\u001a\u0002002\b\b\u0001\u00101\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J*\u0010.\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u0002032\b\b\u0001\u00104\u001a\u00020\u001dH\u0002J\b\u00105\u001a\u00020\u0019H\u0016J\u0010\u00106\u001a\u00020\"2\u0006\u00107\u001a\u000208H\u0014J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\"2\u0006\u0010=\u001a\u00020;H\u0014J\u0010\u0010>\u001a\u00020\"2\u0006\u0010=\u001a\u00020;H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/jetbrains/rider/ui/components/SplitButton;", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "Lcom/intellij/openapi/actionSystem/ex/ActionPopupMenuListener;", "executeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "chooseFromActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "place", "", "minimumButtonSize", "Ljava/awt/Dimension;", "SplitButton", "(Lcom/intellij/openapi/actionSystem/AnAction;Lcom/intellij/openapi/actionSystem/Presentation;Lcom/intellij/openapi/actionSystem/ActionGroup;Ljava/lang/String;Ljava/awt/Dimension;)V", "HOVER_COLOR", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "COLOR", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "executeIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/Nullable;", "popupIsShown", "", "whichButtonPressed", "Lcom/jetbrains/rider/ui/components/SplitButton$WhichButtonPressed;", "scaledSeparatorXOffset", "", "getScaledSeparatorHorizontalOffset", "showActionGroup", "getPreferredSize", "removeNotify", "", "actionPopupMenuCreated", "menu", "Lcom/intellij/openapi/actionSystem/ActionPopupMenu;", "actionPopupMenuReleased", "paintComponent", "g", "Ljava/awt/Graphics;", "x", "x", "scaledSeparatorWidth", "x", "x", "look", "Lcom/intellij/openapi/actionSystem/ex/ActionButtonLook;", "splitButtonState", "rect", "Ljava/awt/Rectangle;", "state", "isUIHeader", "actionPerformed", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "x", "inputEvent", "Ljava/awt/event/MouseEvent;", "onMousePressed", "e", "onMouseReleased", "WhichButtonPressed", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSplitButton.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplitButton.kt\ncom/jetbrains/rider/ui/components/SplitButton\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,265:1\n13#2:266\n*S KotlinDebug\n*F\n+ 1 SplitButton.kt\ncom/jetbrains/rider/ui/components/SplitButton\n*L\n43#1:266\n*E\n"})
public class SplitButton
extends ActionButton
implements ActionPopupMenuListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ActionGroup chooseFromActionGroup;
    @NotNull
    private final Dimension minimumButtonSize;
    @NotNull
    private final JBColor HOVER_COLOR;
    @NotNull
    private final JBColor COLOR;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Icon executeIcon;
    private boolean popupIsShown;
    @NotNull
    private WhichButtonPressed whichButtonPressed;
    private int scaledSeparatorXOffset;
    private static final int arrowIconTopYShift = ExperimentalUI.Companion.isNewUI() ? 0 : -1;
    private static final int separatorWidth = 1;
    private static final int innerHorizontalPad = ExperimentalUI.Companion.isNewUI() ? 5 : 3;
    private static final int contentRightXExtraInset = 1;
    private static final int innerArrowHorizontalGap = ExperimentalUI.Companion.isNewUI() ? 2 : 3;
    @NotNull
    private static final JBColor separatorColor = new JBColor(0xB3B3B3, 0x6B6B6B);
    private static final int separatorVerticalInsets = 2;
    @NotNull
    private static final Icon arrowDownIcon;

    public SplitButton(@NotNull AnAction executeAction, @NotNull Presentation presentation, @NotNull ActionGroup chooseFromActionGroup, @NotNull String place, @NotNull Dimension minimumButtonSize) {
        Intrinsics.checkNotNullParameter((Object)executeAction, (String)"executeAction");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)chooseFromActionGroup, (String)"chooseFromActionGroup");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)minimumButtonSize, (String)"minimumButtonSize");
        super(executeAction, presentation, place, minimumButtonSize);
        this.chooseFromActionGroup = chooseFromActionGroup;
        this.minimumButtonSize = minimumButtonSize;
        JBColor jBColor = JBColor.namedColor((String)"MainToolbar.Dropdown.hoverBackground", (Color)JBColor.background());
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        this.HOVER_COLOR = jBColor;
        JBColor jBColor2 = JBColor.namedColor((String)"MainToolbar.Dropdown.background", (Color)JBColor.foreground());
        Intrinsics.checkNotNullExpressionValue((Object)jBColor2, (String)"namedColor(...)");
        this.COLOR = jBColor2;
        boolean bl = false;
        Logger logger = Logger.getInstance(SplitButton.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        Icon icon = executeAction.getTemplatePresentation().getIcon();
        if (icon == null) {
            Icon icon2 = AllIcons.Toolbar.Unknown;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Unknown");
        }
        this.executeIcon = icon;
        this.whichButtonPressed = WhichButtonPressed.NONE;
    }

    public final int getScaledSeparatorHorizontalOffset() {
        return this.scaledSeparatorXOffset;
    }

    public boolean showActionGroup() {
        return true;
    }

    @NotNull
    public Dimension getPreferredSize() {
        int n = JBUI.scale((int)innerHorizontalPad) + this.executeIcon.getIconWidth() + JBUI.scale((int)innerHorizontalPad) + JBUI.scale((int)contentRightXExtraInset);
        if (this.showActionGroup()) {
            n += JBUI.scale((int)innerArrowHorizontalGap) + JBUI.scale((int)1) + JBUI.scale((int)innerArrowHorizontalGap) + arrowDownIcon.getIconWidth();
        }
        Dimension dimension = new Dimension(Math.max(JBUI.scale((int)this.minimumButtonSize.width), n), this.minimumButtonSize.height);
        JBInsets.addTo((Dimension)dimension, (Insets)this.getInsets());
        return dimension;
    }

    public void removeNotify() {
        this.popupIsShown = false;
        this.whichButtonPressed = WhichButtonPressed.NONE;
        super.removeNotify();
    }

    public void actionPopupMenuCreated(@NotNull ActionPopupMenu menu) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        if (Intrinsics.areEqual((Object)menu.getActionGroup(), (Object)this.chooseFromActionGroup)) {
            this.popupIsShown = true;
            this.repaint();
        }
    }

    public void actionPopupMenuReleased(@NotNull ActionPopupMenu menu) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        if (Intrinsics.areEqual((Object)menu.getActionGroup(), (Object)this.chooseFromActionGroup)) {
            this.popupIsShown = false;
            this.repaint();
        }
    }

    public void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.jComponentPaint(g);
        int n = this.getPopState();
        WhichButtonPressed whichButtonPressed = this.whichButtonPressed;
        if (this.popupIsShown) {
            n = -1;
            whichButtonPressed = WhichButtonPressed.CHOOSE;
        }
        if (this.isEnabled() || !UIUtil.isUnderDarcula()) {
            ActionButtonLook actionButtonLook = this.getButtonLook();
            Intrinsics.checkNotNullExpressionValue((Object)actionButtonLook, (String)"getButtonLook(...)");
            this.x(g, actionButtonLook, n, whichButtonPressed);
        }
        int n2 = JBUI.scale((int)innerHorizontalPad);
        int n3 = JBUI.scale((int)innerArrowHorizontalGap);
        int n4 = this.getInsets().left + n2 + JBUI.scale((int)contentRightXExtraInset);
        Icon icon = this.getIcon();
        Intrinsics.checkNotNull((Object)icon);
        int n5 = this.x(icon);
        this.getButtonLook().paintIcon(g, (ActionButtonComponent)this, icon, n4, n5);
        this.scaledSeparatorXOffset = n4 + icon.getIconWidth() + n2;
        if (this.showActionGroup()) {
            int n6 = JBUI.scale((int)1);
            switch (n) {
                case -1: 
                case 1: {
                    this.x(g, this.scaledSeparatorXOffset, n6);
                }
            }
            int n7 = this.scaledSeparatorXOffset + n6 + n3;
            Icon icon2 = arrowDownIcon;
            if (ExperimentalUI.Companion.isNewUI()) {
                int n8 = (this.getHeight() - arrowDownIcon.getIconHeight()) / 2 + JBUI.scale((int)arrowIconTopYShift);
                icon2.paintIcon((Component)((Object)this), g, n7, n8);
            } else {
                int n9 = this.getHeight() / 2 + JBUI.scale((int)arrowIconTopYShift);
                this.getButtonLook().paintIcon(g, (ActionButtonComponent)this, icon2, n7, n9);
            }
            this.getButtonLook().paintBorder(g, (JComponent)((Object)this), n);
        }
    }

    private final void x(Graphics graphics, int n, int n2) {
        graphics.setColor((Color)separatorColor);
        int n3 = JBUI.scale((int)2);
        graphics.fillRect(n, this.getInsets().top + n3, n2, this.getHeight() - this.getInsets().top - this.getInsets().bottom - 2 * n3);
    }

    private final int x(Icon icon) {
        return (this.getHeight() - icon.getIconHeight()) / 2;
    }

    private final void x(Graphics graphics, ActionButtonLook actionButtonLook, @ActionButtonComponent.ButtonState int n, WhichButtonPressed whichButtonPressed) {
        Rectangle rectangle = new Rectangle(this.getSize());
        JBInsets.removeFrom((Rectangle)rectangle, (Insets)this.getInsets());
        if (n != -1) {
            this.x(graphics, actionButtonLook, rectangle, n);
        } else {
            this.x(graphics, actionButtonLook, rectangle, 1);
            if (this.showActionGroup()) {
                switch (WhenMappings.$EnumSwitchMapping$0[whichButtonPressed.ordinal()]) {
                    case 1: {
                        Rectangle rectangle2 = new Rectangle(this.scaledSeparatorXOffset, this.getSize().height);
                        JBInsets.removeFrom((Rectangle)rectangle2, (Insets)this.getInsets());
                        JBInsets.addTo((Rectangle)rectangle2, (Insets)new Insets(0, 0, 0, this.getInsets().right));
                        this.x(graphics, actionButtonLook, rectangle2, -1);
                        break;
                    }
                    case 2: {
                        Rectangle rectangle3 = new Rectangle(this.scaledSeparatorXOffset, 0, this.getSize().width - this.scaledSeparatorXOffset, this.getSize().height);
                        JBInsets.removeFrom((Rectangle)rectangle3, (Insets)this.getInsets());
                        JBInsets.addTo((Rectangle)rectangle3, (Insets)new Insets(0, this.getInsets().left, 0, 0));
                        this.x(graphics, actionButtonLook, rectangle3, -1);
                        break;
                    }
                    case 3: {
                        this.logger.error("SplitButton is pressed, but we didn't know which part");
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
    }

    private final void x(Graphics graphics, ActionButtonLook actionButtonLook, Rectangle rectangle, @ActionButtonComponent.ButtonState int n) {
        if (n != 0) {
            Color color = n == -1 ? (this.isUIHeader() ? (Color)this.COLOR : JBUI.CurrentTheme.ActionButton.pressedBackground()) : (this.isUIHeader() ? (Color)this.HOVER_COLOR : JBUI.CurrentTheme.ActionButton.hoverBackground());
            Intrinsics.checkNotNull((Object)color);
            Color color2 = color;
            actionButtonLook.paintLookBackground(graphics, rectangle, color2);
        }
    }

    public boolean isUIHeader() {
        return ExperimentalUI.Companion.isNewUI();
    }

    protected void actionPerformed(@NotNull AnActionEvent event) {
        boolean bl;
        InputEvent inputEvent;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        HelpTooltip.hide((Component)((Component)((Object)this)));
        InputEvent inputEvent2 = inputEvent = event.getInputEvent();
        boolean bl2 = inputEvent2 instanceof MouseEvent ? this.x((MouseEvent)inputEvent) : (bl = inputEvent2 instanceof KeyEvent ? true : true);
        if (bl) {
            AnAction anAction = this.myAction;
            Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"myAction");
            ActionUtil.performAction((AnAction)anAction, (AnActionEvent)event);
        } else {
            ActionsCollector.getInstance().record(event.getProject(), (AnAction)this.chooseFromActionGroup, event, null);
            this.showActionGroupPopup(this.chooseFromActionGroup, event);
        }
    }

    private final boolean x(MouseEvent mouseEvent) {
        return mouseEvent.getX() < this.scaledSeparatorXOffset;
    }

    protected void onMousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.onMousePressed(e);
        this.whichButtonPressed = this.x(e) ? WhichButtonPressed.EXECUTE : WhichButtonPressed.CHOOSE;
    }

    protected void onMouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.onMouseReleased(e);
        this.whichButtonPressed = WhichButtonPressed.NONE;
    }

    static {
        Icon icon = ExperimentalUI.Companion.isNewUI() ? AllIcons.General.ChevronDown : AllIcons.General.ArrowDownSmall;
        Intrinsics.checkNotNull((Object)icon);
        arrowDownIcon = icon;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/ui/components/SplitButton$Companion;", "", "SplitButton$Companion", "()V", "arrowIconTopYShift", "", "separatorWidth", "innerHorizontalPad", "contentRightXExtraInset", "innerArrowHorizontalGap", "separatorColor", "Lcom/intellij/ui/JBColor;", "separatorVerticalInsets", "arrowDownIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WhichButtonPressed.values().length];
            try {
                nArray[WhichButtonPressed.EXECUTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WhichButtonPressed.CHOOSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WhichButtonPressed.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/ui/components/SplitButton$WhichButtonPressed;", "", "SplitButton$WhichButtonPressed", "(Ljava/lang/String;I)V", "NONE", "EXECUTE", "CHOOSE", "intellij.rider"})
    private static final class WhichButtonPressed
    extends Enum<WhichButtonPressed> {
        public static final /* enum */ WhichButtonPressed NONE = new WhichButtonPressed();
        public static final /* enum */ WhichButtonPressed EXECUTE = new WhichButtonPressed();
        public static final /* enum */ WhichButtonPressed CHOOSE = new WhichButtonPressed();
        private static final /* synthetic */ WhichButtonPressed[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WhichButtonPressed[] values() {
            return (WhichButtonPressed[])$VALUES.clone();
        }

        public static WhichButtonPressed valueOf(String value2) {
            return Enum.valueOf(WhichButtonPressed.class, value2);
        }

        @NotNull
        public static EnumEntries<WhichButtonPressed> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = whichButtonPressedArray = new WhichButtonPressed[]{WhichButtonPressed.NONE, WhichButtonPressed.EXECUTE, WhichButtonPressed.CHOOSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

