/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtilities;
import com.jetbrains.rd.swing.RdSwingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.ui.components.ComponentFactories;
import com.jetbrains.rider.ui.components.base.Widget;
import com.jetbrains.rider.ui.components.utils.ComponentUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u0019H\u0002J\b\u0010'\u001a\u00020\u000eH\u0002J\b\u0010(\u001a\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0006R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/ui/components/CroppedTextField;", "Lcom/jetbrains/rider/ui/components/base/Widget;", "Ljavax/swing/JComponent;", "text_", "", "CroppedTextField", "(Ljava/lang/String;)V", "button", "textField", "Lcom/intellij/ui/components/JBTextField;", "panel", "Ljavax/swing/JPanel;", "getView", "dispose", "", "value", "text", "getText", "()Ljava/lang/String;", "setText", "jTextPane", "Ljavax/swing/JTextPane;", "popupPane", "Lcom/intellij/ui/components/JBScrollPane;", "builder", "Lcom/intellij/openapi/ui/popup/BalloonBuilder;", "Lorg/jetbrains/annotations/NotNull;", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "active", "", "x", "()Z", "onClick", "Lkotlin/Function0;", "x", "balloonBuilder", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "x", "G", "intellij.rider"})
public final class CroppedTextField
implements Widget<JComponent> {
    @NotNull
    private final JComponent button;
    @NotNull
    private final JBTextField textField;
    @NotNull
    private final JPanel panel;
    @Nullable
    private String text;
    @NotNull
    private final JTextPane jTextPane;
    @NotNull
    private final JBScrollPane popupPane;
    @NotNull
    private final BalloonBuilder builder;
    @Nullable
    private Balloon balloon;
    @NotNull
    private final Function0<Unit> onClick;
    @NotNull
    private final Lifetime lifetime;

    public CroppedTextField(@Nullable String text_) {
        Object object;
        Icon icon = AllIcons.General.Warning;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Warning");
        this.button = ComponentFactories.Companion.iconButton(icon, () -> CroppedTextField.x(this));
        JBTextField jBTextField = object = new JBTextField();
        CroppedTextField croppedTextField = this;
        boolean bl = false;
        jBTextField.setEditable(false);
        croppedTextField.textField = object;
        jBTextField = object = new JPanel((LayoutManager)new MigLayout("fillx, ins 0, gap 0, hidemode 3", "[][min!]"));
        croppedTextField = this;
        bl = false;
        jBTextField.add((Component)this.textField, "growx");
        jBTextField.add((Component)this.button, "ax right, gapbefore " + JBUI.scale((int)1));
        croppedTextField.panel = object;
        this.text = text_;
        jBTextField = object = new JTextPane();
        croppedTextField = this;
        bl = false;
        jBTextField.setEditable(false);
        jBTextField.setText(this.text);
        ComponentUtils.Companion.setCaretPosition$default(ComponentUtils.Companion, (JTextComponent)jBTextField, 0, 2, null);
        croppedTextField.jTextPane = object;
        jBTextField = object = new JBScrollPane((Component)this.jTextPane);
        croppedTextField = this;
        bl = false;
        jBTextField.setPreferredSize((Dimension)new JBDimension(300, 100));
        jBTextField.setHorizontalScrollBarPolicy(31);
        jBTextField.setVerticalScrollBarPolicy(20);
        jBTextField.setBorder((Border)JBUI.Borders.empty((int)5, (int)5));
        croppedTextField.popupPane = object;
        BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)this.popupPane).setHideOnAction(false).setHideOnCloseClick(true).setHideOnFrameResize(false).setRequestFocus(false).setLayer(Balloon.Layer.top).setBorderInsets(new Insets(1, 1, 1, 1));
        Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"setBorderInsets(...)");
        this.builder = balloonBuilder;
        this.onClick = () -> CroppedTextField.G(this);
        this.lifetime = LifetimeDisposableExKt.createLifetime((Disposable)this);
        RdSwingKt.sizeProperty((JComponent)((JComponent)this.textField)).advise(this.lifetime, arg_0 -> CroppedTextField.x(this, arg_0));
        this.textField.addHierarchyListener(arg_0 -> CroppedTextField.x(this, arg_0));
    }

    public /* synthetic */ CroppedTextField(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @NotNull
    public JComponent getView() {
        return this.panel;
    }

    public void dispose() {
        this.x();
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String value2) {
        this.text = value2;
        this.G();
    }

    private final boolean x() {
        if (this.balloon == null) {
            return false;
        }
        Balloon balloon = this.balloon;
        Intrinsics.checkNotNull((Object)balloon);
        return !balloon.isDisposed();
    }

    private final Balloon x(BalloonBuilder balloonBuilder) {
        Balloon balloon = balloonBuilder.createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon balloon2 = balloon;
        balloon2.setAnimationEnabled(false);
        JPanel jPanel = this.panel;
        balloon2.show((PositionTracker)new PositionTracker<Balloon>(this, jPanel){
            final /* synthetic */ CroppedTextField this$0;
            {
                this.this$0 = $receiver;
                super((Component)$super_call_param$1);
            }

            public RelativePoint recalculateLocation(Balloon object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"object");
                Point point = CroppedTextField.access$getButton$p(this.this$0).getLocation();
                point = new Point(point.x + CroppedTextField.access$getButton$p(this.this$0).getWidth() / 2, point.y + CroppedTextField.access$getButton$p(this.this$0).getHeight());
                return new RelativePoint((Component)CroppedTextField.access$getPanel$p(this.this$0), point);
            }
        }, Balloon.Position.below);
        Disposer.register((Disposable)this, (Disposable)((Disposable)balloon2));
        return balloon2;
    }

    private final void x() {
        block1: {
            if (!this.x()) break block1;
            Balloon balloon = this.balloon;
            if (balloon != null) {
                balloon.hide();
            }
        }
    }

    private final void G() {
        this.x();
        this.jTextPane.setText(this.text);
        FontMetrics fontMetrics = this.textField.getFontMetrics(this.textField.getFont());
        Insets insets = this.textField.getInsets(null);
        int n = this.panel.getWidth() - (insets.right + insets.left);
        int n2 = SwingUtilities.computeStringWidth(fontMetrics, this.text);
        if (n2 > n) {
            this.textField.setText(UIUtilities.clipString((JComponent)((JComponent)this.textField), (FontMetrics)fontMetrics, (String)this.text, (int)(n - this.button.getWidth())));
            this.button.setVisible(true);
        } else {
            this.textField.setText(this.text);
            this.button.setVisible(false);
        }
        ComponentUtils.Companion.setCaretPosition$default(ComponentUtils.Companion, (JTextComponent)this.textField, 0, 2, null);
        this.panel.revalidate();
    }

    private static final Unit x(CroppedTextField croppedTextField) {
        croppedTextField.onClick.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit G(CroppedTextField croppedTextField) {
        if (!croppedTextField.x()) {
            croppedTextField.balloon = croppedTextField.x(croppedTextField.builder);
            croppedTextField.popupPane.getVerticalScrollBar().setValue(croppedTextField.popupPane.getVerticalScrollBar().getMinimum());
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(CroppedTextField croppedTextField, Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"it");
        croppedTextField.G();
        return Unit.INSTANCE;
    }

    private static final void x(CroppedTextField croppedTextField, HierarchyEvent hierarchyEvent) {
        if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && croppedTextField.textField.isShowing()) {
            croppedTextField.G();
        }
    }

    public CroppedTextField() {
        this(null, 1, null);
    }

    public static final /* synthetic */ JComponent access$getButton$p(CroppedTextField $this) {
        return $this.button;
    }

    public static final /* synthetic */ JPanel access$getPanel$p(CroppedTextField $this) {
        return $this.panel;
    }
}

