/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.ui.RiderUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 72\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u00017B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0011J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH&J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH&J\u0012\u0010#\u001a\u00020\"2\n\u0010$\u001a\u00020%\"\u00020\tJ\u0012\u0010&\u001a\u00020\"2\n\u0010$\u001a\u00020%\"\u00020\tJ\u0012\u0010'\u001a\u00020\"2\n\u0010$\u001a\u00020%\"\u00020\tJ2\u0010(\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010\u00182\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J:\u0010,\u001a\u00020)2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010\u00182\u0006\u0010+\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J\n\u0010.\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020\"2\u0006\u0010/\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\"2\u0006\u0010/\u001a\u000202H\u0016J\u0010\u00104\u001a\u00020\"2\u0006\u0010/\u001a\u000202H\u0016J\u0010\u00105\u001a\u00020\"2\u0006\u0010/\u001a\u000202H\u0016J\u0010\u00106\u001a\u00020\"2\u0006\u0010/\u001a\u000202H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/jetbrains/rider/ui/ButtonColumn;", "Ljavax/swing/AbstractCellEditor;", "Ljavax/swing/table/TableCellRenderer;", "Ljavax/swing/table/TableCellEditor;", "Ljava/awt/event/ActionListener;", "Ljava/awt/event/MouseListener;", "table", "Ljavax/swing/JTable;", "buttonSize", "", "ButtonColumn", "(Ljavax/swing/JTable;I)V", "getTable", "()Ljavax/swing/JTable;", "getButtonSize", "()I", "prepare", "Ljavax/swing/JButton;", "renderButton", "getRenderButton", "()Ljavax/swing/JButton;", "editButton", "getEditButton", "editorValue", "", "isButtonColumnEditor", "", "emptyRenderer", "Ljavax/swing/JPanel;", "getIcon", "Ljavax/swing/Icon;", "row", "column", "actionPerformed", "", "invalidateUI", "columns", "", "install", "installWithoutListener", "getTableCellEditorComponent", "Ljava/awt/Component;", "value", "isSelected", "getTableCellRendererComponent", "hasFocus", "getCellEditorValue", "e", "Ljava/awt/event/ActionEvent;", "mousePressed", "Ljava/awt/event/MouseEvent;", "mouseReleased", "mouseClicked", "mouseEntered", "mouseExited", "Companion", "intellij.rider"})
public abstract class ButtonColumn
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ActionListener,
MouseListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTable table;
    private final int buttonSize;
    @NotNull
    private final JButton renderButton;
    @NotNull
    private final JButton editButton;
    @Nullable
    private Object editorValue;
    private boolean isButtonColumnEditor;
    @NotNull
    private final JPanel emptyRenderer;

    public ButtonColumn(@NotNull JTable table2, int buttonSize) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        this.table = table2;
        this.buttonSize = buttonSize;
        this.renderButton = this.prepare(new JButton());
        this.editButton = this.prepare(new JButton());
        this.emptyRenderer = new JPanel(new BorderLayout());
        this.editButton.addActionListener(this);
    }

    @NotNull
    public final JTable getTable() {
        return this.table;
    }

    public final int getButtonSize() {
        return this.buttonSize;
    }

    @NotNull
    public final JButton prepare(@NotNull JButton $this$prepare) {
        Intrinsics.checkNotNullParameter((Object)$this$prepare, (String)"<this>");
        $this$prepare.setBorderPainted(false);
        $this$prepare.setFocusPainted(false);
        $this$prepare.setPreferredSize((Dimension)new JBDimension(this.buttonSize, this.buttonSize));
        $this$prepare.setMinimumSize((Dimension)new JBDimension(this.buttonSize, this.buttonSize));
        $this$prepare.setMaximumSize((Dimension)new JBDimension(this.buttonSize, this.buttonSize));
        return $this$prepare;
    }

    @NotNull
    protected final JButton getRenderButton() {
        return this.renderButton;
    }

    @NotNull
    protected final JButton getEditButton() {
        return this.editButton;
    }

    @Nullable
    public abstract Icon getIcon(int var1, int var2);

    public abstract void actionPerformed(int var1, int var2);

    public final void invalidateUI(int ... columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        for (int n : columns) {
            TableColumn tableColumn;
            TableColumn tableColumn2 = tableColumn = this.table.getColumnModel().getColumn(n);
            boolean bl = false;
            tableColumn2.setMinWidth(JBUI.scale((int)(this.buttonSize + 2)));
            tableColumn2.setMaxWidth(JBUI.scale((int)(this.buttonSize + 2)));
            tableColumn2.setPreferredWidth(JBUI.scale((int)(this.buttonSize + 2)));
        }
        this.table.setRowHeight(JBUI.scale((int)(this.buttonSize + 2)));
        this.prepare(this.renderButton);
        this.prepare(this.editButton);
    }

    public final void install(int ... columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        this.installWithoutListener(Arrays.copyOf(columns, columns.length));
        this.table.addMouseListener(this);
    }

    public final void installWithoutListener(int ... columns) {
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        ButtonColumn buttonColumn = this;
        for (int n : columns) {
            TableColumn tableColumn;
            TableColumn tableColumn2 = tableColumn = this.table.getColumnModel().getColumn(n);
            boolean bl = false;
            tableColumn2.setCellRenderer(buttonColumn);
            tableColumn2.setCellEditor(buttonColumn);
            tableColumn2.setResizable(false);
            tableColumn2.setMinWidth(JBUI.scale((int)(this.buttonSize + 2)));
            tableColumn2.setMaxWidth(JBUI.scale((int)(this.buttonSize + 2)));
            tableColumn2.setPreferredWidth(JBUI.scale((int)(this.buttonSize + 2)));
        }
    }

    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, int row, int column) {
        Component component2;
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Icon icon = this.getIcon(row, column);
        this.editorValue = value2;
        if (icon == null) {
            component2 = this.emptyRenderer;
        } else {
            JButton jButton;
            JButton jButton2 = jButton = this.editButton;
            boolean bl = false;
            jButton2.setIcon(icon);
            jButton2.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
            this.prepare(jButton2);
            component2 = jButton;
        }
        Component component3 = component2;
        return ButtonColumn.Companion.x(component3, table2, isSelected, row);
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Component component2;
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Icon icon = this.getIcon(row, column);
        if (icon == null) {
            component2 = this.emptyRenderer;
        } else {
            JButton jButton;
            JButton jButton2 = jButton = this.renderButton;
            boolean bl = false;
            jButton2.setIcon(icon);
            jButton2.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
            this.prepare(jButton2);
            component2 = jButton;
        }
        Component component3 = component2;
        return ButtonColumn.Companion.x(component3, table2, isSelected, row);
    }

    @Override
    @Nullable
    public Object getCellEditorValue() {
        return this.editorValue;
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int n = this.table.convertRowIndexToModel(this.table.getEditingRow());
        int n2 = this.table.convertColumnIndexToModel(this.table.getEditingColumn());
        this.fireEditingStopped();
        if (n != -1) {
            this.actionPerformed(n, n2);
        }
    }

    @Override
    public void mousePressed(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.table.isEditing() && this.table.getCellEditor() == this) {
            this.isButtonColumnEditor = true;
        }
    }

    @Override
    public void mouseReleased(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isButtonColumnEditor && this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.isButtonColumnEditor = false;
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseEntered(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void mouseExited(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/ui/ButtonColumn$Companion;", "", "ButtonColumn$Companion", "()V", "x", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "isSelected", "", "row", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        private final Component x(Component component2, JTable jTable, boolean bl, int n) {
            Component component3;
            Component component4 = component3 = component2;
            boolean bl2 = false;
            component4.setForeground(bl ? UIUtil.getTableForeground((boolean)bl, (boolean)jTable.hasFocus()) : jTable.getForeground());
            component4.setBackground(bl ? UIUtil.getTableBackground((boolean)bl, (boolean)jTable.hasFocus()) : RiderUI.CommonPalette.Companion.getTableBgColor(n));
            return component3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

