/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.todo;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001a\u001a\u00020\u0015H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/todo/RiderTodoItem;", "Lcom/intellij/psi/search/TodoItem;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "additionalRanges", "", "todoPattern", "Lcom/intellij/psi/search/TodoPattern;", "RiderTodoItem", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/util/TextRange;Ljava/util/List;Lcom/intellij/psi/search/TodoPattern;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "setPsiFile", "(Lcom/intellij/psi/PsiFile;)V", "getFile", "getTextRange", "getAdditionalTextRanges", "getPattern", "intellij.rider"})
public final class RiderTodoItem
implements TodoItem {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile virtualFile;
    @NotNull
    private final TextRange range;
    @NotNull
    private final List<TextRange> additionalRanges;
    @NotNull
    private final TodoPattern todoPattern;
    @Nullable
    private PsiFile psiFile;

    public RiderTodoItem(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull TextRange range2, @NotNull List<TextRange> additionalRanges, @NotNull TodoPattern todoPattern) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter(additionalRanges, (String)"additionalRanges");
        Intrinsics.checkNotNullParameter((Object)todoPattern, (String)"todoPattern");
        this.project = project;
        this.virtualFile = virtualFile;
        this.range = range2;
        this.additionalRanges = additionalRanges;
        this.todoPattern = todoPattern;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    @Nullable
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    public final void setPsiFile(@Nullable PsiFile psiFile) {
        this.psiFile = psiFile;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile;
        PsiFile psiFile2 = this.psiFile;
        if (psiFile2 == null) {
            PsiFile psiFile3;
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)psiDocumentManager, (String)"getInstance(...)");
            PsiFile psiFile4 = ExtensionsKt.getPsiFile((VirtualFile)this.virtualFile, (FileDocumentManager)fileDocumentManager, (PsiDocumentManager)psiDocumentManager);
            if (psiFile4 == null) {
                throw new IllegalStateException(("Can't calculate psi file for " + this.virtualFile).toString());
            }
            this.psiFile = psiFile3 = psiFile4;
            return psiFile3;
        }
        if (psiFile2.isValid()) {
            return psiFile2;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.project);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        Intrinsics.checkNotNull((Object)psiDocumentManager);
        PsiFile psiFile5 = ExtensionsKt.getPsiFile((VirtualFile)this.virtualFile, (FileDocumentManager)fileDocumentManager, (PsiDocumentManager)psiDocumentManager);
        if (psiFile5 == null) {
            return psiFile2;
        }
        this.psiFile = psiFile = psiFile5;
        return psiFile;
    }

    @NotNull
    public TextRange getTextRange() {
        return this.range;
    }

    @NotNull
    public List<TextRange> getAdditionalTextRanges() {
        return this.additionalRanges;
    }

    @NotNull
    public TodoPattern getPattern() {
        return this.todoPattern;
    }
}

