/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.todo;

import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.configurable.TodoConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.TodoPattern;
import com.jetbrains.rider.todo.FrontendTodoSettingsModel;
import com.jetbrains.rider.todo.TodoSettingsHost;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u001f\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/todo/RiderTodoConfigurable;", "Lcom/intellij/ide/todo/configurable/TodoConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "RiderTodoConfigurable", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "apply", "", "getTodoPatternsToDisplay", "", "Lcom/intellij/psi/search/TodoPattern;", "todoConfiguration", "Lcom/intellij/ide/todo/TodoConfiguration;", "(Lcom/intellij/ide/todo/TodoConfiguration;)[Lcom/intellij/psi/search/TodoPattern;", "intellij.rider"})
public final class RiderTodoConfigurable
extends TodoConfigurable {
    @NotNull
    private final Project project;

    public RiderTodoConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void apply() {
        super.apply();
        if (!this.project.isDefault()) {
            TodoSettingsHost todoSettingsHost = TodoSettingsHost.Companion.getInstance(this.project);
            boolean bl = TodoConfiguration.getInstance().isMultiLine();
            List list2 = this.myPatterns;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"myPatterns");
            todoSettingsHost.syncSettings(bl, list2);
        }
    }

    @NotNull
    protected TodoPattern[] getTodoPatternsToDisplay(@Nullable TodoConfiguration todoConfiguration) {
        if (this.project.isDefault()) {
            return new TodoPattern[0];
        }
        FrontendTodoSettingsModel frontendTodoSettingsModel = TodoSettingsHost.Companion.getInstance(this.project).toFrontendSettingsModel();
        return frontendTodoSettingsModel.getPatterns();
    }
}

