/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.todo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.search.PsiTodoSearchHelperImpl;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.Processor;
import com.jetbrains.rider.daemon.RiderHighlightingSupport;
import com.jetbrains.rider.todo.RiderTodoItem;
import com.jetbrains.rider.todo.TodoBrowserHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\rJ-\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u00072\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\bH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00020\b0\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/todo/RiderPsiTodoSearchHelper;", "Lcom/intellij/psi/impl/search/PsiTodoSearchHelperImpl;", "project", "Lcom/intellij/openapi/project/Project;", "RiderPsiTodoSearchHelper", "(Lcom/intellij/openapi/project/Project;)V", "findFilesWithTodoItems", "", "Lcom/intellij/psi/PsiFile;", "()[Lcom/intellij/psi/PsiFile;", "findTodoItems", "Lcom/intellij/psi/search/TodoItem;", "file", "(Lcom/intellij/psi/PsiFile;)[Lcom/intellij/psi/search/TodoItem;", "startOffset", "", "endOffset", "(Lcom/intellij/psi/PsiFile;II)[Lcom/intellij/psi/search/TodoItem;", "findTodoItemsLight", "getTodoItemsCount", "pattern", "Lcom/intellij/psi/search/TodoPattern;", "x", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "shouldHighlightInEditor", "", "x", "processFilesWithTodoItems", "processor", "Lcom/intellij/util/Processor;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderPsiTodoSearchHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderPsiTodoSearchHelper.kt\ncom/jetbrains/rider/todo/RiderPsiTodoSearchHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,99:1\n1617#2,9:100\n1869#2:109\n1870#2:111\n1626#2:112\n1788#2,4:125\n1617#2,9:129\n1869#2:138\n1870#2:140\n1626#2:141\n1869#2,2:142\n1#3:110\n1#3:139\n37#4,2:113\n37#4,2:118\n37#4,2:123\n3919#5:115\n4434#5,2:116\n3919#5:120\n4434#5,2:121\n*S KotlinDebug\n*F\n+ 1 RiderPsiTodoSearchHelper.kt\ncom/jetbrains/rider/todo/RiderPsiTodoSearchHelper\n*L\n18#1:100,9\n18#1:109\n18#1:111\n18#1:112\n72#1:125,4\n92#1:129,9\n92#1:138\n92#1:140\n92#1:141\n92#1:142,2\n18#1:110\n92#1:139\n18#1:113,2\n37#1:118,2\n55#1:123,2\n35#1:115\n35#1:116,2\n53#1:120\n53#1:121,2\n*E\n"})
public final class RiderPsiTodoSearchHelper
extends PsiTodoSearchHelperImpl {
    @NotNull
    private final Project project;

    public RiderPsiTodoSearchHelper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
    }

    @NotNull
    public PsiFile[] findFilesWithTodoItems() {
        Object[] objectArray = super.findFilesWithTodoItems();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"findFilesWithTodoItems(...)");
        Object[] objectArray2 = objectArray;
        Set set = TodoBrowserHost.Companion.getInstance(this.project).getFilesWithTodo().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable iterable = set;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterable iterable3 = iterable2;
        boolean bl3 = false;
        Iterator iterator2 = iterable3.iterator();
        while (iterator2.hasNext()) {
            PsiFile psiFile;
            Object t;
            Object t2 = t = iterator2.next();
            boolean bl4 = false;
            VirtualFile virtualFile = (VirtualFile)t2;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)virtualFile);
            if (this.x(virtualFile) == null) continue;
            boolean bl6 = false;
            collection.add(psiFile);
        }
        iterable = (List)collection;
        bl = false;
        iterable2 = iterable;
        Object[] objectArray3 = iterable2.toArray(new PsiFile[0]);
        return (PsiFile[])ArraysKt.plus((Object[])objectArray3, (Object[])objectArray2);
    }

    @NotNull
    public TodoItem[] findTodoItems(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.x(file2)) {
            TodoItem[] todoItemArray = super.findTodoItems(file2);
            Intrinsics.checkNotNullExpressionValue((Object)todoItemArray, (String)"findTodoItems(...)");
            return todoItemArray;
        }
        return TodoBrowserHost.Companion.getInstance(this.project).findTodoItems(file2);
    }

    @NotNull
    public TodoItem[] findTodoItems(@NotNull PsiFile file2, int startOffset, int endOffset) {
        TodoItem[] todoItemArray;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.x(file2)) {
            TodoItem[] todoItemArray2 = super.findTodoItems(file2, startOffset, endOffset);
            Intrinsics.checkNotNullExpressionValue((Object)todoItemArray2, (String)"findTodoItems(...)");
            return todoItemArray2;
        }
        Object object = todoItemArray = TodoBrowserHost.Companion.getInstance(this.project).findTodoItems(file2);
        boolean bl = false;
        TodoItem[] todoItemArray3 = object;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        int n = todoItemArray3.length;
        for (int j = 0; j < n; ++j) {
            TodoItem todoItem;
            TodoItem todoItem2 = todoItem = todoItemArray3[j];
            boolean bl3 = false;
            if (!(todoItem2.getTextRange().getEndOffset() > startOffset && todoItem2.getTextRange().getStartOffset() < endOffset)) continue;
            collection.add(todoItem);
        }
        object = (List)collection;
        bl = false;
        todoItemArray3 = object;
        return todoItemArray3.toArray(new TodoItem[0]);
    }

    @NotNull
    public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.x(file2)) {
            TodoItem[] todoItemArray = super.findTodoItemsLight(file2);
            Intrinsics.checkNotNullExpressionValue((Object)todoItemArray, (String)"findTodoItemsLight(...)");
            return todoItemArray;
        }
        return TodoBrowserHost.Companion.getInstance(this.project).findTodoItems(file2);
    }

    @NotNull
    public TodoItem[] findTodoItemsLight(@NotNull PsiFile file2, int startOffset, int endOffset) {
        TodoItem[] todoItemArray;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.x(file2)) {
            TodoItem[] todoItemArray2 = super.findTodoItemsLight(file2, startOffset, endOffset);
            Intrinsics.checkNotNullExpressionValue((Object)todoItemArray2, (String)"findTodoItemsLight(...)");
            return todoItemArray2;
        }
        Object object = todoItemArray = TodoBrowserHost.Companion.getInstance(this.project).findTodoItems(file2);
        boolean bl = false;
        TodoItem[] todoItemArray3 = object;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        int n = todoItemArray3.length;
        for (int j = 0; j < n; ++j) {
            TodoItem todoItem;
            TodoItem todoItem2 = todoItem = todoItemArray3[j];
            boolean bl3 = false;
            if (!(todoItem2.getTextRange().getEndOffset() > startOffset && todoItem2.getTextRange().getStartOffset() < endOffset)) continue;
            collection.add(todoItem);
        }
        object = (List)collection;
        bl = false;
        todoItemArray3 = object;
        return todoItemArray3.toArray(new TodoItem[0]);
    }

    public int getTodoItemsCount(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.x(file2)) {
            return super.getTodoItemsCount(file2);
        }
        List<RiderTodoItem> list2 = TodoBrowserHost.Companion.getInstance(this.project).getFilesWithTodo().get(file2.getVirtualFile());
        if (list2 == null) {
            return 0;
        }
        List<RiderTodoItem> list3 = list2;
        return ((Collection)list3).size();
    }

    public int getTodoItemsCount(@NotNull PsiFile file2, @NotNull TodoPattern pattern) {
        int n;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        if (this.x(file2)) {
            return super.getTodoItemsCount(file2, pattern);
        }
        List<RiderTodoItem> list2 = TodoBrowserHost.Companion.getInstance(this.project).getFilesWithTodo().get(file2.getVirtualFile());
        if (list2 == null) {
            return 0;
        }
        List<RiderTodoItem> list3 = list2;
        Iterable iterable = list3;
        boolean bl = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            n = 0;
        } else {
            int n2 = 0;
            for (Object t : iterable) {
                RiderTodoItem riderTodoItem = (RiderTodoItem)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)riderTodoItem.getPattern(), (Object)pattern) || ++n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = n2;
        }
        return n;
    }

    private final PsiFile x(VirtualFile virtualFile) {
        if (!virtualFile.isValid()) {
            return null;
        }
        return PsiManager.getInstance((Project)this.project).findFile(virtualFile);
    }

    public boolean shouldHighlightInEditor(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.x(file2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean x(PsiFile psiFile) {
        if (psiFile.getVirtualFile() == null) return true;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        if (RiderHighlightingSupport.isAvailable((VirtualFile)virtualFile)) return false;
        return true;
    }

    public boolean processFilesWithTodoItems(@NotNull Processor<? super PsiFile> processor2) {
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        boolean bl = super.processFilesWithTodoItems(processor2);
        Set set = TodoBrowserHost.Companion.getInstance(this.project).getFilesWithTodo().keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable iterable = set;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection<PsiFile> collection2 = new ArrayList();
        boolean bl3 = false;
        Iterable iterable3 = iterable2;
        boolean bl4 = false;
        Iterator iterator2 = iterable3.iterator();
        while (iterator2.hasNext()) {
            PsiFile psiFile;
            Object t;
            Object t2 = t = iterator2.next();
            boolean bl5 = false;
            VirtualFile virtualFile = (VirtualFile)t2;
            boolean bl6 = false;
            Intrinsics.checkNotNull((Object)virtualFile);
            if (this.x(virtualFile) == null) continue;
            boolean bl7 = false;
            collection2.add(psiFile);
        }
        iterable = (List)collection2;
        bl2 = false;
        for (Collection<PsiFile> collection2 : iterable) {
            PsiFile psiFile = (PsiFile)collection2;
            boolean bl8 = false;
            processor2.process((Object)psiFile);
        }
        return bl;
    }
}

