/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.stacktrace;

import com.intellij.openapi.application.ClipboardAnalyzeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.stacktrace.RiderStacktraceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0005H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/stacktrace/RiderStacktraceClipboardListener;", "Lcom/intellij/openapi/application/ClipboardAnalyzeListener;", "RiderStacktraceClipboardListener", "()V", "stacktraceMark", "", "ident", "stub", "fullyQualifiedName", "parameter", "parameterList", "STACKTRACE_LINE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "linesToAnalyze", "", "canHandle", "", "value", "handle", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderStacktraceClipboardListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderStacktraceClipboardListener.kt\ncom/jetbrains/rider/stacktrace/RiderStacktraceClipboardListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n774#2:61\n865#2,2:62\n*S KotlinDebug\n*F\n+ 1 RiderStacktraceClipboardListener.kt\ncom/jetbrains/rider/stacktrace/RiderStacktraceClipboardListener\n*L\n41#1:61\n41#1:62,2\n*E\n"})
public final class RiderStacktraceClipboardListener
extends ClipboardAnalyzeListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String stacktraceMark;
    @NotNull
    private final String ident;
    @NotNull
    private final String stub;
    @NotNull
    private final String fullyQualifiedName;
    @NotNull
    private final String parameter;
    @NotNull
    private final String parameterList;
    private final Pattern STACKTRACE_LINE;
    private final int linesToAnalyze;
    @NotNull
    public static final String STACK_TRACE_PREPOSITIONS = "(at|\u0432|bei|en|kohteessa|\u5834\u6240)";
    @NotNull
    public static final String ON_THE_FLY_KEY = "rider.analyze.exceptions.on.the.fly";

    public RiderStacktraceClipboardListener() {
        this.stacktraceMark = "#stacktrace";
        this.ident = "[_`a-zA-Z0-9]+";
        this.stub = "<\\.?[_`a-zA-Z0-9]*>" + this.ident;
        this.fullyQualifiedName = this.ident + "(\\.(" + this.ident + "|" + this.stub + "))*";
        this.parameter = this.fullyQualifiedName + "(\\[\\])? " + this.ident;
        this.parameterList = "(" + this.parameter + "(, " + this.parameter + ")*)";
        this.STACKTRACE_LINE = Pattern.compile("^[\\t ]*(at|\u0432|bei|en|kohteessa|\u5834\u6240) " + this.fullyQualifiedName + "\\s?(\\(" + this.parameterList + "*\\))");
        this.linesToAnalyze = 50;
    }

    public boolean canHandle(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!Registry.Companion.is(ON_THE_FLY_KEY)) {
            return false;
        }
        String string = StringsKt.substringAfterLast$default((String)value2, (char)'\n', null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)this.stacktraceMark, (boolean)false, (int)2, null)) {
            return true;
        }
        int n = 0;
        Object object = new String[]{"\n"};
        object = CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)value2, (String[])object, (boolean)false, (int)0, (int)6, null), (int)this.linesToAnalyze);
        boolean bl = false;
        Object object2 = object;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Iterator iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            String string2 = (String)t;
            boolean bl3 = false;
            if (!(!StringsKt.isBlank((CharSequence)string2))) continue;
            collection.add(t);
        }
        List list2 = (List)collection;
        for (String string3 : list2) {
            if (this.STACKTRACE_LINE.matcher(string3).lookingAt()) {
                if (++n <= 2) continue;
                return true;
            }
            n = 0;
        }
        return false;
    }

    protected void handle(@NotNull Project project, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!SolutionHostExtensionsKt.getHasSolution((Project)project)) {
            return;
        }
        IOptProperty iOptProperty = SolutionHostExtensionsKt.getSolution((Project)project).isLoaded();
        if (!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)iOptProperty))) {
            return;
        }
        RiderStacktraceUtil.addAnalyzeExceptionTab$default(RiderStacktraceUtil.INSTANCE, project, value2, null, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/stacktrace/RiderStacktraceClipboardListener$Companion;", "", "RiderStacktraceClipboardListener$Companion", "()V", "STACK_TRACE_PREPOSITIONS", "", "getSTACK_TRACE_PREPOSITIONS$annotations", "ON_THE_FLY_KEY", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getSTACK_TRACE_PREPOSITIONS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

