/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.solutionAnalysis.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.OptionsMessageDialog;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.SolutionAnalysisAction;
import com.jetbrains.rider.model.SolutionAnalysisState;
import com.jetbrains.rider.solutionAnalysis.RiderSolutionAnalysisBundle;
import com.jetbrains.rider.solutionAnalysis.SolutionAnalysisHost;
import com.jetbrains.rider.solutionAnalysis.actions.SWEAActionBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/solutionAnalysis/actions/SWEAReanalyzeAllAction;", "Lcom/jetbrains/rider/solutionAnalysis/actions/SWEAActionBase;", "SWEAReanalyzeAllAction", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "SWEAConfirmationDialog", "intellij.rider"})
public class SWEAReanalyzeAllAction
extends SWEAActionBase {
    public SWEAReanalyzeAllAction() {
        super(AllIcons.Actions.Refresh);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getProject() == null) {
            return;
        }
        SolutionAnalysisHost solutionAnalysisHost = SolutionAnalysisHost.Companion.getInstance(e);
        if (solutionAnalysisHost == null) {
            return;
        }
        SolutionAnalysisHost solutionAnalysisHost2 = solutionAnalysisHost;
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        if (new SWEAConfirmationDialog(project).showAndGet()) {
            solutionAnalysisHost2.getModel().getRunAction().fire((Object)SolutionAnalysisAction.ReanalyzeAll);
        }
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        SolutionAnalysisHost solutionAnalysisHost = SolutionAnalysisHost.Companion.getInstance(e);
        if (solutionAnalysisHost == null) {
            return;
        }
        SolutionAnalysisHost solutionAnalysisHost2 = solutionAnalysisHost;
        if (!solutionAnalysisHost2.getHostReady() || !solutionAnalysisHost2.getLoaded()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)solutionAnalysisHost2.getModel().getState()))) {
            SolutionAnalysisState solutionAnalysisState = (SolutionAnalysisState)solutionAnalysisHost2.getModel().getState().getValueOrNull();
            e.getPresentation().setEnabled(solutionAnalysisState != null ? solutionAnalysisState.getEnabled() : false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0014J\b\u0010\f\u001a\u00020\u0007H\u0014J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\n\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/solutionAnalysis/actions/SWEAReanalyzeAllAction$SWEAConfirmationDialog;", "Lcom/intellij/util/ui/OptionsMessageDialog;", "project", "Lcom/intellij/openapi/project/Project;", "SWEAReanalyzeAllAction$SWEAConfirmationDialog", "(Lcom/intellij/openapi/project/Project;)V", "isToBeShown", "", "setToBeShown", "", "value", "onOk", "shouldSaveOptionsOnCancel", "getOkActionName", "", "getCancelActionName", "intellij.rider"})
    private static final class SWEAConfirmationDialog
    extends OptionsMessageDialog {
        public SWEAConfirmationDialog(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(project, RiderSolutionAnalysisBundle.Companion.message("SWEAReanalyzeAllAction.label.sure.to.drop.all.analysis.results", new Object[0]), RiderSolutionAnalysisBundle.Companion.message("SWEAReanalyzeAllAction.dialog.title.reanalyze.all", new Object[0]), null);
            this.setDoNotAskOption(null);
            this.init();
        }

        protected boolean isToBeShown() {
            throw new UnsupportedOperationException();
        }

        protected void setToBeShown(boolean value2, boolean onOk) {
            throw new UnsupportedOperationException();
        }

        protected boolean shouldSaveOptionsOnCancel() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        protected String getOkActionName() {
            return CommonBundle.getYesButtonText();
        }

        @Nullable
        protected String getCancelActionName() {
            return CommonBundle.getNoButtonText();
        }
    }
}

