/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.perApp.wm;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.DesktopLayout;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerState;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.jetbrains.rider.settings.perApp.RiderPerAppRefreshable;
import com.jetbrains.rider.settings.perApp.RiderPerAppSettingsManager;
import com.jetbrains.rider.settings.perApp.wm.RiderPerAppToolWindowLayoutManager;
import com.jetbrains.rider.settings.perApp.wm.RiderPerAppToolWindowRefreshableKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/settings/perApp/wm/RiderPerAppToolWindowRefreshable;", "Lcom/jetbrains/rider/settings/perApp/RiderPerAppRefreshable;", "RiderPerAppToolWindowRefreshable", "()V", "settingsManager", "Lcom/jetbrains/rider/settings/perApp/RiderPerAppSettingsManager;", "x", "()Lcom/jetbrains/rider/settings/perApp/RiderPerAppSettingsManager;", "beforeRefresh", "", "oldProject", "Lcom/intellij/openapi/project/Project;", "refresh", "newProject", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderPerAppToolWindowRefreshable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderPerAppToolWindowRefreshable.kt\ncom/jetbrains/rider/settings/perApp/wm/RiderPerAppToolWindowRefreshable\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,46:1\n42#2,3:47\n42#2,3:58\n42#2,3:65\n42#2,3:68\n67#3,4:50\n67#3,4:54\n67#3,4:61\n67#3,4:71\n30#4,2:75\n*S KotlinDebug\n*F\n+ 1 RiderPerAppToolWindowRefreshable.kt\ncom/jetbrains/rider/settings/perApp/wm/RiderPerAppToolWindowRefreshable\n*L\n15#1:47,3\n21#1:58,3\n30#1:65,3\n32#1:68,3\n17#1:50,4\n20#1:54,4\n26#1:61,4\n39#1:71,4\n40#1:75,2\n*E\n"})
public final class RiderPerAppToolWindowRefreshable
implements RiderPerAppRefreshable {
    private final RiderPerAppSettingsManager x() {
        boolean bl = false;
        Class<RiderPerAppSettingsManager> clazz = RiderPerAppSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(clazz);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (RiderPerAppSettingsManager)object;
    }

    @Override
    public void beforeRefresh(@NotNull Project oldProject) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)oldProject, (String)"oldProject");
        Logger logger2 = RiderPerAppToolWindowRefreshableKt.access$getLogger$p();
        boolean bl = false;
        if (logger2.isTraceEnabled()) {
            logger = logger2;
            boolean bl2 = false;
            logger.trace("Before refresh for project " + oldProject + ".");
        }
        logger2 = ToolWindowManager.Companion.getInstance(oldProject);
        Intrinsics.checkNotNull((Object)logger2, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowManagerEx");
        DesktopLayout desktopLayout = ((ToolWindowManagerEx)logger2).getLayout();
        Logger logger3 = RiderPerAppToolWindowRefreshableKt.access$getLogger$p();
        boolean bl3 = false;
        if (logger3.isTraceEnabled()) {
            logger = logger3;
            boolean bl4 = false;
            WindowInfoImpl windowInfoImpl = desktopLayout.getInfo("Project");
            logger.trace("Applying layout to project " + oldProject + " (project view weight: " + (windowInfoImpl != null ? Float.valueOf(windowInfoImpl.getWeight()) : null) + ").");
        }
        boolean bl5 = false;
        Class<RiderPerAppToolWindowLayoutManager> clazz = RiderPerAppToolWindowLayoutManager.class;
        Object object = ApplicationManager.getApplication().getService(clazz);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        ((RiderPerAppToolWindowLayoutManager)object).setLayout(desktopLayout);
    }

    @Override
    public void refresh(@NotNull Project newProject) {
        DesktopLayout desktopLayout;
        boolean bl;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)newProject, (String)"newProject");
        if (!this.x().hasProjectForRefresh(newProject)) {
            return;
        }
        Logger logger2 = RiderPerAppToolWindowRefreshableKt.access$getLogger$p();
        boolean bl2 = false;
        if (logger2.isTraceEnabled()) {
            logger = logger2;
            bl = false;
            logger.trace("Will schedule tool window layout refresh for project " + newProject + ".");
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(newProject);
        Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.impl.ToolWindowManagerImpl");
        logger2 = (ToolWindowManagerImpl)toolWindowManager;
        logger2.setMoreButtonSide(logger2.getMoreButtonSide());
        bl = false;
        Class clazz = RiderPerAppSettingsManager.class;
        Object object = ApplicationManager.getApplication().getService(clazz);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        if (((RiderPerAppSettingsManager)object).getState().getToolWindowsPerApp()) {
            RiderPerAppToolWindowRefreshableKt.access$getLogger$p().trace("Application-wide tool window is active. Grabbing a copy of the globally stored layout.");
            bl = false;
            clazz = RiderPerAppToolWindowLayoutManager.class;
            Object object2 = ApplicationManager.getApplication().getService(clazz);
            if (object2 == null) {
                throw new RuntimeException("Cannot find service " + clazz.getName() + " (classloader=" + clazz.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            desktopLayout = ((RiderPerAppToolWindowLayoutManager)object2).getLayoutCopy();
        } else {
            RiderPerAppToolWindowRefreshableKt.access$getLogger$p().trace("Application-wide tool window is not active. Grabbing a copy of the per-project layout.");
            desktopLayout = logger2.getLayout();
        }
        DesktopLayout desktopLayout2 = desktopLayout;
        Logger logger3 = RiderPerAppToolWindowRefreshableKt.access$getLogger$p();
        boolean bl3 = false;
        if (logger3.isTraceEnabled()) {
            logger = logger3;
            boolean bl4 = false;
            WindowInfoImpl windowInfoImpl = desktopLayout2.getInfo("Project");
            logger.trace("Scheduling a layout for project " + newProject + " to be set (project view weight: " + (windowInfoImpl != null ? Float.valueOf(windowInfoImpl.getWeight()) : null) + ").");
        }
        logger3 = (ComponentManager)newProject;
        bl3 = false;
        Class<ToolWindowManagerState> clazz2 = ToolWindowManagerState.class;
        Object object3 = logger3.getService(clazz2);
        if (object3 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)logger3, clazz2);
        }
        ((ToolWindowManagerState)object3).getScheduledLayout().set((Object)desktopLayout2);
        this.x().removeProjectFromRefreshSet(newProject);
    }
}

