/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.layers;

import com.intellij.CommonBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionToolbarListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.ui.JBDimension;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.actions.RiderActionPlaces;
import com.jetbrains.rider.actions.base.RiderBackendOnlyGroup;
import com.jetbrains.rider.model.LayersModel;
import com.jetbrains.rider.model.ManageLayersDialog;
import com.jetbrains.rider.model.ManageLayersDialogContent;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.layers.LayersDialog;
import com.jetbrains.rider.settings.layers.LayersDialogKt;
import com.jetbrains.rider.settings.layers.LayersTreeFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0010H\u0014J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rider/settings/layers/LayersDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "model", "Lcom/jetbrains/rider/model/LayersModel;", "outerLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "LayersDialog", "(Lcom/jetbrains/rider/model/LayersModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "lifetime", "myManageLayersDialog", "Lcom/jetbrains/rider/model/ManageLayersDialog;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "doHelpAction", "", "getInitialLocation", "Ljava/awt/Point;", "getDimensionServiceKey", "", "createCenterPanel", "Ljavax/swing/JComponent;", "dispose", "x", "panel", "Ljavax/swing/JPanel;", "content", "Lcom/jetbrains/rider/model/ManageLayersDialogContent;", "lt", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nLayersDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayersDialog.kt\ncom/jetbrains/rider/settings/layers/LayersDialog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,173:1\n67#2,4:174\n67#2,4:178\n67#2,4:182\n*S KotlinDebug\n*F\n+ 1 LayersDialog.kt\ncom/jetbrains/rider/settings/layers/LayersDialog\n*L\n111#1:174,4\n116#1:178,4\n130#1:182,4\n*E\n"})
public final class LayersDialog
extends DialogWrapper {
    @NotNull
    private final LayersModel model;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final ManageLayersDialog myManageLayersDialog;

    public LayersDialog(@NotNull LayersModel model, @NotNull Lifetime outerLifetime) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)outerLifetime, (String)"outerLifetime");
        super(true);
        this.model = model;
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        this.lifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
        this.myManageLayersDialog = new ManageLayersDialog();
        LayersDialogKt.access$getLogger$p().debug("before init");
        this.setModal(false);
        this.setTitle(SystemInfo.isMac ? RiderSettingsBundle.Companion.message("LayersDialog.dialog.title.settings.layers.macos", new Object[0]) : RiderSettingsBundle.Companion.message("LayersDialog.dialog.title.settings.layers", new Object[0]));
        this.init();
        LayersDialogKt.access$getLogger$p().debug("after init");
        outerLifetime.onTermination(() -> LayersDialog.x(this));
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = CommonBundle.message((String)"close.action.name", (Object[])new Object[0]);
        DialogWrapper.DialogWrapperAction dialogWrapperAction = new DialogWrapper.DialogWrapperAction(this, (String)actionArray){
            final /* synthetic */ LayersDialog this$0;
            {
                this.this$0 = $receiver;
                super((DialogWrapper)$receiver, $super_call_param$1);
            }

            protected void doAction(ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.close(0);
            }
        };
        actionArray = new Action[2];
        actionArray[0] = dialogWrapperAction;
        Intrinsics.checkNotNullExpressionValue((Object)this.getHelpAction(), (String)"getHelpAction(...)");
        return actionArray;
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)"https://www.jetbrains.com/help/rider/Sharing_Configuration_Options.html");
    }

    @NotNull
    public Point getInitialLocation() {
        Point point = this.getOwner().getLocation();
        Dimension dimension = this.getOwner().getSize();
        double d = 0.33;
        return new Point(point.x + (int)((double)dimension.width * d), point.y + (int)((double)dimension.height * d));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "LayersDialog";
    }

    @NotNull
    protected JComponent createCenterPanel() {
        LayersDialogKt.access$getLogger$p().debug("createCenterPanel");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        LayoutManager layoutManager = new BorderLayout();
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        JBLoadingPanel jBLoadingPanel = new JBLoadingPanel(layoutManager, disposable, 0, 4, null);
        jBLoadingPanel.startLoading();
        jPanel.add((Component)jBLoadingPanel);
        jPanel.setMinimumSize((Dimension)new JBDimension(600, 350));
        InterfacesKt.viewNotNull((IViewable)((IViewable)this.myManageLayersDialog.getContent()), (Lifetime)this.lifetime, (arg_0, arg_1) -> LayersDialog.x(jBLoadingPanel, this, jPanel, arg_0, arg_1));
        this.model.getManageLayersDialog().setValue((Object)this.myManageLayersDialog);
        return jPanel;
    }

    protected void dispose() {
        this.model.getManageLayersDialog().setValue(null);
        super.dispose();
    }

    private final void x(JPanel jPanel, ManageLayersDialogContent manageLayersDialogContent, Lifetime lifetime) {
        JPanel jPanel2;
        boolean bl;
        Logger logger;
        LayersDialogKt.access$getLogger$p().trace("Repainting layers.");
        LayersTreeFactory layersTreeFactory = new LayersTreeFactory();
        ActionManager actionManager = ActionManager.getInstance();
        String string = manageLayersDialogContent.getActionGroupId();
        Object object = LayersDialogKt.access$getLogger$p();
        boolean bl2 = false;
        if (object.isTraceEnabled()) {
            logger = object;
            boolean bl3 = false;
            logger.trace("New action update enabled. Initialize RiderBackendOnlyGroup(" + string + ").");
        }
        object = new RiderBackendOnlyGroup(string){};
        AnAction anAction = actionManager.getAction("RiderEditSettingsLayerOptions");
        ActionGroup actionGroup2 = (ActionGroup)object;
        Intrinsics.checkNotNull((Object)anAction);
        TreeTable treeTable2 = layersTreeFactory.createTree(manageLayersDialogContent, actionGroup2, anAction, lifetime);
        Logger logger2 = LayersDialogKt.access$getLogger$p();
        boolean bl4 = false;
        if (logger2.isTraceEnabled()) {
            logger = logger2;
            bl = false;
            logger.trace("Tree " + treeTable2 + " created.");
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(RiderActionPlaces.INSTANCE.getSETTINGS_LAYERS_DIALOG(), (ActionGroup)object, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        logger2 = actionToolbar;
        LayersDialogKt.access$getLogger$p().trace("Action toolbar created.");
        if (LayersDialogKt.access$getLogger$p().isTraceEnabled()) {
            logger2.addListener(new ActionToolbarListener((ActionToolbar)logger2, actionManager){
                final /* synthetic */ ActionToolbar $toolbar;
                final /* synthetic */ ActionManager $actionManager;
                {
                    this.$toolbar = $toolbar;
                    this.$actionManager = $actionManager;
                }

                public void actionsUpdated() {
                    LayersDialogKt.access$getLogger$p().trace("Actions on toolbar updated.");
                    List list2 = this.$toolbar.getActions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getActions(...)");
                    List list3 = list2;
                    LayersDialogKt.access$getLogger$p().trace("Actions count: " + list3.size() + ".");
                    LayersDialogKt.access$getLogger$p().trace("Actions: " + CollectionsKt.joinToString$default((Iterable)list3, null, null, null, (int)0, null, arg_0 -> repaintLayers.3.x(this.$actionManager, arg_0), (int)31, null) + ".");
                }

                private static final CharSequence x(ActionManager actionManager, AnAction anAction) {
                    Intrinsics.checkNotNull((Object)anAction);
                    return LayersDialog.access$repaintLayers$getActionId(anAction, actionManager);
                }
            }, LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)"rider.settings.layers.LayersDialog::repaintLayers"));
        }
        logger2.setTargetComponent((JComponent)treeTable2);
        Logger logger3 = LayersDialogKt.access$getLogger$p();
        bl = false;
        if (logger3.isTraceEnabled()) {
            logger = logger3;
            boolean bl5 = false;
            logger.trace("Toolbar initialized for a tree component " + treeTable2 + ".");
        }
        int n = -1;
        Component[] componentArray = jPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        if (!(((Object[])componentArray).length == 0)) {
            Component[] componentArray2 = jPanel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray2, (String)"getComponents(...)");
            Component component2 = (Component)ArraysKt.last((Object[])componentArray2);
            if (component2 instanceof TreeTable) {
                n = ((TreeTable)component2).getSelectedRow();
            }
        }
        jPanel.removeAll();
        Serializable serializable = jPanel2 = new JPanel(new BorderLayout());
        int n2 = 0;
        serializable.add(logger2.getComponent(), "Center");
        serializable.setPreferredSize((Dimension)new JBDimension(1, 29));
        JPanel jPanel3 = jPanel2;
        jPanel.add((Component)jPanel3, "First");
        jPanel2 = new JBScrollPane((Component)treeTable2);
        serializable = jPanel2.getMinimumSize();
        jPanel2.setMinimumSize(new Dimension(((Dimension)serializable).width, 100));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.setBackground((Color)JBColor.LIGHT_GRAY);
        jPanel.validate();
        jPanel.repaint();
        this.repaint();
        treeTable2.requestFocus();
        n2 = treeTable2.getRowCount();
        if (n2 == 0) {
            return;
        }
        int n3 = 0;
        if (n >= 0 && n < n2) {
            n3 = n;
        }
        treeTable2.getSelectionModel().addSelectionInterval(n3, n3);
    }

    private static final Unit x(LayersDialog layersDialog) {
        layersDialog.close(1);
        return Unit.INSTANCE;
    }

    private static final Unit x(JBLoadingPanel jBLoadingPanel, LayersDialog layersDialog, JPanel jPanel, Lifetime lifetime, ManageLayersDialogContent manageLayersDialogContent) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)manageLayersDialogContent, (String)"content");
        jBLoadingPanel.stopLoading();
        LayersDialogKt.access$getLogger$p().debug("reload layers");
        layersDialog.x(jPanel, manageLayersDialogContent, lifetime);
        manageLayersDialogContent.getLayers().advise(lifetime, arg_0 -> LayersDialog.x(layersDialog, jPanel, manageLayersDialogContent, lifetime, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit x(LayersDialog layersDialog, JPanel jPanel, ManageLayersDialogContent manageLayersDialogContent, Lifetime lifetime, List list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"it");
        layersDialog.x(jPanel, manageLayersDialogContent, lifetime);
        return Unit.INSTANCE;
    }

    private static final String x(AnAction anAction, ActionManager actionManager) {
        String string = actionManager.getId(anAction);
        if (string == null) {
            string = "<unknown action>";
        }
        return string;
    }

    public static final /* synthetic */ String access$repaintLayers$getActionId(AnAction $receiver, ActionManager actionManager) {
        return LayersDialog.x($receiver, actionManager);
    }
}

