/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.codeCleanup.model;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.actions.impl.cleanup.FrontendReformatCleanupProfileModel;
import com.jetbrains.rider.model.CleanupProfileModel;
import com.jetbrains.rider.settings.SaveToLayerListener;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import com.jetbrains.rider.settings.codeCleanup.model.IdeaCleanupProfileUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u000bJ\u0006\u0010\u0010\u001a\u00020\tJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/settings/codeCleanup/model/InspectionProfileHolder;", "Lcom/jetbrains/rider/settings/SaveToLayerListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rider/model/CleanupProfileModel;", "InspectionProfileHolder", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/CleanupProfileModel;)V", "profile", "Lcom/intellij/codeInspection/ex/InspectionProfileModifiableModel;", "reformatProfile", "Lcom/jetbrains/rider/actions/impl/cleanup/FrontendReformatCleanupProfileModel;", "isReadOnly", "", "()Z", "getReformatProfile", "getProfile", "onSave", "", "layerName", "", "save", "intellij.rider"})
public final class InspectionProfileHolder
implements SaveToLayerListener {
    @NotNull
    private final CleanupProfileModel model;
    @Nullable
    private InspectionProfileModifiableModel profile;
    @Nullable
    private FrontendReformatCleanupProfileModel reformatProfile;

    public InspectionProfileHolder(@Nullable Lifetime lifetime, @NotNull CleanupProfileModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        if (lifetime != null) {
            SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
            if (!this.isReadOnly() && settingsViewModelHost != null) {
                settingsViewModelHost.addSaveToLayerListener(lifetime, (SaveToLayerListener)this);
            }
        }
    }

    public final boolean isReadOnly() {
        return this.model.isReadOnly();
    }

    @NotNull
    public final FrontendReformatCleanupProfileModel getReformatProfile() {
        FrontendReformatCleanupProfileModel frontendReformatCleanupProfileModel;
        FrontendReformatCleanupProfileModel frontendReformatCleanupProfileModel2 = this.reformatProfile;
        if (frontendReformatCleanupProfileModel2 != null) {
            return frontendReformatCleanupProfileModel2;
        }
        String string = this.model.getInitialRiderCounterpartProfile();
        this.reformatProfile = frontendReformatCleanupProfileModel = new FrontendReformatCleanupProfileModel(string);
        return frontendReformatCleanupProfileModel;
    }

    @NotNull
    public final InspectionProfileModifiableModel getProfile() {
        InspectionProfileModifiableModel inspectionProfileModifiableModel;
        InspectionProfileModifiableModel inspectionProfileModifiableModel2 = this.profile;
        if (inspectionProfileModifiableModel2 != null) {
            return inspectionProfileModifiableModel2;
        }
        String string = this.model.getInitialIdeaCounterpartProfile();
        String string2 = (String)InterfacesKt.valueOrDefault((IOptProperty)this.model.getProfileName(), (Object)"");
        InspectionProfileImpl inspectionProfileImpl = IdeaCleanupProfileUtilsKt.deserialize(string, string2);
        this.profile = inspectionProfileModifiableModel = new InspectionProfileModifiableModel(inspectionProfileImpl);
        return inspectionProfileModifiableModel;
    }

    public void onSave(@Nullable String layerName) {
        this.save();
    }

    public final void save() {
        Object object;
        if (this.model.isReadOnly()) {
            return;
        }
        InspectionProfileModifiableModel inspectionProfileModifiableModel = this.profile;
        if (inspectionProfileModifiableModel != null) {
            inspectionProfileModifiableModel.setName((String)InterfacesKt.valueOrDefault((IOptProperty)this.model.getProfileName(), (Object)""));
            inspectionProfileModifiableModel.commit();
            String string = IdeaCleanupProfileUtilsKt.serialize(inspectionProfileModifiableModel.getSource());
            if (string == null) {
                return;
            }
            object = string;
            this.model.getSetNewIdeaCounterpartProfile().start(object);
        }
        if ((object = this.reformatProfile) != null) {
            String string = ((FrontendReformatCleanupProfileModel)object).serialize();
            this.model.getSetNewRiderCounterpartProfile().start((Object)string);
        }
    }
}

