/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.settings.codeCleanup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.CleanupProfileModel;
import com.jetbrains.rider.model.CodeCleanupOptionsPageContent;
import com.jetbrains.rider.model.OptionsPageContentBase;
import com.jetbrains.rider.settings.IRiderViewModelConfigurable;
import com.jetbrains.rider.settings.RiderSettingsBundle;
import com.jetbrains.rider.settings.SettingsViewModelHost;
import com.jetbrains.rider.settings.codeCleanup.CodeCleanupOptionsPageController;
import com.jetbrains.rider.settings.simple.SimpleOptionsPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0001(B\u0019\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0018H\u0016J\b\u0010'\u001a\u00020\u0018H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lcom/jetbrains/rider/settings/codeCleanup/CodeCleanupOptionsPage;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "Lcom/intellij/openapi/options/Configurable;", "Lcom/jetbrains/rider/settings/IRiderViewModelConfigurable;", "Lcom/intellij/openapi/Disposable;", "profileToPreselect", "", "addSetAsDefaultAction", "", "CodeCleanupOptionsPage", "(Ljava/lang/String;Z)V", "()V", "getProfileToPreselect", "()Ljava/lang/String;", "getAddSetAsDefaultAction", "()Z", "pageId", "getHelpTopic", "reSharperPagesId", "", "getReSharperPagesId", "()Ljava/lang/Iterable;", "isModified", "apply", "", "getDisplayName", "lastSelectedProfileName", "getLastSelectedProfileName", "setLastSelectedProfileName", "(Ljava/lang/String;)V", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "x", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lifetime$delegate", "Lkotlin/Lazy;", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "dispose", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nCodeCleanupOptionsPage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeCleanupOptionsPage.kt\ncom/jetbrains/rider/settings/codeCleanup/CodeCleanupOptionsPage\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n13#2:108\n13#3:109\n*S KotlinDebug\n*F\n+ 1 CodeCleanupOptionsPage.kt\ncom/jetbrains/rider/settings/codeCleanup/CodeCleanupOptionsPage\n*L\n29#1:108\n29#1:109\n*E\n"})
public final class CodeCleanupOptionsPage
implements Configurable.NoScroll,
Configurable,
IRiderViewModelConfigurable,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String profileToPreselect;
    private final boolean addSetAsDefaultAction;
    @NotNull
    private final String pageId;
    @Nullable
    private String lastSelectedProfileName;
    @NotNull
    private final Lazy lifetime$delegate;
    @NotNull
    private static final Logger LOG;

    public CodeCleanupOptionsPage(@Nullable String profileToPreselect, boolean addSetAsDefaultAction) {
        this.profileToPreselect = profileToPreselect;
        this.addSetAsDefaultAction = addSetAsDefaultAction;
        this.pageId = "CodeCleanupOptionsPage";
        this.lifetime$delegate = LazyKt.lazy(() -> CodeCleanupOptionsPage.x(this));
    }

    @Nullable
    public final String getProfileToPreselect() {
        return this.profileToPreselect;
    }

    public final boolean getAddSetAsDefaultAction() {
        return this.addSetAsDefaultAction;
    }

    public CodeCleanupOptionsPage() {
        this(null, true);
    }

    @NotNull
    public String getHelpTopic() {
        return "Settings_Code_Cleanup";
    }

    @NotNull
    public Iterable<String> getReSharperPagesId() {
        Object[] objectArray = new String[]{this.pageId};
        return ArraysKt.asIterable((Object[])objectArray);
    }

    public boolean isModified() {
        return false;
    }

    public void apply() {
    }

    @NotNull
    public String getDisplayName() {
        return RiderSettingsBundle.Companion.message("CodeCleanupOptionsPage.configurable.name.code.cleanup.options", new Object[0]);
    }

    @Nullable
    public final String getLastSelectedProfileName() {
        return this.lastSelectedProfileName;
    }

    public final void setLastSelectedProfileName(@Nullable String string) {
        this.lastSelectedProfileName = string;
    }

    private final Lifetime x() {
        Lazy lazy = this.lifetime$delegate;
        return (Lifetime)lazy.getValue();
    }

    @NotNull
    public JComponent createComponent() {
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        borderLayoutPanel.setMinimumSize((Dimension)JBUI.size((int)400, (int)200));
        JBLoadingPanel jBLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 0, 4, null);
        jBLoadingPanel.startLoading();
        borderLayoutPanel.addToCenter((Component)jBLoadingPanel);
        SettingsViewModelHost settingsViewModelHost = SettingsViewModelHost.Companion.getCurrentInstance();
        if (settingsViewModelHost == null) {
            return (JComponent)borderLayoutPanel;
        }
        SettingsViewModelHost settingsViewModelHost2 = settingsViewModelHost;
        settingsViewModelHost2.requestPage(this.pageId, arg_0 -> CodeCleanupOptionsPage.x(jBLoadingPanel, borderLayoutPanel, this, arg_0));
        return (JComponent)borderLayoutPanel;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    private static final Lifetime x(CodeCleanupOptionsPage codeCleanupOptionsPage) {
        return LifetimeDisposableExKt.createLifetime((Disposable)codeCleanupOptionsPage);
    }

    private static final Unit x(JBLoadingPanel jBLoadingPanel, BorderLayoutPanel borderLayoutPanel, CodeCleanupOptionsPage codeCleanupOptionsPage, OptionsPageContentBase optionsPageContentBase) {
        Intrinsics.checkNotNullParameter((Object)optionsPageContentBase, (String)"content");
        if (optionsPageContentBase instanceof CodeCleanupOptionsPageContent) {
            jBLoadingPanel.stopLoading();
            borderLayoutPanel.removeAll();
            if (codeCleanupOptionsPage.profileToPreselect != null) {
                ((CodeCleanupOptionsPageContent)optionsPageContentBase).getProfiles().view(codeCleanupOptionsPage.x(), (arg_0, arg_1, arg_2) -> CodeCleanupOptionsPage.x(codeCleanupOptionsPage, optionsPageContentBase, arg_0, arg_1, arg_2));
            }
            JComponent jComponent = new CodeCleanupOptionsPageController(codeCleanupOptionsPage, (CodeCleanupOptionsPageContent)optionsPageContentBase, codeCleanupOptionsPage.addSetAsDefaultAction).createView();
            borderLayoutPanel.addToCenter((Component)jComponent);
            ((CodeCleanupOptionsPageContent)optionsPageContentBase).getSelectedProfile().view(codeCleanupOptionsPage.x(), (arg_0, arg_1) -> CodeCleanupOptionsPage.x(optionsPageContentBase, codeCleanupOptionsPage, arg_0, arg_1));
            borderLayoutPanel.validate();
            borderLayoutPanel.repaint();
            jComponent.grabFocus();
            return Unit.INSTANCE;
        }
        LOG.error("Unexpected page content " + optionsPageContentBase);
        return Unit.INSTANCE;
    }

    private static final Unit x(CodeCleanupOptionsPage codeCleanupOptionsPage, OptionsPageContentBase optionsPageContentBase, Lifetime lifetime, String string, CleanupProfileModel cleanupProfileModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"uid");
        Intrinsics.checkNotNullParameter((Object)cleanupProfileModel, (String)"profile");
        if (Intrinsics.areEqual((Object)cleanupProfileModel.getProfileName().getValueOrNull(), (Object)codeCleanupOptionsPage.profileToPreselect)) {
            ApplicationKt.getApplication().invokeLater(() -> CodeCleanupOptionsPage.x(optionsPageContentBase, string));
        }
        return Unit.INSTANCE;
    }

    private static final void x(OptionsPageContentBase optionsPageContentBase, String string) {
        ((CodeCleanupOptionsPageContent)optionsPageContentBase).getSelectedProfile().set((Object)string);
    }

    private static final Unit x(OptionsPageContentBase optionsPageContentBase, CodeCleanupOptionsPage codeCleanupOptionsPage, Lifetime lifetime, String string) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
            Intrinsics.checkNotNullParameter((Object)string, (String)"value");
            CleanupProfileModel cleanupProfileModel = (CleanupProfileModel)((CodeCleanupOptionsPageContent)optionsPageContentBase).getProfiles().get((Object)string);
            CleanupProfileModel cleanupProfileModel2 = cleanupProfileModel;
            if (cleanupProfileModel2 == null || (cleanupProfileModel2 = cleanupProfileModel2.getProfileName()) == null) break block0;
            cleanupProfileModel2.view(lifetime, (arg_0, arg_1) -> CodeCleanupOptionsPage.x(codeCleanupOptionsPage, arg_0, arg_1));
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(CodeCleanupOptionsPage codeCleanupOptionsPage, Lifetime lifetime, String string) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"profileName");
        codeCleanupOptionsPage.lastSelectedProfileName = string;
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(SimpleOptionsPage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/settings/codeCleanup/CodeCleanupOptionsPage$Companion;", "", "CodeCleanupOptionsPage$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

