/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.services.security;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.TrustedPathsSettingsKt;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.ide.model.RdExistingSolution;
import com.jetbrains.rd.ide.model.RdSolutionDescription;
import com.jetbrains.rd.ide.model.RdVirtualSolution;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.inTests.PerformancePlaybackTestsKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.services.security.TrustedSolutionManager;
import com.jetbrains.rider.services.security.TrustedSolutionStore;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\bJJ\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\b2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0017\u001a\u00020\u00152\b\b\u0001\u0010\u0018\u001a\u00020\u00152\b\b\u0001\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/services/security/TrustedSolutionManager;", "", "TrustedSolutionManager", "()V", "isTrusted", "", "projectIdeaDirectories", "", "Ljava/nio/file/Path;", "solutionDirectory", "solutionDescription", "Lcom/jetbrains/rd/ide/model/RdSolutionDescription;", "isProjectTrusted", "project", "Lcom/intellij/openapi/project/Project;", "projectFilePath", "isDirectoryTrusted", "directoryPath", "x", "path", "titleText", "", "questionText", "bodyText", "trustActionText", "cancelActionText", "x", "SecurityDialog", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nTrustedSolutionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrustedSolutionManager.kt\ncom/jetbrains/rider/services/security/TrustedSolutionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n1761#2,3:219\n*S KotlinDebug\n*F\n+ 1 TrustedSolutionManager.kt\ncom/jetbrains/rider/services/security/TrustedSolutionManager\n*L\n42#1:219,3\n*E\n"})
public final class TrustedSolutionManager {
    @NotNull
    public static final TrustedSolutionManager INSTANCE = new TrustedSolutionManager();

    private TrustedSolutionManager() {
    }

    public final boolean isTrusted(@NotNull List<? extends Path> projectIdeaDirectories, @NotNull Path solutionDirectory2, @NotNull RdSolutionDescription solutionDescription) {
        Triple triple;
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        Object object4;
        block14: {
            Intrinsics.checkNotNullParameter(projectIdeaDirectories, (String)"projectIdeaDirectories");
            Intrinsics.checkNotNullParameter((Object)solutionDirectory2, (String)"solutionDirectory");
            Intrinsics.checkNotNullParameter((Object)solutionDescription, (String)"solutionDescription");
            if (this.x(solutionDirectory2)) {
                return true;
            }
            TrustedSolutionStore trustedSolutionStore = TrustedSolutionStore.Companion.getInstance();
            object4 = projectIdeaDirectories;
            boolean bl2 = false;
            if (object4 instanceof Collection && ((Collection)object4).isEmpty()) {
                bl = false;
            } else {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    object = (Path)object2;
                    boolean bl3 = false;
                    if (!(object != null && trustedSolutionStore.isTrusted((Path)object))) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        object4 = ApplicationNamesInfo.getInstance().getFullProductName();
        object2 = solutionDescription;
        if (object2 instanceof RdExistingSolution) {
            object = (String)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)((RdExistingSolution)solutionDescription).getSolutionDisplayName()));
            Object[] objectArray = new Object[]{object};
            String string = RiderBundle.message("untrusted.solution.dialog.title", objectArray);
            objectArray = new Object[]{object};
            String string2 = RiderBundle.message("untrusted.solution.dialog.question", objectArray);
            objectArray = new Object[2];
            objectArray[0] = object;
            Intrinsics.checkNotNull((Object)object4);
            objectArray[1] = object4;
            Triple triple2 = new Triple((Object)string, (Object)string2, (Object)RiderBundle.message("untrusted.solution.dialog.text", objectArray));
            triple = triple2;
        } else if (object2 instanceof RdVirtualSolution) {
            switch (((Collection)((RdVirtualSolution)solutionDescription).getProjectFilePaths()).size()) {
                case 0: {
                    String string = ((RdVirtualSolution)solutionDescription).getSolutionName();
                    Object[] objectArray = new Object[]{string};
                    String string3 = RiderBundle.message("untrusted.directory.dialog.title", objectArray);
                    objectArray = new Object[]{string};
                    String string4 = RiderBundle.message("untrusted.directory.dialog.question", objectArray);
                    objectArray = new Object[1];
                    Intrinsics.checkNotNull((Object)object4);
                    objectArray[0] = object4;
                    Triple triple3 = new Triple((Object)string3, (Object)string4, (Object)RiderBundle.message("untrusted.directory.dialog.text", objectArray));
                    triple = triple3;
                    break;
                }
                case 1: {
                    Path path = Path.of((String)CollectionsKt.single((List)((RdVirtualSolution)solutionDescription).getProjectFilePaths()), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                    String string = PathsKt.getNameWithoutExtension((Path)path);
                    Object[] objectArray = new Object[]{string};
                    String string5 = RiderBundle.message("untrusted.project.dialog.title", objectArray);
                    objectArray = new Object[]{string};
                    String string6 = RiderBundle.message("untrusted.project.dialog.question", objectArray);
                    objectArray = new Object[2];
                    objectArray[0] = string;
                    Intrinsics.checkNotNull((Object)object4);
                    objectArray[1] = object4;
                    Triple triple4 = new Triple((Object)string5, (Object)string6, (Object)RiderBundle.message("untrusted.project.dialog.text", objectArray));
                    triple = triple4;
                    break;
                }
                default: {
                    String string = ((RdVirtualSolution)solutionDescription).getSolutionName();
                    Object[] objectArray = new Object[]{string};
                    String string7 = RiderBundle.message("untrusted.solution.dialog.title", objectArray);
                    objectArray = new Object[]{string};
                    String string8 = RiderBundle.message("untrusted.solution.dialog.question", objectArray);
                    objectArray = new Object[2];
                    objectArray[0] = string;
                    Intrinsics.checkNotNull((Object)object4);
                    objectArray[1] = object4;
                    Triple triple5 = new Triple((Object)string7, (Object)string8, (Object)RiderBundle.message("untrusted.solution.dialog.text", objectArray));
                    triple = triple5;
                    break;
                }
            }
        } else {
            triple = null;
        }
        if (triple == null) {
            return true;
        }
        Triple triple6 = triple;
        object3 = (String)triple6.component1();
        Object object5 = triple6.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"component2(...)");
        object2 = (String)object5;
        object = (String)triple6.component3();
        SecurityDialog securityDialog = new SecurityDialog((String)object3, (String)object2, (String)object, RiderActionsBundle.Companion.message("action.TrustedSolutionManager.trust.and.open.text", new Object[0]), RiderActionsBundle.Companion.message("action.TrustedSolutionManager.dont.open.text", new Object[0]));
        return securityDialog.showAndGet();
    }

    public final boolean isProjectTrusted(@NotNull Project project, @NotNull Path projectFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        String string = PathsKt.getNameWithoutExtension((Path)projectFilePath);
        String string2 = ApplicationNamesInfo.getInstance().getFullProductName();
        Object[] objectArray = new Object[]{string};
        String string3 = RiderBundle.message("untrusted.project.dialog.title", objectArray);
        objectArray = new Object[]{string};
        String string4 = RiderBundle.message("untrusted.project.dialog.add.question", objectArray);
        objectArray = new Object[2];
        objectArray[0] = string;
        Intrinsics.checkNotNull((Object)string2);
        objectArray[1] = string2;
        return this.x(project, projectFilePath, string3, string4, RiderBundle.message("untrusted.project.dialog.text", objectArray), RiderActionsBundle.Companion.message("action.TrustedSolutionManager.trust.and.add.text", new Object[0]), RiderActionsBundle.Companion.message("action.TrustedSolutionManager.dont.add.text", new Object[0]));
    }

    public final boolean isDirectoryTrusted(@NotNull Project project, @NotNull Path directoryPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        String string = PathsKt.getName((Path)directoryPath);
        String string2 = ApplicationNamesInfo.getInstance().getFullProductName();
        Object[] objectArray = new Object[]{string};
        String string3 = RiderBundle.message("untrusted.directory.dialog.title", objectArray);
        objectArray = new Object[]{string};
        String string4 = RiderBundle.message("untrusted.directory.dialog.attach.question", objectArray);
        objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)string2);
        objectArray[0] = string2;
        return this.x(project, directoryPath, string3, string4, RiderBundle.message("untrusted.directory.dialog.text", objectArray), RiderActionsBundle.Companion.message("action.TrustedSolutionManager.trust.and.attach.text", new Object[0]), RiderActionsBundle.Companion.message("action.TrustedSolutionManager.dont.attach.text", new Object[0]));
    }

    private final boolean x(Project project, Path path, @Nls String string, @Nls String string2, @Nls String string3, @NlsActions.ActionText String string4, @NlsActions.ActionText String string5) {
        if (this.x(path)) {
            return true;
        }
        if (path.startsWith(SolutionHostExtensionsKt.getSolutionDirectory((Project)project).toPath())) {
            return true;
        }
        return new SecurityDialog(string, string2, string3, string4, string5).showAndGet();
    }

    private final boolean x(Path path) {
        TrustedSolutionStore trustedSolutionStore = TrustedSolutionStore.Companion.getInstance();
        if (trustedSolutionStore.isEverythingTrusted()) {
            return true;
        }
        return TrustedProjects.INSTANCE.isTrustedCheckDisabled() || TrustedPathsSettingsKt.isPathTrustedInSettings((Path)path) || PerformancePlaybackTestsKt.getApplicationIsPlayBackTestMode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000/\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0004*\u0001\u0014\b\u0002\u0018\u00002\u00020\u0001B9\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000f\u001a\u00020\u000bH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0011H\u0014J\u0017\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/services/security/TrustedSolutionManager$SecurityDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "titleText", "", "questionText", "bodyText", "trustActionText", "cancelActionText", "TrustedSolutionManager$SecurityDialog", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "mainPanel", "Ljavax/swing/JPanel;", "htmlBody", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "kotlin.jvm.PlatformType", "createCenterPanel", "getOKAction", "Ljavax/swing/Action;", "getCancelAction", "x", "com/jetbrains/rider/services/security/TrustedSolutionManager$SecurityDialog$multiLineLabelPane$1", "txt", "(Ljava/lang/String;)Lcom/jetbrains/rider/services/security/TrustedSolutionManager$SecurityDialog$multiLineLabelPane$1;", "intellij.rider"})
    private static final class SecurityDialog
    extends DialogWrapper {
        @NotNull
        private final String trustActionText;
        @NotNull
        private final String cancelActionText;
        @NotNull
        private final JPanel mainPanel;
        private final HtmlBuilder htmlBody;

        public SecurityDialog(@Nls @NotNull String titleText, @Nls @NotNull String questionText, @Nls @NotNull String bodyText, @NlsActions.ActionText @NotNull String trustActionText, @NlsActions.ActionText @NotNull String cancelActionText) {
            JComponent jComponent;
            JPanel jPanel;
            Intrinsics.checkNotNullParameter((Object)titleText, (String)"titleText");
            Intrinsics.checkNotNullParameter((Object)questionText, (String)"questionText");
            Intrinsics.checkNotNullParameter((Object)bodyText, (String)"bodyText");
            Intrinsics.checkNotNullParameter((Object)trustActionText, (String)"trustActionText");
            Intrinsics.checkNotNullParameter((Object)cancelActionText, (String)"cancelActionText");
            super(null, false);
            this.trustActionText = trustActionText;
            this.cancelActionText = cancelActionText;
            this.mainPanel = new JPanel();
            this.htmlBody = new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"b").addText(questionText)).br().br().append(bodyText).br().br().appendRaw(RiderBundle.message("untrusted.dialog.settings.html", new Object[0]));
            this.setTitle(titleText);
            JPanel jPanel2 = jPanel = this.mainPanel;
            boolean bl = false;
            jPanel2.setLayout((LayoutManager)new MigLayout("ins 0 0 5 0, fill, novisualpadding", "[]5[]", "[min!]"));
            Icon icon = null;
            Icon icon2 = AllIcons.General.NotificationInfo;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"NotificationInfo");
            icon = icon2;
            icon = IconUtil.resizeSquared((Icon)icon, (int)JBUI.scale((int)32));
            JPanel jPanel3 = jComponent = new JPanel();
            JPanel jPanel4 = jPanel2;
            boolean bl2 = false;
            jPanel3.add(new JLabel(icon));
            jPanel4.add((Component)jComponent, "cell 0 0, aligny top");
            String string = this.htmlBody.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            jPanel3 = jComponent = this.x(string);
            jPanel4 = jPanel2;
            bl2 = false;
            ((JEditorPane)((Object)jPanel3)).addHyperlinkListener(arg_0 -> SecurityDialog.x((Object)jPanel3, arg_0));
            jPanel4.add((Component)jComponent, "cell 1 0, width 0.5*pref, wmin 575");
            this.setResizable(false);
            this.init();
        }

        @NotNull
        protected JPanel createCenterPanel() {
            return this.mainPanel;
        }

        @NotNull
        protected Action getOKAction() {
            Action action2;
            Action action3 = super.getOKAction();
            Intrinsics.checkNotNullExpressionValue((Object)action3, (String)"getOKAction(...)");
            Action action4 = action2 = action3;
            boolean bl = false;
            action4.putValue("Name", this.trustActionText);
            return action2;
        }

        @NotNull
        protected Action getCancelAction() {
            Action action2;
            Action action3 = super.getCancelAction();
            Intrinsics.checkNotNullExpressionValue((Object)action3, (String)"getCancelAction(...)");
            Action action4 = action2 = action3;
            boolean bl = false;
            action4.putValue("Name", this.cancelActionText);
            return action2;
        }

        private final multiLineLabelPane.1 x(@Nls String string) {
            JTextPane jTextPane;
            JTextPane jTextPane2 = jTextPane = new JTextPane(){

                public Dimension getMaximumSize() {
                    return new Dimension(this.getWidth(), this.getPreferredSize().height + JBUI.scale((int)15));
                }

                public Dimension getMinimumSize() {
                    return new Dimension(this.getWidth(), this.getPreferredSize().height + JBUI.scale((int)15));
                }
            };
            boolean bl = false;
            jTextPane2.setContentType("text/html");
            jTextPane2.setEditable(false);
            jTextPane2.setBackground(null);
            jTextPane2.setFont((Font)JBUI.Fonts.label());
            jTextPane2.setBorder((Border)JBUI.Borders.empty());
            jTextPane2.setMargin((Insets)JBUI.emptyInsets());
            jTextPane2.putClientProperty("JEditorPane.honorDisplayProperties", true);
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
            styleSheet.addRule("body { font-family: " + jTextPane2.getFont().getFamily() + "; }");
            styleSheet.addRule("p { margin: 0 0 0 0; }");
            styleSheet.addRule("a {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + " }");
            jTextPane2.setEditorKit(hTMLEditorKit);
            jTextPane2.setText(string);
            return jTextPane;
        }

        private static final void x(multiLineLabelPane.1 var0, HyperlinkEvent hyperlinkEvent) {
            multiLineLabelPane.1 var2_2 = var0;
            boolean bl = false;
            HyperlinkEvent hyperlinkEvent2 = hyperlinkEvent;
            if ((hyperlinkEvent2 != null ? hyperlinkEvent2.getInputEvent() : null) instanceof MouseEvent) {
                InputEvent inputEvent = hyperlinkEvent.getInputEvent();
                MouseEvent mouseEvent = inputEvent instanceof MouseEvent ? (MouseEvent)inputEvent : null;
                boolean bl2 = mouseEvent != null ? mouseEvent.getClickCount() == 1 : false;
                if (bl2 && Intrinsics.areEqual((Object)hyperlinkEvent.getDescription(), (Object)"settings")) {
                    ShowSettingsUtil.getInstance().editConfigurable((Component)var2_2, RiderBundle.message("TrustedSolutionManager.configurable.name.trusted.locations", new Object[0]));
                }
            }
        }
    }
}

