/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.searchEverywhere.statistics;

import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/searchEverywhere/statistics/RiderSearchEverywhereTimeStat;", "", "RiderSearchEverywhereTimeStat", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getGROUP", "()Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "TIME_TO_BACKEND_TO_START", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "TIME_TO_BACKEND_TO_FINISH", "TIME_TO_BACKEND_TO_RESPOND", "TIME_TO_SEARCH_TO_FINISH", "SEARCH_SESSION_TIME", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "PerformanceStatistic", "intellij.rider"})
public final class RiderSearchEverywhereTimeStat {
    @NotNull
    public static final RiderSearchEverywhereTimeStat INSTANCE = new RiderSearchEverywhereTimeStat();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("rider.searchEverywhere", 3, null, 4, null);
    @NotNull
    private static final LongEventField TIME_TO_BACKEND_TO_START = EventFields.Long$default((String)"backendStartMs", null, (int)2, null);
    @NotNull
    private static final LongEventField TIME_TO_BACKEND_TO_FINISH = EventFields.Long$default((String)"backendFinishMs", null, (int)2, null);
    @NotNull
    private static final LongEventField TIME_TO_BACKEND_TO_RESPOND = EventFields.Long$default((String)"backendMs", null, (int)2, null);
    @NotNull
    private static final LongEventField TIME_TO_SEARCH_TO_FINISH = EventFields.Long$default((String)"searchFinishMs", null, (int)2, null);
    @NotNull
    private static final VarargEventId SEARCH_SESSION_TIME;

    private RiderSearchEverywhereTimeStat() {
    }

    @NotNull
    public final EventLogGroup getGROUP() {
        return GROUP;
    }

    static {
        EventField[] eventFieldArray = new EventField[5];
        Intrinsics.checkNotNullExpressionValue((Object)SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ID_FIELD, (String)"CONTRIBUTOR_ID_FIELD");
        eventFieldArray[1] = TIME_TO_BACKEND_TO_START;
        eventFieldArray[2] = TIME_TO_BACKEND_TO_FINISH;
        eventFieldArray[3] = TIME_TO_BACKEND_TO_RESPOND;
        eventFieldArray[4] = TIME_TO_SEARCH_TO_FINISH;
        SEARCH_SESSION_TIME = GROUP.registerVarargEvent("searchResultTime", eventFieldArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00192\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\nJ$\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0006\u0010 \u001a\u00020\u0019J$\u0010!\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007J\u0012\u0010#\u001a\u00020\u00192\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\b\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/searchEverywhere/statistics/RiderSearchEverywhereTimeStat$PerformanceStatistic;", "", "project", "Lcom/intellij/openapi/project/Project;", "RiderSearchEverywhereTimeStat$PerformanceStatistic", "(Lcom/intellij/openapi/project/Project;)V", "startTime", "", "dataMap", "", "Lcom/intellij/ide/actions/searcheverywhere/SearchEverywhereContributor;", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "lifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "currentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "currentSessionLifetime", "getCurrentSessionLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "includedContributors", "", "getIncludedContributors", "()Ljava/util/List;", "prepareStatistic", "", "addContributorToMeasure", "contributor", "x", "timeField", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "backendStartTime", "flushLoggedPerformanceStatistic", "measureBackendTime", "backendFinishTime", "measureFinishTime", "intellij.rider"})
    public static final class PerformanceStatistic {
        private long startTime;
        @NotNull
        private final Map<SearchEverywhereContributor<?>, List<EventPair<?>>> dataMap;
        @NotNull
        private final SequentialLifetimes lifetimes;
        @NotNull
        private Lifetime currentLifetime;

        public PerformanceStatistic(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.dataMap = new LinkedHashMap();
            this.lifetimes = new SequentialLifetimes(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)));
            this.currentLifetime = Lifetime.Companion.getTerminated();
        }

        @NotNull
        public final Lifetime getCurrentSessionLifetime() {
            return this.currentLifetime;
        }

        @NotNull
        public final List<SearchEverywhereContributor<?>> getIncludedContributors() {
            return CollectionsKt.toList((Iterable)this.dataMap.keySet());
        }

        public final void prepareStatistic() {
            this.dataMap.clear();
            this.startTime = System.currentTimeMillis();
            this.currentLifetime = (Lifetime)this.lifetimes.next();
        }

        public final void addContributorToMeasure(@NotNull SearchEverywhereContributor<?> contributor) {
            Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
            List list2 = this.dataMap.get(contributor);
            if (list2 == null) {
                list2 = new ArrayList();
            }
            List list3 = list2;
            list3.add(SearchEverywhereUsageTriggerCollector.CONTRIBUTOR_ID_FIELD.with((Object)contributor.getSearchProviderId()));
            this.dataMap.put(contributor, list3);
        }

        private final void x(LongEventField longEventField, SearchEverywhereContributor<?> searchEverywhereContributor, long l) {
            List<EventPair<?>> list2 = this.dataMap.get(searchEverywhereContributor);
            if (list2 == null) {
                throw new IllegalStateException("trying to record time for missing contributor".toString());
            }
            List<EventPair<?>> list3 = list2;
            list3.add(longEventField.with((Object)(l - this.startTime)));
        }

        public final void flushLoggedPerformanceStatistic() {
            Iterator<Map.Entry<SearchEverywhereContributor<?>, List<EventPair<?>>>> iterator2 = this.dataMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                List<EventPair<?>> list2 = iterator2.next().getValue();
                SEARCH_SESSION_TIME.log(list2);
            }
        }

        public final void measureBackendTime(@Nullable SearchEverywhereContributor<?> contributor, long backendStartTime, long backendFinishTime) {
            if (contributor == null) {
                return;
            }
            this.x(TIME_TO_BACKEND_TO_START, contributor, backendStartTime);
            this.x(TIME_TO_BACKEND_TO_FINISH, contributor, backendFinishTime);
            this.x(TIME_TO_BACKEND_TO_RESPOND, contributor, System.currentTimeMillis());
        }

        public final void measureFinishTime(@NotNull SearchEverywhereContributor<?> contributor) {
            Intrinsics.checkNotNullParameter(contributor, (String)"contributor");
            this.x(TIME_TO_SEARCH_TO_FINISH, contributor, System.currentTimeMillis());
        }
    }
}

