/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.runtime;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.runtime.custom.CustomDotNetCoreRuntimeType;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntimeType;
import com.jetbrains.rider.runtime.mono.MonoRuntimeType;
import com.jetbrains.rider.runtime.msNet.MsNetRuntimeType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/runtime/DotNetRuntimeType;", "", "name", "", "DotNetRuntimeType", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nDotNetRuntimeType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetRuntimeType.kt\ncom/jetbrains/rider/runtime/DotNetRuntimeType\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,47:1\n13#2:48\n*S KotlinDebug\n*F\n+ 1 DotNetRuntimeType.kt\ncom/jetbrains/rider/runtime/DotNetRuntimeType\n*L\n12#1:48\n*E\n"})
public abstract class DotNetRuntimeType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String MONO_CASE_SERIALIZED = "mono";
    @NotNull
    private static final String CORE_CASE_SERIALIZED = "coreclr";
    @NotNull
    private static final String FRAMEWORK_CASE_SERIALIZED = "netfw";
    @NotNull
    private static final String CUSTOM_CASE_SERIALIZED = "custom";

    public DotNetRuntimeType(@NlsSafe @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(DotNetRuntimeType.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DotNetRuntimeType.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/runtime/DotNetRuntimeType$Companion;", "", "DotNetRuntimeType$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "MONO_CASE_SERIALIZED", "", "CORE_CASE_SERIALIZED", "FRAMEWORK_CASE_SERIALIZED", "CUSTOM_CASE_SERIALIZED", "deserialize", "Lcom/jetbrains/rider/runtime/DotNetRuntimeType;", "id", "serialize", "runtimeType", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DotNetRuntimeType deserialize(@Nullable String id2) {
            DotNetRuntimeType dotNetRuntimeType;
            if (id2 == null) {
                dotNetRuntimeType = null;
            } else if (Intrinsics.areEqual((Object)id2, (Object)DotNetRuntimeType.MONO_CASE_SERIALIZED)) {
                dotNetRuntimeType = MonoRuntimeType.INSTANCE;
            } else if (Intrinsics.areEqual((Object)id2, (Object)DotNetRuntimeType.CORE_CASE_SERIALIZED)) {
                dotNetRuntimeType = DotNetCoreRuntimeType.INSTANCE;
            } else if (Intrinsics.areEqual((Object)id2, (Object)DotNetRuntimeType.FRAMEWORK_CASE_SERIALIZED)) {
                dotNetRuntimeType = MsNetRuntimeType.INSTANCE;
            } else if (StringsKt.startsWith$default((String)id2, (String)DotNetRuntimeType.CUSTOM_CASE_SERIALIZED, (boolean)false, (int)2, null)) {
                String[] stringArray = new String[]{":"};
                List list2 = StringsKt.split$default((CharSequence)id2, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                if (list2.size() == 2) {
                    dotNetRuntimeType = new CustomDotNetCoreRuntimeType((String)list2.get(1));
                } else {
                    logger.warn("Failed to retrieve stored custom runtime ID, using configured .NET Core instead");
                    dotNetRuntimeType = DotNetCoreRuntimeType.INSTANCE;
                }
            } else {
                dotNetRuntimeType = null;
            }
            return dotNetRuntimeType;
        }

        @NotNull
        public final String serialize(@Nullable DotNetRuntimeType runtimeType) {
            Object object;
            DotNetRuntimeType dotNetRuntimeType = runtimeType;
            if (Intrinsics.areEqual((Object)dotNetRuntimeType, (Object)MonoRuntimeType.INSTANCE)) {
                object = DotNetRuntimeType.MONO_CASE_SERIALIZED;
            } else if (Intrinsics.areEqual((Object)dotNetRuntimeType, (Object)DotNetCoreRuntimeType.INSTANCE)) {
                object = DotNetRuntimeType.CORE_CASE_SERIALIZED;
            } else if (Intrinsics.areEqual((Object)dotNetRuntimeType, (Object)MsNetRuntimeType.INSTANCE)) {
                object = DotNetRuntimeType.FRAMEWORK_CASE_SERIALIZED;
            } else if (dotNetRuntimeType instanceof CustomDotNetCoreRuntimeType) {
                object = "custom:" + ((CustomDotNetCoreRuntimeType)runtimeType).getCustomRuntimeId();
            } else if (dotNetRuntimeType == null) {
                object = "";
            } else {
                throw new Exception("Not supported runtime type: " + runtimeType);
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

