/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.multiPlatform.mac;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.BundledAssemblyLauncherInfo;
import com.jetbrains.rider.debugger.DebuggerHelperHost;
import com.jetbrains.rider.debugger.targets.BundledAssemblyLauncher;
import com.jetbrains.rider.debugger.targets.BundledAssemblyLauncherKt;
import com.jetbrains.rider.model.debuggerWorker.DebuggerStartInfoBase;
import com.jetbrains.rider.model.debuggerWorker.XamarinIOSWiFiStartInfo;
import com.jetbrains.rider.model.debuggerWorker.XamarinMacStartInfo;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.run.AttachDebugProfileStateBase;
import com.jetbrains.rider.run.ConsoleKind;
import com.jetbrains.rider.run.configurations.TerminalMode;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacExecutable;
import com.jetbrains.rider.run.dotNetCore.DotNetCoreDebugProfile;
import com.jetbrains.rider.runtime.DotNetExecutable;
import com.jetbrains.rider.runtime.RiderDotNetActiveRuntimeHost;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0096@\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\"H\u0096@\u00a2\u0006\u0002\u0010+R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/run/multiPlatform/mac/MacDebugProfileState;", "Lcom/jetbrains/rider/run/AttachDebugProfileStateBase;", "executable", "Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacExecutable;", "port", "", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "MacDebugProfileState", "(Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacExecutable;ILcom/intellij/execution/runners/ExecutionEnvironment;)V", "getExecutable", "()Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacExecutable;", "getPort", "()I", "coreDebugProfileWrapper", "Lkotlin/Lazy;", "Lcom/jetbrains/rider/run/dotNetCore/DotNetCoreDebugProfile;", "consoleKind", "Lcom/jetbrains/rider/run/ConsoleKind;", "getConsoleKind", "()Lcom/jetbrains/rider/run/ConsoleKind;", "execute", "Lcom/intellij/execution/ExecutionResult;", "executor", "Lcom/intellij/execution/Executor;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "attached", "", "getAttached", "()Z", "getLauncherInfo", "Lcom/jetbrains/rider/BundledAssemblyLauncherInfo;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "helper", "Lcom/jetbrains/rider/debugger/DebuggerHelperHost;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/debugger/DebuggerHelperHost;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkBeforeExecution", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createModelStartInfo", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerStartInfoBase;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nMacDebugProfileState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacDebugProfileState.kt\ncom/jetbrains/rider/run/multiPlatform/mac/MacDebugProfileState\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,82:1\n30#2,2:83\n*S KotlinDebug\n*F\n+ 1 MacDebugProfileState.kt\ncom/jetbrains/rider/run/multiPlatform/mac/MacDebugProfileState\n*L\n36#1:83,2\n*E\n"})
public final class MacDebugProfileState
extends AttachDebugProfileStateBase {
    @NotNull
    private final MacExecutable executable;
    private final int port;
    @NotNull
    private final Lazy<DotNetCoreDebugProfile> coreDebugProfileWrapper;
    @NotNull
    private final ConsoleKind consoleKind;
    private final boolean attached;

    public MacDebugProfileState(@NotNull MacExecutable executable, int port, @NotNull ExecutionEnvironment executionEnvironment) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
        super(executionEnvironment);
        this.executable = executable;
        this.port = port;
        this.coreDebugProfileWrapper = LazyKt.lazy(() -> MacDebugProfileState.x(this, executionEnvironment));
        this.consoleKind = ConsoleKind.Normal;
    }

    @NotNull
    public final MacExecutable getExecutable() {
        return this.executable;
    }

    public final int getPort() {
        return this.port;
    }

    @Override
    @NotNull
    public ConsoleKind getConsoleKind() {
        return this.consoleKind;
    }

    @Override
    @Nullable
    public ExecutionResult execute(@Nullable Executor executor2, @NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        throw new UnsupportedOperationException("Should use overload with session");
    }

    @Override
    public boolean getAttached() {
        return this.attached;
    }

    @Override
    @Nullable
    public Object getLauncherInfo(@NotNull Lifetime lifetime, @NotNull DebuggerHelperHost helper, @NotNull Continuation<? super BundledAssemblyLauncherInfo> $completion) {
        if (this.executable.isNetCore()) {
            return ((DotNetCoreDebugProfile)this.coreDebugProfileWrapper.getValue()).getLauncherInfo(lifetime, helper, $completion);
        }
        return BundledAssemblyLauncher.getLauncher$default(BundledAssemblyLauncherKt.getDEBUGGER_WORKER_LAUNCHER(), null, 1, null);
    }

    @Override
    @Nullable
    public Object checkBeforeExecution(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object createModelStartInfo(@NotNull Lifetime lifetime, @NotNull Continuation<? super DebuggerStartInfoBase> $completion) {
        if (this.executable.isNetCore()) {
            return ((DotNetCoreDebugProfile)this.coreDebugProfileWrapper.getValue()).createModelStartInfo(lifetime, $completion);
        }
        return this.executable.isMacCatalyst() ? (DebuggerStartInfoBase)new XamarinIOSWiFiStartInfo(this.port) : (DebuggerStartInfoBase)new XamarinMacStartInfo(this.port);
    }

    private static final DotNetCoreDebugProfile x(MacDebugProfileState macDebugProfileState, ExecutionEnvironment executionEnvironment) {
        String string = macDebugProfileState.executable.getExecutablePath();
        String string2 = new File(string).getParent();
        Project project = executionEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager componentManager = (ComponentManager)project;
        boolean bl = false;
        Class<RiderDotNetActiveRuntimeHost> clazz = RiderDotNetActiveRuntimeHost.class;
        Object object = componentManager.getService(clazz);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
        }
        DotNetCoreRuntime dotNetCoreRuntime = (DotNetCoreRuntime)((RiderDotNetActiveRuntimeHost)object).getDotNetCoreRuntime().getValue();
        if (dotNetCoreRuntime == null) {
            throw new CantRunException(RiderMultiPlatformBundle.Companion.message("rider.mac.unable.to.get.runtime.information.message", new Object[0]));
        }
        DotNetCoreRuntime dotNetCoreRuntime2 = dotNetCoreRuntime;
        Intrinsics.checkNotNull((Object)string2);
        DotNetExecutable dotNetExecutable = new DotNetExecutable(string, null, string2, macDebugProfileState.executable.getProgramParameters(), TerminalMode.Auto, macDebugProfileState.executable.getEnvs(), macDebugProfileState.executable.getPassParentEnvs(), MacDebugProfileState::x, null, "", true, dotNetCoreRuntime2.getType(), null, false, false, 20480, null);
        return new DotNetCoreDebugProfile(dotNetCoreRuntime2, dotNetExecutable, executionEnvironment, dotNetCoreRuntime2.getCliExePath());
    }

    private static final Unit x(ExecutionEnvironment executionEnvironment, RunProfile runProfile2, ProcessHandler processHandler2) {
        Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)runProfile2, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)processHandler2, (String)"<unused var>");
        return Unit.INSTANCE;
    }
}

