/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.environment;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.run.environment.ExecutableType;
import com.jetbrains.rider.run.environment.Shell32Ex;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/run/environment/ExecutableFileUtil;", "", "ExecutableFileUtil", "()V", "x", "Lcom/jetbrains/rider/run/environment/ExecutableType;", "executablePath", "Ljava/nio/file/Path;", "readType", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nExecutableFileUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutableFileUtil.kt\ncom/jetbrains/rider/run/environment/ExecutableFileUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,116:1\n23#2:117\n*S KotlinDebug\n*F\n+ 1 ExecutableFileUtil.kt\ncom/jetbrains/rider/run/environment/ExecutableFileUtil\n*L\n44#1:117\n*E\n"})
public final class ExecutableFileUtil {
    @NotNull
    public static final ExecutableFileUtil INSTANCE = new ExecutableFileUtil();

    private ExecutableFileUtil() {
    }

    private final ExecutableType x(Path path) {
        if (!SystemInfo.isWindows) {
            return ExecutableType.Console;
        }
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return ExecutableType.Unknown;
        }
        if (!StringsKt.equals((String)PathsKt.getExtension((Path)path), (String)"exe", (boolean)true)) {
            return ExecutableType.Console;
        }
        Shell32Ex shell32Ex = Shell32Ex.Companion.getInstance();
        Intrinsics.checkNotNull((Object)shell32Ex);
        Shell32Ex shell32Ex2 = shell32Ex;
        Object object = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(ExecutableFileUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        logger2.info("Querying binary type for executable \"" + path + "\".");
        object = new Shell32Ex.SHFILEINFO();
        WinDef.DWORDByReference dWORDByReference = shell32Ex2.SHGetFileInfoW(((Object)path).toString(), new WinDef.DWORD(0L), (Shell32Ex.SHFILEINFO)((Object)object), new WinDef.UINT((long)object.size()), Shell32Ex.Companion.getSHGFI_EXETYPE());
        long l = Pointer.nativeValue((Pointer)(dWORDByReference != null ? dWORDByReference.getPointer() : null));
        if (l == 0L) {
            logger2.warn("SHGetFileInfoW returned code 0 for file \"" + path + "\": non-executable file or error.");
            return ExecutableType.Unknown;
        }
        logger2.info("SHGetFileInfoW returned: " + Long.toHexString(l) + ".");
        boolean bl2 = l == 23117L;
        boolean bl3 = l == 17744L;
        return bl2 || bl3 ? ExecutableType.Console : ExecutableType.Windows;
    }

    @Nullable
    public final Object readType(@NotNull Path executablePath, @NotNull Continuation<? super ExecutableType> $completion) {
        if (!SystemInfo.isWindows) {
            return ExecutableType.Console;
        }
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ExecutableType>, Object>(executablePath, null){
            int label;
            final /* synthetic */ Path $executablePath;
            {
                this.$executablePath = $executablePath;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return ExecutableFileUtil.access$readTypeBlocking(ExecutableFileUtil.INSTANCE, this.$executablePath);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super ExecutableType> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static final /* synthetic */ ExecutableType access$readTypeBlocking(ExecutableFileUtil $this, Path executablePath) {
        return $this.x(executablePath);
    }
}

