/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.uwp;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.jetbrains.rider.debugger.IRiderDebuggable;
import com.jetbrains.rider.run.configurations.IProjectBasedRunConfiguration;
import com.jetbrains.rider.run.configurations.RiderRunConfiguration;
import com.jetbrains.rider.run.configurations.uwp.UwpConfigurationEditor;
import com.jetbrains.rider.run.configurations.uwp.UwpConfigurationParameters;
import com.jetbrains.rider.run.configurations.uwp.UwpExecutorFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B'\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/run/configurations/uwp/UwpConfiguration;", "Lcom/jetbrains/rider/run/configurations/RiderRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfiguration;", "Lcom/jetbrains/rider/debugger/IRiderDebuggable;", "Lcom/jetbrains/rider/run/configurations/IProjectBasedRunConfiguration;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "uwpParameters", "Lcom/jetbrains/rider/run/configurations/uwp/UwpConfigurationParameters;", "UwpConfiguration", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Lcom/jetbrains/rider/run/configurations/uwp/UwpConfigurationParameters;)V", "getUwpParameters", "()Lcom/jetbrains/rider/run/configurations/uwp/UwpConfigurationParameters;", "checkConfiguration", "", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "getProjectFilePath", "setProjectFilePath", "path", "clone", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.rider"})
public final class UwpConfiguration
extends RiderRunConfiguration
implements LocatableConfiguration,
IRiderDebuggable,
IProjectBasedRunConfiguration {
    @NotNull
    private final UwpConfigurationParameters uwpParameters;

    public UwpConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull UwpConfigurationParameters uwpParameters) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)uwpParameters, (String)"uwpParameters");
        super(name, project, factory, (Function1<? super Project, ? extends SettingsEditor<? extends RunConfiguration>>)((Function1)UwpConfiguration::x), new UwpExecutorFactory(uwpParameters));
        this.uwpParameters = uwpParameters;
    }

    @NotNull
    public final UwpConfigurationParameters getUwpParameters() {
        return this.uwpParameters;
    }

    public void checkConfiguration() {
        this.uwpParameters.validate();
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.uwpParameters.readExternal(element);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.uwpParameters.writeExternal(element);
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return this.uwpParameters.getProjectFilePath();
    }

    @Override
    public void setProjectFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.uwpParameters.setProjectFilePath(path);
    }

    @NotNull
    public RunConfiguration clone() {
        String string = this.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConfigurationFactory configurationFactory = this.getFactory();
        Intrinsics.checkNotNull((Object)configurationFactory);
        String string2 = this.uwpParameters.getProjectFilePath();
        String string3 = this.uwpParameters.getProgramParameters();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        UwpConfiguration uwpConfiguration = new UwpConfiguration(string, project, configurationFactory, new UwpConfigurationParameters(string2, string3, project2));
        uwpConfiguration.doCopyOptionsFrom((RunConfigurationBase)this);
        this.copyCopyableDataTo((UserDataHolderBase)uwpConfiguration);
        return (RunConfiguration)uwpConfiguration;
    }

    private static final SettingsEditor x(Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"it");
        return (SettingsEditor)new UwpConfigurationEditor(project);
    }
}

