/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.remote;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.rider.debugger.IRiderDebuggable;
import com.jetbrains.rider.run.configurations.remote.DotNetRemoteConfigurationSettingEditor;
import com.jetbrains.rider.run.configurations.remote.MonoConnectRemoteProfileState;
import com.jetbrains.rider.run.configurations.remote.RemoteConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020!0 H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0002H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0002H\u0016R\u001e\u0010\u000e\u001a\u00020\u000f8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006,"}, d2={"Lcom/jetbrains/rider/run/configurations/remote/DotNetRemoteConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lorg/jdom/Element;", "Lcom/intellij/execution/runners/RunConfigurationWithSuppressedDefaultRunAction;", "Lcom/jetbrains/rider/run/configurations/remote/RemoteConfiguration;", "Lcom/jetbrains/rider/debugger/IRiderDebuggable;", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "name", "", "DotNetRemoteConfiguration", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;Ljava/lang/String;)V", "port", "", "getPort", "()I", "setPort", "(I)V", "address", "getAddress", "()Ljava/lang/String;", "setAddress", "(Ljava/lang/String;)V", "listenPortForConnections", "", "getListenPortForConnections", "()Z", "setListenPortForConnections", "(Z)V", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "readExternal", "", "element", "writeExternal", "intellij.rider"})
public class DotNetRemoteConfiguration
extends LocatableConfigurationBase<Element>
implements RunConfigurationWithSuppressedDefaultRunAction,
RemoteConfiguration,
IRiderDebuggable {
    @Attribute
    private int port;
    @Attribute
    @NotNull
    private String address;
    private boolean listenPortForConnections;

    public DotNetRemoteConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(project, factory, name);
        this.port = 50000;
        this.address = "localhost";
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int n) {
        this.port = n;
    }

    @Override
    @NotNull
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.address = string;
    }

    @Override
    public boolean getListenPortForConnections() {
        return this.listenPortForConnections;
    }

    @Override
    public void setListenPortForConnections(boolean bl) {
        this.listenPortForConnections = bl;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new DotNetRemoteConfigurationSettingEditor();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor2, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor2, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (!Intrinsics.areEqual((Object)executor2.getId(), (Object)"Debug")) {
            return null;
        }
        return new MonoConnectRemoteProfileState(this, environment);
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this, (Element)element);
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this, (Element)element);
    }
}

