/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.publishing.base;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.build.BuildParameters;
import com.jetbrains.rider.build.tasks.BuildStatus;
import com.jetbrains.rider.build.tasks.BuildTaskThrottler;
import com.jetbrains.rider.model.BuildTargetBase;
import com.jetbrains.rider.model.CustomTargetExtraProperty;
import com.jetbrains.rider.model.CustomTargetExtraPropertyBase;
import com.jetbrains.rider.model.CustomTargetWithExtraProperties;
import com.jetbrains.rider.model.PublishableProjectModel;
import com.jetbrains.rider.run.RiderRunBundle;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0013JT\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u001aJ.\u0010\u001b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00160\u001eJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0018J2\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00162\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/run/configurations/publishing/base/MsBuildPublishingService;", "", "project", "Lcom/intellij/openapi/project/Project;", "MsBuildPublishingService", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "invokeMsBuild", "Lcom/jetbrains/rider/build/tasks/BuildStatus;", "projectModel", "Lcom/jetbrains/rider/model/PublishableProjectModel;", "extraProperties", "", "Lcom/jetbrains/rider/model/CustomTargetExtraPropertyBase;", "diagnosticsMode", "", "silentMode", "noRestore", "(Lcom/jetbrains/rider/model/PublishableProjectModel;Ljava/util/List;ZZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invokeMsBuildForPublishToFolder", "outputPath", "Ljava/nio/file/Path;", "configurationName", "", "deleteExistingFiles", "(Lcom/jetbrains/rider/model/PublishableProjectModel;Ljava/nio/file/Path;Ljava/util/List;Ljava/lang/String;ZZZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "invokeMsBuildForRestore", "(Ljava/util/List;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPublishToTempDirParameterAndPath", "Lkotlin/Pair;", "Lcom/jetbrains/rider/model/CustomTargetExtraProperty;", "getPublishToDirParameterCore", "path", "webPublishToFileSystem", "pathToProject", "outPath", "(Ljava/lang/String;Ljava/nio/file/Path;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nMsBuildPublishingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsBuildPublishingService.kt\ncom/jetbrains/rider/run/configurations/publishing/base/MsBuildPublishingService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n1#2:155\n*E\n"})
public final class MsBuildPublishingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String tempPublishDirectoryPrefix = "rider-publish";
    @NotNull
    private static final String publishDirParamName = "PublishDir";
    @NotNull
    private static final String publishMsBuildTargetName = "Publish";
    @NotNull
    private static final String restoreMsBuildTargetName = "Restore";
    @NotNull
    private static final String packageMsBuildTargetName = "Package";
    @NotNull
    private static final String webPublishMsBuildTargetName = "WebPublish";
    @NotNull
    private static final String webPublishMethodParamName = "WebPublishMethod";
    @NotNull
    private static final String webPublishMethod = "FileSystem";
    @NotNull
    private static final String webPublishUrlParamName = "PublishUrl";

    public MsBuildPublishingService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Object invokeMsBuild(@NotNull PublishableProjectModel projectModel, @NotNull List<? extends CustomTargetExtraPropertyBase> extraProperties, boolean diagnosticsMode, boolean silentMode, boolean noRestore, @NotNull Continuation<? super BuildStatus> $completion) {
        BuildParameters buildParameters = new BuildParameters((BuildTargetBase)new CustomTargetWithExtraProperties(publishMsBuildTargetName, extraProperties), CollectionsKt.listOf((Object)projectModel.getProjectFilePath()), diagnosticsMode, silentMode, false, false, noRestore, 48, null);
        return BuildTaskThrottler.buildSequentially$default(BuildTaskThrottler.Companion.getInstance(this.project), buildParameters, null, $completion, 2, null);
    }

    public static /* synthetic */ Object invokeMsBuild$default(MsBuildPublishingService msBuildPublishingService, PublishableProjectModel publishableProjectModel, List list2, boolean bl, boolean bl2, boolean bl3, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        return msBuildPublishingService.invokeMsBuild(publishableProjectModel, list2, bl, bl2, bl3, (Continuation<? super BuildStatus>)continuation);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object invokeMsBuildForPublishToFolder(@NotNull PublishableProjectModel projectModel, @NotNull Path outputPath, @NotNull List<? extends CustomTargetExtraPropertyBase> extraProperties, @NotNull String configurationName, boolean deleteExistingFiles, boolean diagnosticsMode, boolean silentMode, boolean noRestore, @NotNull Continuation<? super BuildStatus> $completion) {
        Object object;
        if (!projectModel.isDotNetCore()) {
            boolean bl = extraProperties.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Classic asp.net projects can't have extra parameters when publishing to folder";
                throw new AssertionError((Object)string);
            }
            return this.webPublishToFileSystem(projectModel.getProjectFilePath(), outputPath, diagnosticsMode, silentMode, $completion);
        }
        List list2 = new ArrayList();
        if (deleteExistingFiles && (object = new File(((Object)outputPath.toRealPath(new LinkOption[0])).toString()).listFiles()) != null) {
            for (File file2 : object) {
                Intrinsics.checkNotNull((Object)file2);
                if (FilesKt.deleteRecursively((File)file2)) continue;
                list2.add(file2);
            }
        }
        if (!((Collection)list2).isEmpty()) {
            void var12_17;
            object = RiderRunBundle.Companion.message("MsBuildPublishingService.notification.title.could.not.delete.files", new Object[0]);
            Object[] objectArray = new Object[]{configurationName};
            String string = RiderRunBundle.Companion.message("MsBuildPublishingService.notification.message.files.could.not.be.deleted", objectArray) + "\n";
            for (File file3 : list2) {
                String string2 = (String)var12_17 + "- " + file3.getName() + "\n";
            }
            new Notification("Publish.DeleteExistingFiles", (String)object, (String)var12_17, NotificationType.WARNING).notify(this.project);
        }
        object = new BuildParameters((BuildTargetBase)new CustomTargetWithExtraProperties(publishMsBuildTargetName, CollectionsKt.plus((Collection)extraProperties, (Object)this.getPublishToDirParameterCore(((Object)outputPath).toString()))), CollectionsKt.listOf((Object)projectModel.getProjectFilePath()), diagnosticsMode, silentMode, false, false, noRestore, 48, null);
        return BuildTaskThrottler.buildSequentially$default(BuildTaskThrottler.Companion.getInstance(this.project), (BuildParameters)object, null, $completion, 2, null);
    }

    @Nullable
    public final Object invokeMsBuildForRestore(@NotNull List<? extends CustomTargetExtraPropertyBase> extraProperties, boolean diagnosticsMode, boolean silentMode, @NotNull Continuation<? super BuildStatus> $completion) {
        BuildParameters buildParameters = new BuildParameters((BuildTargetBase)new CustomTargetWithExtraProperties(restoreMsBuildTargetName, extraProperties), CollectionsKt.emptyList(), diagnosticsMode, silentMode, false, false, true, 48, null);
        return BuildTaskThrottler.buildSequentially$default(BuildTaskThrottler.Companion.getInstance(this.project), buildParameters, null, $completion, 2, null);
    }

    public static /* synthetic */ Object invokeMsBuildForRestore$default(MsBuildPublishingService msBuildPublishingService, List list2, boolean bl, boolean bl2, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return msBuildPublishingService.invokeMsBuildForRestore(list2, bl, bl2, (Continuation<? super BuildStatus>)continuation);
    }

    @NotNull
    public final Pair<CustomTargetExtraProperty, Path> getPublishToTempDirParameterAndPath() {
        Path path = Files.createTempDirectory(tempPublishDirectoryPrefix, new FileAttribute[0]);
        File file2 = path.toFile();
        file2.deleteOnExit();
        String string = file2.getAbsolutePath();
        Intrinsics.checkNotNull((Object)string);
        return new Pair((Object)this.getPublishToDirParameterCore(string), (Object)path);
    }

    @NotNull
    public final CustomTargetExtraProperty getPublishToDirParameterCore(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new CustomTargetExtraProperty(publishDirParamName, path);
    }

    @Nullable
    public final Object webPublishToFileSystem(@NotNull String pathToProject, @NotNull Path outPath, boolean diagnosticsMode, boolean silentMode, @NotNull Continuation<? super BuildStatus> $completion) {
        Object[] objectArray = new CustomTargetExtraProperty[]{new CustomTargetExtraProperty(webPublishMethodParamName, webPublishMethod), new CustomTargetExtraProperty(webPublishUrlParamName, ((Object)outPath).toString())};
        BuildParameters buildParameters = new BuildParameters((BuildTargetBase)new CustomTargetWithExtraProperties(webPublishMsBuildTargetName, CollectionsKt.listOf((Object[])objectArray)), CollectionsKt.listOf((Object)pathToProject), diagnosticsMode, silentMode, false, false, false, 112, null);
        return BuildTaskThrottler.buildSequentially$default(BuildTaskThrottler.Companion.getInstance(this.project), buildParameters, null, $completion, 2, null);
    }

    public static /* synthetic */ Object webPublishToFileSystem$default(MsBuildPublishingService msBuildPublishingService, String string, Path path, boolean bl, boolean bl2, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return msBuildPublishingService.webPublishToFileSystem(string, path, bl, bl2, (Continuation<? super BuildStatus>)continuation);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/run/configurations/publishing/base/MsBuildPublishingService$Companion;", "", "MsBuildPublishingService$Companion", "()V", "tempPublishDirectoryPrefix", "", "publishDirParamName", "publishMsBuildTargetName", "restoreMsBuildTargetName", "packageMsBuildTargetName", "webPublishMsBuildTargetName", "webPublishMethodParamName", "webPublishMethod", "webPublishUrlParamName", "getInstance", "Lcom/jetbrains/rider/run/configurations/publishing/base/MsBuildPublishingService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nMsBuildPublishingService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsBuildPublishingService.kt\ncom/jetbrains/rider/run/configurations/publishing/base/MsBuildPublishingService$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,154:1\n17#2,2:155\n*S KotlinDebug\n*F\n+ 1 MsBuildPublishingService.kt\ncom/jetbrains/rider/run/configurations/publishing/base/MsBuildPublishingService$Companion\n*L\n35#1:155,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MsBuildPublishingService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Object object = componentManager.getService(MsBuildPublishingService.class);
            if (object == null) {
                throw new IllegalStateException("Service " + MsBuildPublishingService.class + " not found in container " + componentManager);
            }
            return (MsBuildPublishingService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

