/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.mac;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.run.configurations.ConfigurationContextExKt;
import com.jetbrains.rider.run.configurations.RiderProjectConfigurationProducerBase;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacRunConfiguration;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.RiderMacConfigurationType;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/RiderMacConfigurationProducer;", "Lcom/jetbrains/rider/run/configurations/RiderProjectConfigurationProducerBase;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfiguration;", "RiderMacConfigurationProducer", "()V", "trySetupConfigurationFromRunnableProject", "", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "configuration", "selectedProjectEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "isConfigurationFromContext", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "intellij.rider"})
public final class RiderMacConfigurationProducer
extends RiderProjectConfigurationProducerBase<MacRunConfiguration> {
    public RiderMacConfigurationProducer() {
        super(RiderMacConfigurationType.class);
    }

    @Override
    protected boolean trySetupConfigurationFromRunnableProject(@NotNull RunnableProject runnableProject, @NotNull MacRunConfiguration configuration, @NotNull ProjectModelEntity selectedProjectEntity) {
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)selectedProjectEntity, (String)"selectedProjectEntity");
        if (!RiderMacConfigurationType.Companion.isTypeApplicable(runnableProject.getKind())) {
            return false;
        }
        configuration.setName(runnableProject.getFullName());
        configuration.getMacParameters().getProjectFilePath().set((Object)runnableProject.getProjectFilePath());
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull MacRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProjectModelEntity projectModelEntity = ConfigurationContextExKt.getSelectedProject(context);
        if (projectModelEntity == null) {
            return false;
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        Object object = ProjectModelEntityExtensionsKt.getFile((ProjectModelEntity)projectModelEntity2);
        if (object == null || (object = ((File)object).getPath()) == null) {
            object = "";
        }
        return Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)object), (Object)configuration.getMacParameters().getProjectFilePath().getValue());
    }
}

