/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.mac;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.xcode.plist.Plist;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.model.CustomAttribute;
import com.jetbrains.rider.model.Key;
import com.jetbrains.rider.model.ProjectOutput;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectsModel_PregeneratedKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.NetTfmInfo;
import com.jetbrains.rider.run.configurations.NetTfmInfoUtil;
import com.jetbrains.rider.run.configurations.RunConfigurationHelper;
import com.jetbrains.rider.run.configurations.RunnableProjectKinds;
import com.jetbrains.rider.run.configurations.multiPlatform.RiderMultiPlatformConfigurationParameters;
import com.jetbrains.rider.run.configurations.multiPlatform.TargetFrameworkPlatform;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.ApplePlatformType;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.InfoPlist;
import com.jetbrains.rider.run.configurations.multiPlatform.mac.MacExecutable;
import com.jetbrains.rider.run.configurations.project.RunnableProjectExKt;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0002J\f\u0010\u001c\u001a\u00020\n*\u00020\u001dH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020\nJ\n\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0006\u0010+\u001a\u00020\u0000J\u0010\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0014R&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016\u00a8\u00060"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationParameters;", "Lcom/jetbrains/rider/run/configurations/multiPlatform/RiderMultiPlatformConfigurationParameters;", "programParameters", "", "projectFilePath", "project", "Lcom/intellij/openapi/project/Project;", "envs", "", "isPassParentEnvs", "", "workingDirectory", "MacRunConfigurationParameters", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Ljava/util/Map;ZLjava/lang/String;)V", "getEnvs", "()Ljava/util/Map;", "setEnvs", "(Ljava/util/Map;)V", "()Z", "setPassParentEnvs", "(Z)V", "getWorkingDirectory", "()Ljava/lang/String;", "setWorkingDirectory", "(Ljava/lang/String;)V", "tryGetRunnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "x", "x", "Lcom/jetbrains/rider/run/configurations/NetTfmInfo;", "bundleIdentifier", "x", "validate", "", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "toExecutable", "Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacExecutable;", "applyWorkaroundForRider79838", "x", "Lcom/jetbrains/cidr/xcode/plist/Plist;", "copy", "isOutputApplicable", "projectOutput", "Lcom/jetbrains/rider/model/ProjectOutput;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nMacRunConfigurationParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacRunConfigurationParameters.kt\ncom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationParameters\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n669#2,11:156\n1761#2,3:168\n1#3:167\n*S KotlinDebug\n*F\n+ 1 MacRunConfigurationParameters.kt\ncom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationParameters\n*L\n46#1:156,11\n100#1:168,3\n*E\n"})
public final class MacRunConfigurationParameters
extends RiderMultiPlatformConfigurationParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, String> envs;
    private boolean isPassParentEnvs;
    @NotNull
    private String workingDirectory;
    @NotNull
    private static final String WORKING_DIRECTORY = "WORKING_DIRECTORY";
    @NotNull
    private static final String PASS_PARENT_ENVS = "PASS_PARENT_ENVS_MAC";

    public MacRunConfigurationParameters(@NotNull String programParameters, @NotNull String projectFilePath, @NotNull Project project, @NotNull Map<String, String> envs, boolean isPassParentEnvs, @NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)programParameters, (String)"programParameters");
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        super(programParameters, projectFilePath, project);
        this.envs = envs;
        this.isPassParentEnvs = isPassParentEnvs;
        this.workingDirectory = workingDirectory;
    }

    @NotNull
    public final Map<String, String> getEnvs() {
        return this.envs;
    }

    public final void setEnvs(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        this.envs = map2;
    }

    public final boolean isPassParentEnvs() {
        return this.isPassParentEnvs;
    }

    public final void setPassParentEnvs(boolean bl) {
        this.isPassParentEnvs = bl;
    }

    @NotNull
    public final String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.workingDirectory = string;
    }

    @Override
    @Nullable
    public RunnableProject tryGetRunnableProject() {
        List list2 = (List)RunnableProjectsModel_PregeneratedKt.getRunnableProjectsModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.getProject())).getProjects().getValueOrNull();
        if (list2 != null) {
            Object v0;
            block3: {
                Iterable iterable = list2;
                boolean bl = false;
                Object var4_4 = null;
                boolean bl2 = false;
                for (Object t : iterable) {
                    RunnableProject runnableProject = (RunnableProject)t;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)runnableProject.getProjectFilePath(), (Object)this.getProjectFilePath().getValue()) && Intrinsics.areEqual((Object)runnableProject.getKind(), (Object)RunnableProjectKinds.INSTANCE.getXamarinMacOS()))) continue;
                    if (bl2) {
                        v0 = null;
                        break block3;
                    }
                    var4_4 = t;
                    bl2 = true;
                }
                v0 = !bl2 ? null : var4_4;
            }
            return v0;
        }
        return null;
    }

    private final boolean x() {
        RunnableProject runnableProject = this.tryGetRunnableProject();
        if (runnableProject == null) {
            return false;
        }
        RunnableProject runnableProject2 = runnableProject;
        CharSequence charSequence = RunnableProjectExKt.getCustomAttribute(runnableProject2, Key.ApplicationId);
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        Object object = this.tryGetTargetFramework(runnableProject2);
        return object != null && (object = NetTfmInfoUtil.INSTANCE.tryReadTfm((RdTargetFrameworkId)object)) != null ? this.x((NetTfmInfo)object) : false;
    }

    private final boolean x(NetTfmInfo netTfmInfo) {
        return !netTfmInfo.isNetFramework() && netTfmInfo.getMajorVersion() >= 6;
    }

    private final String x() {
        Object object = this.tryGetRunnableProject();
        if (object == null || (object = RunnableProjectExKt.getCustomAttribute(object, Key.AssemblyName)) == null) {
            Plist plist = this.x();
            object = plist != null ? plist.getString("CFBundleIdentifier") : null;
            if (object == null) {
                throw new CantRunException(RiderRunBundle.Companion.message("rider.MacConfigurationParameters.dialog.message.cfbundlename.unknown", new Object[0]));
            }
        }
        return object;
    }

    @Override
    public void validate() {
        block6: {
            String string;
            block8: {
                block7: {
                    super.validate();
                    if (!SystemInfo.isMac) {
                        throw new RuntimeConfigurationError(RiderRunBundle.Companion.message("dialog.message.cannot.run.application.on.this.system", new Object[0]));
                    }
                    if (this.x()) break block6;
                    Plist plist = this.x();
                    if (plist == null) {
                        throw new RuntimeConfigurationError(RiderRunBundle.Companion.message("rider.MacConfigurationParameters.dialog.message.cant.find.plist.file", new Object[0]));
                    }
                    Plist plist2 = plist;
                    string = plist2.getString("LSMinimumSystemVersion");
                    if (string == null) break block7;
                    String string2 = string;
                    boolean bl = false;
                    Version version = Version.parseVersion((String)string2);
                    string = version;
                    if (version != null) break block8;
                }
                return;
            }
            String string3 = string;
            if (OS.CURRENT.parsedVersion().compareTo((Version)string3) < 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = string3;
                Intrinsics.checkNotNullExpressionValue((Object)OS.CURRENT.version(), (String)"version(...)");
                throw new RuntimeConfigurationError(RiderRunBundle.Companion.message("rider.MacConfigurationParameters.dialog.message.app.requires.osx", objectArray));
            }
        }
    }

    @Override
    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        String string = JDOMExternalizerUtil.readField((Element)element, (String)WORKING_DIRECTORY);
        if (string == null) {
            string = "";
        }
        this.workingDirectory = string;
        EnvironmentVariablesComponent.readExternal((Element)element, this.envs);
        this.isPassParentEnvs = !Intrinsics.areEqual((Object)JDOMExternalizerUtil.readField((Element)element, (String)PASS_PARENT_ENVS), (Object)"0");
    }

    @Override
    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)WORKING_DIRECTORY, (String)this.workingDirectory);
        JDOMExternalizerUtil.writeField((Element)element, (String)PASS_PARENT_ENVS, (String)(this.isPassParentEnvs ? "1" : "0"));
        EnvironmentVariablesComponent.writeExternal((Element)element, this.envs);
    }

    @NotNull
    public final MacExecutable toExecutable(boolean applyWorkaroundForRider79838) {
        String string;
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        Object object4;
        RunnableProject runnableProject;
        block9: {
            RunnableProject runnableProject2 = this.tryGetRunnableProject();
            if (runnableProject2 == null) {
                throw new CantRunException(RiderRunBundle.Companion.message("dialog.message.not.specified.project.error", new Object[0]));
            }
            runnableProject = runnableProject2;
            object4 = runnableProject.getCustomAttributes();
            boolean bl2 = false;
            if (object4 instanceof Collection && ((Collection)object4).isEmpty()) {
                bl = false;
            } else {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    CustomAttribute customAttribute = (CustomAttribute)object2;
                    boolean bl3 = false;
                    if (!(customAttribute.getKey() == Key.IsMacCatalyst && StringsKt.equals((String)customAttribute.getValue(), (String)"true", (boolean)true))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        boolean bl4 = bl;
        object4 = this.x();
        object2 = this.workingDirectory;
        if (object2.length() == 0) {
            boolean bl5 = false;
            ProjectOutput projectOutput = (ProjectOutput)CollectionsKt.singleOrNull((List)runnableProject.getProjectOutputs());
            object = projectOutput != null ? projectOutput.getWorkingDirectory() : null;
        } else {
            object = object2;
        }
        if ((string = (String)object) == null) {
            string = "";
        }
        String string2 = string;
        RdTargetFrameworkId rdTargetFrameworkId = this.tryGetTargetFramework(runnableProject);
        object3 = rdTargetFrameworkId != null ? rdTargetFrameworkId.getPresentableName() : null;
        object2 = NetTfmInfoUtil.INSTANCE.tryReadTfm((String)object3);
        boolean bl6 = object2 != null && ((NetTfmInfo)object2).getPlatform() == TargetFrameworkPlatform.MACOS && !((NetTfmInfo)object2).isNetFramework();
        Object object5 = new String[]{(String)object4 + ".app"};
        String string3 = Paths.get(string2, object5).toFile().getAbsolutePath();
        object5 = null;
        Object object6 = null;
        if (applyWorkaroundForRider79838 && bl4) {
            object5 = "/usr/bin/open";
            object6 = "\"" + string3 + "\" " + this.getProgramParameters();
        } else {
            String[] stringArray = new String[]{"Contents", "MacOS", object4};
            String string4 = Paths.get(string3, stringArray).toFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
            object5 = string4;
            object6 = this.getProgramParameters();
        }
        return new MacExecutable(runnableProject, (String)object5, (String)object6, this.envs, this.isPassParentEnvs, bl4, bl6);
    }

    public static /* synthetic */ MacExecutable toExecutable$default(MacRunConfigurationParameters macRunConfigurationParameters, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return macRunConfigurationParameters.toExecutable(bl);
    }

    private final Plist x() {
        RunnableProject runnableProject = this.tryGetRunnableProject();
        if (runnableProject == null) {
            return null;
        }
        RunnableProject runnableProject2 = runnableProject;
        ApplePlatformType[] applePlatformTypeArray = new ApplePlatformType[]{ApplePlatformType.MACOS, ApplePlatformType.MACCATALYST};
        return InfoPlist.INSTANCE.fromRunnableProject(runnableProject2, applePlatformTypeArray);
    }

    @NotNull
    public final MacRunConfigurationParameters copy() {
        return new MacRunConfigurationParameters(this.getProgramParameters(), (String)this.getProjectFilePath().getValue(), this.getProject(), RunConfigurationHelper.INSTANCE.copyEnvs(this.envs), this.isPassParentEnvs, this.workingDirectory);
    }

    @Override
    protected boolean isOutputApplicable(@NotNull ProjectOutput projectOutput) {
        Intrinsics.checkNotNullParameter((Object)projectOutput, (String)"projectOutput");
        Object object = projectOutput.getTfm();
        if (object == null || (object = NetTfmInfoUtil.INSTANCE.tryReadTfm((RdTargetFrameworkId)object)) == null) {
            return false;
        }
        Object object2 = object;
        return ((NetTfmInfo)object2).getPlatform() == TargetFrameworkPlatform.MACCATALYST || ((NetTfmInfo)object2).getPlatform() == TargetFrameworkPlatform.MACOS;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/run/configurations/multiPlatform/mac/MacRunConfigurationParameters$Companion;", "", "MacRunConfigurationParameters$Companion", "()V", "WORKING_DIRECTORY", "", "PASS_PARENT_ENVS", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

