/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.multiPlatform.ios.connectDialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.IOSConnectionSessionHost;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.connectDialogs.RemoteMacAgentServerListModel;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.connectDialogs.RiderRemoteMacAgentConnectionHelperDialogsKt;
import com.jetbrains.rider.run.configurations.multiPlatform.ios.connectDialogs.servers.RemoteMacAgent;
import com.jetbrains.rider.run.multiPlatform.ios.sessions.IOSSessionHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacAgentConnectToServerDialog
extends DialogWrapper {
    private JBList<RemoteMacAgent> hostsList;
    private JScrollPane serversPane;
    private JPanel panel;
    private JButton connectButton;
    private JButton closeButton;
    private RemoteMacAgentServerListModel macAgentListModel;
    private final Project project;

    public MacAgentConnectToServerDialog(@NotNull Project project) {
        if (project == null) {
            MacAgentConnectToServerDialog.x(0);
        }
        super(project);
        this.project = project;
        this.x();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.panel;
    }

    private void G() {
        this.hostsList = new JBList();
        final IOSConnectionSessionHost iOSConnectionSessionHost = IOSConnectionSessionHost.Companion.getInstance(this.project);
        this.macAgentListModel = new RemoteMacAgentServerListModel(iOSConnectionSessionHost);
        this.hostsList.setModel((ListModel)this.macAgentListModel);
        this.hostsList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<RemoteMacAgent>(){

            protected void customizeCellRenderer(@NotNull JList<? extends RemoteMacAgent> list2, RemoteMacAgent value2, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.x(0);
                }
                if (value2 == null) {
                    return;
                }
                IOSSessionHandler iOSSessionHandler = iOSConnectionSessionHost.getActiveSessionHandler();
                this.append(value2.getHostName() + " ");
                if (value2.isActive()) {
                    Object object = RiderRunBundle.Companion.message("rider.ConnectToServerDialog.button.text.connected", new Object[0]);
                    if (iOSSessionHandler != null && !iOSSessionHandler.getHostUserName().isEmpty()) {
                        object = (String)object + " (" + iOSSessionHandler.getHostUserName() + ")";
                    }
                    this.append((String)object, new SimpleTextAttributes(1, (Color)JBColor.GREEN));
                } else {
                    this.append(value2.getDescription(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void x(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/rider/run/configurations/multiPlatform/ios/connectDialogs/MacAgentConnectToServerDialog$1", "customizeCellRenderer"));
            }
        });
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.hostsList);
        toolbarDecorator.setAddAction(anActionButton -> {
            DialogWrapper dialogWrapper = RiderRemoteMacAgentConnectionHelperDialogsKt.getNewHostAddressDialog(this.panel, this.project, (Function1<? super String, Unit>)((Function1)string -> {
                this.x((String)string);
                return Unit.INSTANCE;
            }));
            dialogWrapper.show();
        });
        toolbarDecorator.setRemoveAction(anActionButton -> {
            this.setErrorText(null);
            RemoteMacAgent remoteMacAgent = (RemoteMacAgent)this.hostsList.getSelectedValue();
            if (remoteMacAgent != null && remoteMacAgent.isActive() && remoteMacAgent.canBeDisconnected()) {
                remoteMacAgent.disconnect();
                this.macAgentListModel.refresh();
                this.connectButton.setText(RiderRunBundle.Companion.message("rider.ConnectToServerDialog.button.connect", new Object[0]));
            }
            this.macAgentListModel.removeHost(this.hostsList.getSelectedIndex());
        });
        toolbarDecorator.setMoveUpAction(anActionButton -> {
            int n = this.hostsList.getSelectedIndex();
            if (n <= 0) {
                return;
            }
            this.hostsList.setSelectedIndex(n - 1);
        });
        toolbarDecorator.setMoveDownAction(anActionButton -> {
            int n = this.hostsList.getSelectedIndex();
            if (n < 0 || n >= this.hostsList.getItemsCount() - 1) {
                return;
            }
            this.hostsList.setSelectedIndex(n + 1);
        });
        this.serversPane = ScrollPaneFactory.createScrollPane((Component)toolbarDecorator.createPanel());
        this.setTitle(RiderRunBundle.Companion.message("rider.ConnectToServerDialog.dialog.title.mac.agent", new Object[0]));
        this.hostsList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int n = MacAgentConnectToServerDialog.this.hostsList.locationToIndex(e.getPoint());
                    MacAgentConnectToServerDialog.this.x(MacAgentConnectToServerDialog.this.macAgentListModel.getElementAt(n));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.hostsList.addListSelectionListener(listSelectionEvent -> {
            List list2 = ((JList)listSelectionEvent.getSource()).getSelectedValuesList();
            RemoteMacAgent remoteMacAgent = !list2.isEmpty() ? (RemoteMacAgent)list2.get(0) : null;
            this.connectButton.setEnabled(remoteMacAgent != null && (!remoteMacAgent.isActive() || remoteMacAgent.canBeDisconnected()));
            this.connectButton.setText(remoteMacAgent != null && remoteMacAgent.isActive() ? RiderRunBundle.Companion.message("rider.ConnectToServerDialog.button.disconnect", new Object[0]) : RiderRunBundle.Companion.message("rider.ConnectToServerDialog.button.connect", new Object[0]));
        });
    }

    private void x(@Nullable RemoteMacAgent remoteMacAgent) {
        this.setErrorText(null);
        if (remoteMacAgent == null) {
            return;
        }
        if (!remoteMacAgent.tryConnect()) {
            this.setErrorText(RiderRunBundle.Companion.message("rider.ConnectToServerDialog.dialog.message.failed.to.connect.to.agent", new Object[0]));
        } else {
            this.macAgentListModel.refresh();
            this.connectButton.setText(RiderRunBundle.Companion.message("rider.ConnectToServerDialog.button.disconnect", new Object[0]));
        }
    }

    private void x(String string) {
        this.setErrorText(null);
        this.macAgentListModel.addHost(string);
    }

    public void show() {
        JButton jButton;
        this.init();
        try {
            jButton = this.getButton(this.getOKAction());
            if (jButton != null) {
                jButton.setVisible(false);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            jButton = this.getButton(this.getCancelAction());
            if (jButton != null) {
                jButton.setVisible(false);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.connectButton.addActionListener(actionEvent -> {
            RemoteMacAgent remoteMacAgent = (RemoteMacAgent)this.hostsList.getSelectedValue();
            if (remoteMacAgent == null) {
                return;
            }
            if (remoteMacAgent.isActive()) {
                remoteMacAgent.disconnect();
                this.macAgentListModel.refresh();
                this.connectButton.setText(RiderRunBundle.Companion.message("rider.ConnectToServerDialog.button.connect", new Object[0]));
                return;
            }
            this.x(remoteMacAgent);
        });
        this.closeButton.addActionListener(actionEvent -> this.close(1));
        this.connectButton.setEnabled(false);
        this.panel.setPreferredSize((Dimension)JBUI.size((int)300, (int)250));
        super.show();
    }

    @NotNull
    protected JButton createHelpButton(@NotNull Insets insets) {
        if (insets == null) {
            MacAgentConnectToServerDialog.x(1);
        }
        JButton jButton = super.createHelpButton(insets);
        jButton.setVisible(false);
        JButton jButton2 = jButton;
        if (jButton2 == null) {
            MacAgentConnectToServerDialog.x(2);
        }
        return jButton2;
    }

    private static /* synthetic */ void x(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/rider/run/configurations/multiPlatform/ios/connectDialogs/MacAgentConnectToServerDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/rider/run/configurations/multiPlatform/ios/connectDialogs/MacAgentConnectToServerDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createHelpButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createHelpButton";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void x() {
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        this.G();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JScrollPane jScrollPane = this.serversPane;
        jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.connectButton = jButton2 = new JButton();
        jButton2.setText("Connect");
        jPanel.add((Component)jButton2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.closeButton = jButton = new JButton();
        jButton.setText("Close");
        jPanel.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 4, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

