/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.launchSettings.roslyn;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/roslyn/RoslynUtil;", "", "RoslynUtil", "()V", "getFullTargetProjectFile", "Ljava/nio/file/Path;", "targetProjectFilePath", "", "currentProjectFilePath", "intellij.rider"})
public final class RoslynUtil {
    @NotNull
    public static final RoslynUtil INSTANCE = new RoslynUtil();

    private RoslynUtil() {
    }

    @Nullable
    public final Path getFullTargetProjectFile(@Nullable String targetProjectFilePath, @Nullable String currentProjectFilePath) {
        Path path;
        if (targetProjectFilePath == null || currentProjectFilePath == null) {
            return null;
        }
        Path path2 = Paths.get(currentProjectFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path path3 = path2.getParent();
        Path path4 = Paths.get(targetProjectFilePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
        if (path4.isAbsolute() || path3 == null) {
            Path path5 = Paths.get(targetProjectFilePath, new String[0]);
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
        } else {
            Path path6 = path3.resolve(targetProjectFilePath);
            path = path6;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"resolve(...)");
        }
        Path path7 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path7, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        return path7;
    }
}

