/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.launchSettings.commands;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.rider.model.ProjectOutput;
import com.jetbrains.rider.model.RdTargetFrameworkId;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfigurationParameters;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfigurationViewModel;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJson;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJsonKt;
import com.jetbrains.rider.run.configurations.launchSettings.commands.LaunchSettingsCommandExtension;
import com.jetbrains.rider.run.configurations.launchSettings.commands.LaunchSettingsRunParameters;
import com.jetbrains.rider.run.configurations.launchSettings.iis.IisDebugProfileState;
import com.jetbrains.rider.run.configurations.launchSettings.iis.IisRunProfileState;
import com.jetbrains.rider.run.environment.ExecutableRunParameters;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00052\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\tH\u0016J\u0016\u0010(\u001a\u00020)2\u0006\u0010\u001c\u001a\u00020*H\u0096@\u00a2\u0006\u0002\u0010+R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/commands/IisCommand;", "Lcom/jetbrains/rider/run/configurations/launchSettings/commands/LaunchSettingsCommandExtension;", "IisCommand", "()V", "commandName", "", "getCommandName", "()Ljava/lang/String;", "isDebuggable", "", "()Z", "isProfileable", "requiresProjectOutput", "getRequiresProjectOutput", "shouldCheckExecutableExistence", "getShouldCheckExecutableExistence", "getRunParameters", "Lcom/jetbrains/rider/run/environment/ExecutableRunParameters;", "profile", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJson$Profile;", "executable", "Ljava/nio/file/Path;", "defaultArguments", "", "projectFilePath", "tfm", "Lcom/jetbrains/rider/model/RdTargetFrameworkId;", "getDefaultWorkingDirectory", "parameters", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsConfigurationParameters;", "projectOutput", "Lcom/jetbrains/rider/model/ProjectOutput;", "getApplicationUrl", "launchSettings", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJson$LaunchSettings;", "customizeViewModel", "", "viewModel", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsConfigurationViewModel;", "isOSSupported", "getRunProfileState", "Lcom/intellij/execution/configurations/RunProfileState;", "Lcom/jetbrains/rider/run/configurations/launchSettings/commands/LaunchSettingsRunParameters;", "(Lcom/jetbrains/rider/run/configurations/launchSettings/commands/LaunchSettingsRunParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.rider"})
public final class IisCommand
implements LaunchSettingsCommandExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String commandName;
    private final boolean isDebuggable;
    private final boolean isProfileable;
    private final boolean requiresProjectOutput;
    private final boolean shouldCheckExecutableExistence;
    @NotNull
    public static final String COMMAND_NAME = "IIS";

    public IisCommand() {
        this.commandName = COMMAND_NAME;
        this.isDebuggable = true;
        this.requiresProjectOutput = true;
    }

    @Override
    @NotNull
    public String getCommandName() {
        return this.commandName;
    }

    @Override
    public boolean isDebuggable() {
        return this.isDebuggable;
    }

    @Override
    public boolean isProfileable() {
        return this.isProfileable;
    }

    @Override
    public boolean getRequiresProjectOutput() {
        return this.requiresProjectOutput;
    }

    @Override
    public boolean getShouldCheckExecutableExistence() {
        return this.shouldCheckExecutableExistence;
    }

    @Override
    @Nullable
    public ExecutableRunParameters getRunParameters(@NotNull LaunchSettingsJson.Profile profile2, @Nullable Path executable, @NotNull List<String> defaultArguments, @NotNull String projectFilePath, @Nullable RdTargetFrameworkId tfm) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter(defaultArguments, (String)"defaultArguments");
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        Object object2 = executable;
        if (object2 == null || (object2 = ((Object)object2.toAbsolutePath()).toString()) == null) {
            return null;
        }
        Object object3 = object2;
        if (defaultArguments.isEmpty()) {
            object = profile2.getCommandLineArgs();
        } else {
            String string = ParametersListUtil.join(defaultArguments);
            String string2 = profile2.getCommandLineArgs();
            if (string2 == null) {
                string2 = "";
            }
            object = string + " " + string2;
        }
        String string = object;
        String string3 = profile2.getWorkingDirectory();
        Map map2 = profile2.getEnvironmentVariables();
        if (map2 == null) {
            map2 = MapsKt.emptyMap();
        }
        return new ExecutableRunParameters((String)object3, string3, string, map2, true, tfm);
    }

    @Override
    @Nullable
    public Path getDefaultWorkingDirectory(@NotNull LaunchSettingsConfigurationParameters parameters, @Nullable ProjectOutput projectOutput) {
        Intrinsics.checkNotNullParameter((Object)((Object)parameters), (String)"parameters");
        Path path = Paths.get(parameters.getProjectFilePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path.getParent();
    }

    @Override
    @Nullable
    public String getApplicationUrl(@NotNull LaunchSettingsJson.LaunchSettings launchSettings) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)launchSettings, (String)"launchSettings");
        Object object2 = launchSettings.getIisSettings();
        if (object2 == null || (object2 = ((LaunchSettingsJson.IISSettings)object2).getIis()) == null || (object2 = ((LaunchSettingsJson.IISBinding)object2).getApplicationUrl()) == null) {
            return null;
        }
        Object object3 = object2;
        Integer n = LaunchSettingsJsonKt.getEffectiveSslPort(launchSettings.getIisSettings().getIis());
        if (n == null) {
            return object3;
        }
        int n2 = n;
        try {
            object = new URIBuilder((String)object3).setScheme("https").setPort(n2).build().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            object = object3;
        }
        return object;
    }

    @Override
    public void customizeViewModel(@NotNull LaunchSettingsConfigurationViewModel viewModel) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        LaunchSettingsConfigurationViewModel launchSettingsConfigurationViewModel = viewModel;
        boolean bl = false;
        launchSettingsConfigurationViewModel.getTerminalModeSelector().isVisible().setValue((Object)false);
        launchSettingsConfigurationViewModel.getSeparator().isVisible().setValue((Object)true);
        launchSettingsConfigurationViewModel.getApplicationUrlEditor().isVisible().setValue((Object)true);
        launchSettingsConfigurationViewModel.getLaunchUrlEditor().isVisible().setValue((Object)true);
        launchSettingsConfigurationViewModel.getDotNetBrowserSettingsEditor().isVisible().setValue((Object)true);
    }

    @Override
    public boolean isOSSupported() {
        return SystemInfo.isWindows;
    }

    @Override
    @Nullable
    public Object getRunProfileState(@NotNull LaunchSettingsRunParameters parameters, @NotNull Continuation<? super RunProfileState> $completion) {
        RunProfileState runProfileState;
        String string = parameters.getExecutorId();
        if (Intrinsics.areEqual((Object)string, (Object)"Run")) {
            runProfileState = new IisRunProfileState(parameters.getProject());
        } else if (Intrinsics.areEqual((Object)string, (Object)"Debug")) {
            runProfileState = new IisDebugProfileState(parameters.getProject());
        } else {
            Object[] objectArray = new Object[]{parameters.getExecutorId()};
            throw new CantRunException(RiderRunBundle.Companion.message("dialog.message.unsupported.executor.error", objectArray));
        }
        return runProfileState;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/commands/IisCommand$Companion;", "", "IisCommand$Companion", "()V", "COMMAND_NAME", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

