/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.launchSettings;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.rider.ideaInterop.RiderContributedLanguageElementNameCrawler;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfigurationType;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJson;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsJsonCachedValueProvider;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\nH\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\nH\u0086@\u00a2\u0006\u0002\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService;", "", "project", "Lcom/intellij/openapi/project/Project;", "LaunchSettingsJsonService", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJson$LaunchSettings;", "cachedValuesManager", "Lcom/intellij/psi/util/CachedValuesManager;", "kotlin.jvm.PlatformType", "x", "()Lcom/intellij/psi/util/CachedValuesManager;", "cachedValuesManager$delegate", "Lkotlin/Lazy;", "loadLaunchSettings", "launchSettingsFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "loadLaunchSettingsSuspend", "(Lcom/jetbrains/rider/model/RunnableProject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nLaunchSettingsJsonService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n72#2,2:146\n1#3:148\n1#3:149\n*S KotlinDebug\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService\n*L\n97#1:146,2\n97#1:148\n*E\n"})
public final class LaunchSettingsJsonService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<Path, CachedValue<LaunchSettingsJson.LaunchSettings>> myCache;
    @NotNull
    private final Lazy cachedValuesManager$delegate;
    @NotNull
    private static final ObjectMapper mapper;

    public LaunchSettingsJsonService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myCache = new ConcurrentHashMap();
        this.cachedValuesManager$delegate = LazyKt.lazy(() -> LaunchSettingsJsonService.x(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final CachedValuesManager x() {
        Lazy lazy = this.cachedValuesManager$delegate;
        return (CachedValuesManager)lazy.getValue();
    }

    @RequiresBackgroundThread
    @Nullable
    public final LaunchSettingsJson.LaunchSettings loadLaunchSettings(@NotNull VirtualFile launchSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)launchSettingsFile, (String)"launchSettingsFile");
        Path path = launchSettingsFile.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        return this.loadLaunchSettings(path);
    }

    @RequiresBackgroundThread
    @Nullable
    public final LaunchSettingsJson.LaunchSettings loadLaunchSettings(@NotNull Path launchSettingsFile) {
        Intrinsics.checkNotNullParameter((Object)launchSettingsFile, (String)"launchSettingsFile");
        ConcurrentMap concurrentMap = this.myCache;
        Path path = launchSettingsFile;
        boolean bl = false;
        Object object = concurrentMap.get(path);
        if (object == null) {
            boolean bl2 = false;
            CachedValue cachedValue = this.x().createCachedValue((CachedValueProvider)new LaunchSettingsJsonCachedValueProvider((Function0<? extends VirtualFile>)((Function0)() -> LaunchSettingsJsonService.x(launchSettingsFile)), mapper), false);
            boolean bl3 = false;
            object = concurrentMap.putIfAbsent(path, cachedValue);
            if (object == null) {
                object = cachedValue;
            }
        }
        CachedValue cachedValue = (CachedValue)object;
        return (LaunchSettingsJson.LaunchSettings)cachedValue.getValue();
    }

    @RequiresBackgroundThread
    @Nullable
    public final LaunchSettingsJson.LaunchSettings loadLaunchSettings(@NotNull RunnableProject runnableProject) {
        LaunchSettingsJson.LaunchSettings launchSettings;
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        Path path = Companion.getLaunchSettingsFileForProject(runnableProject);
        if (path != null) {
            Path path2 = path;
            boolean bl = false;
            launchSettings = this.loadLaunchSettings(path2);
        } else {
            launchSettings = null;
        }
        return launchSettings;
    }

    @Nullable
    public final Object loadLaunchSettingsSuspend(@NotNull RunnableProject runnableProject, @NotNull Continuation<? super LaunchSettingsJson.LaunchSettings> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LaunchSettingsJson.LaunchSettings>, Object>(runnableProject, this, null){
            int label;
            final /* synthetic */ RunnableProject $runnableProject;
            final /* synthetic */ LaunchSettingsJsonService this$0;
            {
                this.$runnableProject = $runnableProject;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        LaunchSettingsJson.LaunchSettings launchSettings;
                        ResultKt.throwOnFailure((Object)$result);
                        Path path = LaunchSettingsJsonService.Companion.getLaunchSettingsFileForProject(this.$runnableProject);
                        if (path != null) {
                            Path path2 = path;
                            LaunchSettingsJsonService launchSettingsJsonService = this.this$0;
                            Path path3 = path2;
                            boolean bl = false;
                            launchSettings = launchSettingsJsonService.loadLaunchSettings(path3);
                        } else {
                            launchSettings = null;
                        }
                        return launchSettings;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LaunchSettingsJson.LaunchSettings> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object loadLaunchSettingsSuspend(@NotNull Path launchSettingsFile, @NotNull Continuation<? super LaunchSettingsJson.LaunchSettings> $completion) {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem localFileSystem2 = localFileSystem;
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super LaunchSettingsJson.LaunchSettings>, Object>(localFileSystem2, launchSettingsFile, this, null){
            int label;
            final /* synthetic */ LocalFileSystem $fs;
            final /* synthetic */ Path $launchSettingsFile;
            final /* synthetic */ LaunchSettingsJsonService this$0;
            {
                this.$fs = $fs;
                this.$launchSettingsFile = $launchSettingsFile;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        LaunchSettingsJson.LaunchSettings launchSettings;
                        ResultKt.throwOnFailure((Object)$result);
                        VirtualFile virtualFile = this.$fs.findFileByNioFile(this.$launchSettingsFile);
                        if (virtualFile != null) {
                            VirtualFile virtualFile2 = virtualFile;
                            LaunchSettingsJsonService launchSettingsJsonService = this.this$0;
                            VirtualFile virtualFile3 = virtualFile2;
                            boolean bl = false;
                            launchSettings = launchSettingsJsonService.loadLaunchSettings(virtualFile3);
                        } else {
                            launchSettings = null;
                        }
                        return launchSettings;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super LaunchSettingsJson.LaunchSettings> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final CachedValuesManager x(LaunchSettingsJsonService launchSettingsJsonService) {
        return CachedValuesManager.getManager((Project)launchSettingsJsonService.project);
    }

    private static final VirtualFile x(Path path) {
        return LocalFileSystem.getInstance().findFileByNioFile(path);
    }

    static {
        ObjectMapper objectMapper = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true)).configure(JsonParser.Feature.ALLOW_COMMENTS, true)).build()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"setSerializationInclusion(...)");
        mapper = ExtensionsKt.registerKotlinModule((ObjectMapper)objectMapper);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ&\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\r0\u001f2\u0006\u0010\b\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService$Companion;", "", "LaunchSettingsJsonService$Companion", "()V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "x", "", "file", "Ljava/nio/file/Path;", "getLaunchSettingsFileForProject", "projectPath", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "testOnlySerializeLaunchSettings", "", "launchSettings", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJson$LaunchSettings;", "writeLaunchSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "launchSettingsJsonFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProfileNameFromElement", "element", "Lcom/intellij/psi/PsiElement;", "getLaunchSettingsProjectForFile", "fs", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "projects", "", "Lcom/intellij/psi/PsiFile;", "getInstance", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nLaunchSettingsJsonService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,145:1\n295#2:146\n296#2:148\n1#3:147\n30#4,2:149\n*S KotlinDebug\n*F\n+ 1 LaunchSettingsJsonService.kt\ncom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsJsonService$Companion\n*L\n77#1:146\n77#1:148\n83#1:149,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean x(Path path) {
            return Intrinsics.areEqual((Object)PathsKt.getName((Path)path), (Object)"launchSettings.json");
        }

        @Nullable
        public final Path getLaunchSettingsFileForProject(@NotNull Path projectPath) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Path path = projectPath.getParent();
            return path != null ? path.resolve("Properties/launchSettings.json") : null;
        }

        @Nullable
        public final Path getLaunchSettingsFileForProject(@NotNull RunnableProject runnableProject) {
            Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
            Path path = Paths.get(runnableProject.getProjectFilePath(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return this.getLaunchSettingsFileForProject(path);
        }

        @TestOnly
        @NotNull
        public final String testOnlySerializeLaunchSettings(@NotNull LaunchSettingsJson.LaunchSettings launchSettings) {
            Intrinsics.checkNotNullParameter((Object)launchSettings, (String)"launchSettings");
            String string = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)launchSettings);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            return string;
        }

        @TestOnly
        public final void writeLaunchSettings(@NotNull Project project, @NotNull VirtualFile launchSettingsJsonFile, @NotNull LaunchSettingsJson.LaunchSettings launchSettings) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)launchSettingsJsonFile, (String)"launchSettingsJsonFile");
            Intrinsics.checkNotNullParameter((Object)launchSettings, (String)"launchSettings");
            String string = this.testOnlySerializeLaunchSettings(launchSettings);
            LoadTextUtil.write((Project)project, (VirtualFile)launchSettingsJsonFile, (Object)this, (String)string, (long)-1L);
        }

        @Nullable
        public final String getProfileNameFromElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)RiderContributedLanguageElementNameCrawler.EP_NAME.getExtensionList()), arg_0 -> Companion.x(element, arg_0)));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public final RunnableProject getLaunchSettingsProjectForFile(@NotNull LocalFileSystem fs, @NotNull List<RunnableProject> projects, @NotNull PsiFile file2) {
            Object t;
            Object v2;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            Intrinsics.checkNotNullParameter(projects, (String)"projects");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            VirtualFile virtualFile = file2.getVirtualFile();
            String string = virtualFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            Path path = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            if (!this.x(path)) {
                return null;
            }
            LaunchSettingsConfigurationType launchSettingsConfigurationType = (LaunchSettingsConfigurationType)ConfigurationTypeUtil.findConfigurationType(LaunchSettingsConfigurationType.class);
            Iterable iterable = projects;
            boolean bl2 = false;
            Iterator iterator2 = iterable.iterator();
            do {
                if (!iterator2.hasNext()) {
                    v2 = null;
                    return v2;
                }
                t = iterator2.next();
                RunnableProject runnableProject = (RunnableProject)t;
                boolean bl3 = false;
                if (launchSettingsConfigurationType.isApplicable(runnableProject.getKind())) {
                    VirtualFile virtualFile2;
                    if (Companion.getLaunchSettingsFileForProject(runnableProject) != null) {
                        Path path2;
                        boolean bl4 = false;
                        virtualFile2 = fs.findFileByNioFile(path2);
                    } else {
                        virtualFile2 = null;
                    }
                    if (Intrinsics.areEqual(virtualFile2, (Object)virtualFile)) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            v2 = t;
            return v2;
        }

        @NotNull
        public final LaunchSettingsJsonService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<LaunchSettingsJsonService> clazz = LaunchSettingsJsonService.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (LaunchSettingsJsonService)object;
        }

        private static final String x(PsiElement psiElement, RiderContributedLanguageElementNameCrawler riderContributedLanguageElementNameCrawler) {
            return riderContributedLanguageElementNameCrawler.getElementName(psiElement);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

