/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.launchSettings;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rider.actions.RiderActionPlaces;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectsModel;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.ProtocolLifetimedSettingsEditor;
import com.jetbrains.rider.run.configurations.TerminalMode;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.EnumSelector;
import com.jetbrains.rider.run.configurations.controls.EnvironmentVariablesViewer;
import com.jetbrains.rider.run.configurations.controls.FlagEditor;
import com.jetbrains.rider.run.configurations.controls.FlagEditorWithAction;
import com.jetbrains.rider.run.configurations.controls.IisExpressCertificateIndicator;
import com.jetbrains.rider.run.configurations.controls.InfoLabel;
import com.jetbrains.rider.run.configurations.controls.LaunchProfile;
import com.jetbrains.rider.run.configurations.controls.LaunchProfileSelector;
import com.jetbrains.rider.run.configurations.controls.PathSelector;
import com.jetbrains.rider.run.configurations.controls.ProgramParametersEditor;
import com.jetbrains.rider.run.configurations.controls.ProjectSelector;
import com.jetbrains.rider.run.configurations.controls.StringSelector;
import com.jetbrains.rider.run.configurations.controls.TextEditor;
import com.jetbrains.rider.run.configurations.controls.ViewSeparator;
import com.jetbrains.rider.run.configurations.controls.runtimeSelection.RuntimeSelector;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettings;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettingsEditor;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationEditorKt;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfiguration;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfigurationEditor;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfigurationParameters;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfigurationType;
import com.jetbrains.rider.run.configurations.launchSettings.LaunchSettingsConfigurationViewModel;
import com.jetbrains.rider.run.configurations.launchSettings.commands.LaunchSettingsCommandRegistry;
import com.jetbrains.rider.run.configurations.project.DotNetStartBrowserParameters;
import com.jetbrains.rider.runtime.DotNetRuntimeType;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/ProtocolLifetimedSettingsEditor;", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "LaunchSettingsConfigurationEditor", "(Lcom/intellij/openapi/project/Project;)V", "viewModel", "Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsConfigurationViewModel;", "getViewModel", "()Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsConfigurationViewModel;", "setViewModel", "(Lcom/jetbrains/rider/run/configurations/launchSettings/LaunchSettingsConfigurationViewModel;)V", "resetEditorFrom", "", "configuration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "testOnlyGetViewModel", "intellij.rider"})
public class LaunchSettingsConfigurationEditor
extends ProtocolLifetimedSettingsEditor<LaunchSettingsConfiguration> {
    @NotNull
    private final Project project;
    public LaunchSettingsConfigurationViewModel viewModel;

    public LaunchSettingsConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final LaunchSettingsConfigurationViewModel getViewModel() {
        LaunchSettingsConfigurationViewModel launchSettingsConfigurationViewModel = this.viewModel;
        if (launchSettingsConfigurationViewModel != null) {
            return launchSettingsConfigurationViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    public final void setViewModel(@NotNull LaunchSettingsConfigurationViewModel launchSettingsConfigurationViewModel) {
        Intrinsics.checkNotNullParameter((Object)launchSettingsConfigurationViewModel, (String)"<set-?>");
        this.viewModel = launchSettingsConfigurationViewModel;
    }

    protected void resetEditorFrom(@NotNull LaunchSettingsConfiguration configuration) {
        LaunchSettingsConfigurationParameters launchSettingsConfigurationParameters;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        LaunchSettingsConfigurationParameters launchSettingsConfigurationParameters2 = launchSettingsConfigurationParameters = configuration.getParameters();
        boolean bl = false;
        this.getViewModel().reset(launchSettingsConfigurationParameters2.getProjectFilePath(), launchSettingsConfigurationParameters2.getProfileName(), launchSettingsConfigurationParameters2.getProjectTFM(), launchSettingsConfigurationParameters2.getTerminalMode(), launchSettingsConfigurationParameters2.getRuntimeType(), launchSettingsConfigurationParameters2.getRuntimeArguments(), launchSettingsConfigurationParameters2.getStartBrowserParameters(), launchSettingsConfigurationParameters2.getGenerateApplicationHostConfig(), launchSettingsConfigurationParameters2.getShowIisExpressOutput(), launchSettingsConfigurationParameters2.getSendDebugRequest(), launchSettingsConfigurationParameters2.getAdditionalIisExpressArguments(), launchSettingsConfigurationParameters2.getAutoAttachToChildren(), launchSettingsConfigurationParameters2.getMixedModeDebugging());
    }

    protected void applyEditorTo(@NotNull LaunchSettingsConfiguration configuration) {
        DotNetStartBrowserParameters dotNetStartBrowserParameters;
        LaunchSettingsConfigurationParameters launchSettingsConfigurationParameters;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        LaunchSettingsConfigurationParameters launchSettingsConfigurationParameters2 = launchSettingsConfigurationParameters = configuration.getParameters();
        boolean bl = false;
        Object object = (RunnableProject)this.getViewModel().getProjectSelector().getProject().getValueOrNull();
        if (object == null || (object = object.getProjectFilePath()) == null) {
            object = "";
        }
        launchSettingsConfigurationParameters2.setProjectFilePath((String)object);
        Object object2 = (LaunchProfile)this.getViewModel().getLaunchProfileSelector().getProfile().getValueOrNull();
        if (object2 == null || (object2 = ((LaunchProfile)object2).getName()) == null) {
            object2 = "";
        }
        launchSettingsConfigurationParameters2.setProfileName((String)object2);
        String string = (String)this.getViewModel().getTfmSelector().getString().getValueOrNull();
        if (string == null) {
            string = "";
        }
        launchSettingsConfigurationParameters2.setProjectTFM(string);
        TerminalMode terminalMode = (TerminalMode)((Object)this.getViewModel().getTerminalModeSelector().getRawValue().getValueOrNull());
        if (terminalMode == null) {
            terminalMode = TerminalMode.Auto;
        }
        launchSettingsConfigurationParameters2.setTerminalMode(terminalMode);
        launchSettingsConfigurationParameters2.setRuntimeType((DotNetRuntimeType)this.getViewModel().getRuntimeSelector().getRuntime().getValue());
        launchSettingsConfigurationParameters2.setRuntimeArguments((String)this.getViewModel().getRuntimeArgumentsEditor().getParametersString().getValue());
        DotNetStartBrowserParameters dotNetStartBrowserParameters2 = dotNetStartBrowserParameters = launchSettingsConfigurationParameters2.getStartBrowserParameters();
        boolean bl2 = false;
        dotNetStartBrowserParameters2.setBrowser(((BrowserSettings)this.getViewModel().getDotNetBrowserSettingsEditor().getSettings().getValue()).getMyBrowser());
        dotNetStartBrowserParameters2.setWithJavaScriptDebugger(((BrowserSettings)this.getViewModel().getDotNetBrowserSettingsEditor().getSettings().getValue()).getWithJavaScriptDebugger());
        launchSettingsConfigurationParameters2.setGenerateApplicationHostConfig((Boolean)this.getViewModel().getGenerateApplicationConfigEditor().isSelected().getValue());
        launchSettingsConfigurationParameters2.setShowIisExpressOutput((Boolean)this.getViewModel().getShowIisExpressOutputEditor().isSelected().getValue());
        launchSettingsConfigurationParameters2.setSendDebugRequest((Boolean)this.getViewModel().getSendDebugRequestEditor().isSelected().getValue());
        launchSettingsConfigurationParameters2.setAdditionalIisExpressArguments((String)this.getViewModel().getAdditionalIisExpressArgumentsEditor().getParametersString().getValue());
        launchSettingsConfigurationParameters2.setAutoAttachToChildren((Boolean)this.getViewModel().getAutoAttachChildrenCheckBox().isSelected().getValue());
        IProperty<Boolean> iProperty = this.getViewModel().getMixedModeDebuggingCheckBox();
        launchSettingsConfigurationParameters2.setMixedModeDebugging(iProperty != null && (iProperty = iProperty.isSelected()) != null ? ((Boolean)iProperty.getValue()).booleanValue() : false);
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime) {
        InfoLabel infoLabel;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        InfoLabel infoLabel2 = infoLabel = new InfoLabel();
        LaunchSettingsCommandRegistry launchSettingsCommandRegistry = LaunchSettingsCommandRegistry.Companion.getInstance(this.project);
        RunnableProjectsModel runnableProjectsModel = ProjectExKt.getRunnableProjectsModelIfAvailable(this.project);
        Lifetime lifetime2 = lifetime;
        LaunchSettingsConfigurationType launchSettingsConfigurationType = (LaunchSettingsConfigurationType)ConfigurationTypeUtil.findConfigurationType(LaunchSettingsConfigurationType.class);
        Project project = this.project;
        LaunchSettingsConfigurationEditor launchSettingsConfigurationEditor = this;
        boolean bl = false;
        infoLabel2.getIcon().setValue((Object)AllIcons.General.Warning);
        Unit unit = Unit.INSTANCE;
        ProjectSelector projectSelector = new ProjectSelector(RiderRunBundle.Companion.message("label.project.with.colon", new Object[0]), "Project");
        StringSelector stringSelector = new StringSelector(RiderRunBundle.Companion.message("label.target.framework.with.colon", new Object[0]), "Target_framework");
        LaunchProfileSelector launchProfileSelector = new LaunchProfileSelector(RiderRunBundle.Companion.message("label.launch.profile.with.colon", new Object[0]), "Launch_profile");
        PathSelector pathSelector = new PathSelector(RiderRunBundle.Companion.message("label.exe.path.with.colon", new Object[0]), "Exe_path", null, lifetime);
        String string = ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        FlagEditor flagEditor = DotNetExeConfigurationEditorKt.createMixedModeRunEditorFlag();
        FlagEditor flagEditor2 = new FlagEditor(RiderRunBundle.Companion.message("label.flag.debug.attach-to-child-net-processes", new Object[0]), "AutoAttachChildren");
        ProgramParametersEditor programParametersEditor = new ProgramParametersEditor(RiderRunBundle.Companion.message("label.flag.additional.iis.express.arguments.with.colons", new Object[0]), "Additional_IIS_Express_arguments", lifetime);
        FlagEditor flagEditor3 = new FlagEditor(RiderRunBundle.Companion.message("label.flag.send.debug.request", new Object[0]), "Send_debug_request");
        FlagEditor flagEditor4 = new FlagEditor(RiderRunBundle.Companion.message("label.flag.show.iis.express.output", new Object[0]), "Show_IIS_Express_output");
        FlagEditorWithAction flagEditorWithAction = new FlagEditorWithAction(RiderRunBundle.Companion.message("label.generate.applicationhost.config", new Object[0]), "Generate_applicationhost.config", RiderRunBundle.Companion.message("action.open.in.editor.text", new Object[0]), (Function0<Unit>)((Function0)() -> LaunchSettingsConfigurationEditor.x(this)));
        TextEditor textEditor = new TextEditor(RiderRunBundle.Companion.message("label.hosting.model.with.colons", new Object[0]), "Hosting_model", lifetime);
        IisExpressCertificateIndicator iisExpressCertificateIndicator = new IisExpressCertificateIndicator(this.project, lifetime);
        BrowserSettingsEditor browserSettingsEditor = new BrowserSettingsEditor("");
        TextEditor textEditor2 = new TextEditor(RiderRunBundle.Companion.message("label.launch.url", new Object[0]), "Launch_URL", lifetime);
        TextEditor textEditor3 = new TextEditor(RiderRunBundle.Companion.message("label.application.url", new Object[0]), "Application_URL", lifetime);
        ViewSeparator viewSeparator = new ViewSeparator(RiderRunBundle.Companion.message("label.open.browser", new Object[0]));
        ProgramParametersEditor programParametersEditor2 = new ProgramParametersEditor(RiderRunBundle.Companion.message("label.runtime.arguments.with.colons", new Object[0]), "Runtime_arguments", lifetime);
        RuntimeSelector runtimeSelector = new RuntimeSelector(RiderRunBundle.Companion.message("label.runtime", new Object[0]), "Runtime", this.project, lifetime);
        EnumSelector<TerminalMode> enumSelector = new EnumSelector<TerminalMode>(RiderRunBundle.Companion.message("label.terminal.mode.selector", new Object[0]), "Terminal_Mode", TerminalMode.Companion.getEnumSet(), createEditor.2.INSTANCE);
        EnvironmentVariablesViewer environmentVariablesViewer = new EnvironmentVariablesViewer(RiderRunBundle.Companion.message("label.environment.variables.with.colon", new Object[0]), "Environment_variables");
        ProjectSelector projectSelector2 = new ProjectSelector(RiderRunBundle.Companion.message("label.roslyn.target.project", new Object[0]), "Roslyn_Target_Project");
        PathSelector pathSelector2 = new PathSelector(RiderRunBundle.Companion.message("label.working.directory.with.colon", new Object[0]), "Working_directory", FileChooserDescriptorFactory.createSingleFolderDescriptor(), lifetime);
        ProgramParametersEditor programParametersEditor3 = new ProgramParametersEditor(string, "Program_arguments", lifetime);
        PathSelector pathSelector3 = pathSelector;
        LaunchProfileSelector launchProfileSelector2 = launchProfileSelector;
        StringSelector stringSelector2 = stringSelector;
        ProjectSelector projectSelector3 = projectSelector;
        InfoLabel infoLabel3 = infoLabel;
        LaunchSettingsCommandRegistry launchSettingsCommandRegistry2 = launchSettingsCommandRegistry;
        RunnableProjectsModel runnableProjectsModel2 = runnableProjectsModel;
        Lifetime lifetime3 = lifetime2;
        LaunchSettingsConfigurationType launchSettingsConfigurationType2 = launchSettingsConfigurationType;
        Project project2 = project;
        launchSettingsConfigurationEditor.setViewModel(new LaunchSettingsConfigurationViewModel(project2, launchSettingsConfigurationType2, lifetime3, runnableProjectsModel2, launchSettingsCommandRegistry2, infoLabel3, projectSelector3, stringSelector2, launchProfileSelector2, pathSelector3, programParametersEditor3, pathSelector2, projectSelector2, environmentVariablesViewer, enumSelector, runtimeSelector, programParametersEditor2, viewSeparator, textEditor3, textEditor2, browserSettingsEditor, iisExpressCertificateIndicator, textEditor, flagEditorWithAction, flagEditor4, flagEditor3, programParametersEditor, flagEditor2, flagEditor));
        return new ControlViewBuilder(lifetime, this.project, "LaunchSettings").build(this.getViewModel());
    }

    @TestOnly
    @NotNull
    public final LaunchSettingsConfigurationViewModel testOnlyGetViewModel() {
        return this.getViewModel();
    }

    private static final Unit x(LaunchSettingsConfigurationEditor launchSettingsConfigurationEditor) {
        AnAction anAction = ActionManager.getInstance().getAction("OpenSolutionApplicationHostConfig");
        AnActionEvent anActionEvent = AnActionEvent.createEvent(arg_0 -> LaunchSettingsConfigurationEditor.x(launchSettingsConfigurationEditor, arg_0), null, (String)RiderActionPlaces.INSTANCE.getFLAG_EDITOR_ACTION(), (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent anActionEvent2 = anActionEvent;
        anAction.actionPerformed(anActionEvent2);
        return Unit.INSTANCE;
    }

    private static final Object x(LaunchSettingsConfigurationEditor launchSettingsConfigurationEditor, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"id");
        return Intrinsics.areEqual((Object)string, (Object)PlatformDataKeys.PROJECT.getName()) ? launchSettingsConfigurationEditor.project : null;
    }
}

