/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.iis;

import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.LifetimedSettingsEditor;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.ProjectSelector;
import com.jetbrains.rider.run.configurations.controls.TextEditor;
import com.jetbrains.rider.run.configurations.controls.ViewSeparator;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettings;
import com.jetbrains.rider.run.configurations.controls.startBrowser.BrowserSettingsEditor;
import com.jetbrains.rider.run.configurations.iis.IisApplicationConfiguration;
import com.jetbrains.rider.run.configurations.iis.IisApplicationConfigurationParameters;
import com.jetbrains.rider.run.configurations.iis.IisApplicationConfigurationViewModel;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/run/configurations/iis/IisApplicationConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/LifetimedSettingsEditor;", "Lcom/jetbrains/rider/run/configurations/iis/IisApplicationConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "IisApplicationConfigurationEditor", "(Lcom/intellij/openapi/project/Project;)V", "viewModel", "Lcom/jetbrains/rider/run/configurations/iis/IisApplicationConfigurationViewModel;", "getViewModel", "()Lcom/jetbrains/rider/run/configurations/iis/IisApplicationConfigurationViewModel;", "setViewModel", "(Lcom/jetbrains/rider/run/configurations/iis/IisApplicationConfigurationViewModel;)V", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "applyEditorTo", "", "configuration", "resetEditorFrom", "intellij.rider"})
public final class IisApplicationConfigurationEditor
extends LifetimedSettingsEditor<IisApplicationConfiguration> {
    @NotNull
    private final Project project;
    public IisApplicationConfigurationViewModel viewModel;

    public IisApplicationConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final IisApplicationConfigurationViewModel getViewModel() {
        IisApplicationConfigurationViewModel iisApplicationConfigurationViewModel = this.viewModel;
        if (iisApplicationConfigurationViewModel != null) {
            return iisApplicationConfigurationViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    public final void setViewModel(@NotNull IisApplicationConfigurationViewModel iisApplicationConfigurationViewModel) {
        Intrinsics.checkNotNullParameter((Object)iisApplicationConfigurationViewModel, (String)"<set-?>");
        this.viewModel = iisApplicationConfigurationViewModel;
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.setViewModel(new IisApplicationConfigurationViewModel(lifetime, ProjectExKt.getRunnableProjectsModelIfAvailable(this.project), new ProjectSelector(RiderRunBundle.Companion.message("label.project.with.colon", new Object[0]), "Project"), new ViewSeparator(RiderRunBundle.Companion.message("label.open.browser", new Object[0])), new TextEditor(RiderRunBundle.Companion.message("label.url", new Object[0]), "URL", lifetime), new BrowserSettingsEditor("")));
        return new ControlViewBuilder(lifetime, this.project, "IisApplication").build(this.getViewModel());
    }

    protected void applyEditorTo(@NotNull IisApplicationConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        RunnableProject runnableProject = (RunnableProject)this.getViewModel().getProjectSelector().getProject().getValueOrNull();
        if (runnableProject != null) {
            IisApplicationConfigurationParameters iisApplicationConfigurationParameters;
            IisApplicationConfigurationParameters iisApplicationConfigurationParameters2 = iisApplicationConfigurationParameters = configuration.getParameters();
            boolean bl = false;
            iisApplicationConfigurationParameters2.setProjectFilePath(runnableProject.getProjectFilePath());
            iisApplicationConfigurationParameters2.setTrackIisUrl(this.getViewModel().getTrackIisUrl());
            iisApplicationConfigurationParameters2.getStartBrowserParameters().setUrl((String)this.getViewModel().getUrlEditor().getText().getValue());
            iisApplicationConfigurationParameters2.getStartBrowserParameters().setBrowser(((BrowserSettings)this.getViewModel().getDotNetBrowserSettingsEditor().getSettings().getValue()).getMyBrowser());
            iisApplicationConfigurationParameters2.getStartBrowserParameters().setStartAfterLaunch(((BrowserSettings)this.getViewModel().getDotNetBrowserSettingsEditor().getSettings().getValue()).getStartAfterLaunch());
            iisApplicationConfigurationParameters2.getStartBrowserParameters().setWithJavaScriptDebugger(((BrowserSettings)this.getViewModel().getDotNetBrowserSettingsEditor().getSettings().getValue()).getWithJavaScriptDebugger());
        }
    }

    protected void resetEditorFrom(@NotNull IisApplicationConfiguration configuration) {
        IisApplicationConfigurationParameters iisApplicationConfigurationParameters;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        IisApplicationConfigurationParameters iisApplicationConfigurationParameters2 = iisApplicationConfigurationParameters = configuration.getParameters();
        boolean bl = false;
        this.getViewModel().reset(iisApplicationConfigurationParameters2.getProjectFilePath(), iisApplicationConfigurationParameters2.getTrackIisUrl(), iisApplicationConfigurationParameters2.getStartBrowserParameters());
    }
}

