/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.exe;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.LifetimedSettingsEditor;
import com.jetbrains.rider.run.configurations.TerminalMode;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.EnumSelector;
import com.jetbrains.rider.run.configurations.controls.EnvironmentVariablesEditor;
import com.jetbrains.rider.run.configurations.controls.PathSelector;
import com.jetbrains.rider.run.configurations.controls.ProgramParametersEditor;
import com.jetbrains.rider.run.configurations.dotNetExe.DotNetExeConfigurationEditorKt;
import com.jetbrains.rider.run.configurations.exe.ExeConfiguration;
import com.jetbrains.rider.run.configurations.exe.ExeConfigurationEditor;
import com.jetbrains.rider.run.configurations.exe.ExeConfigurationParameters;
import com.jetbrains.rider.run.configurations.exe.ExeConfigurationViewModel;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/LifetimedSettingsEditor;", "Lcom/jetbrains/rider/run/configurations/exe/ExeConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "enableMixedModeCheckbox", "", "ExeConfigurationEditor", "(Lcom/intellij/openapi/project/Project;Z)V", "viewModel", "Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationViewModel;", "getViewModel", "()Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationViewModel;", "setViewModel", "(Lcom/jetbrains/rider/run/configurations/exe/ExeConfigurationViewModel;)V", "resetEditorFrom", "", "configuration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider"})
public class ExeConfigurationEditor
extends LifetimedSettingsEditor<ExeConfiguration> {
    @NotNull
    private final Project project;
    private final boolean enableMixedModeCheckbox;
    public ExeConfigurationViewModel viewModel;

    public ExeConfigurationEditor(@NotNull Project project, boolean enableMixedModeCheckbox) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.enableMixedModeCheckbox = enableMixedModeCheckbox;
    }

    @NotNull
    public final ExeConfigurationViewModel getViewModel() {
        ExeConfigurationViewModel exeConfigurationViewModel = this.viewModel;
        if (exeConfigurationViewModel != null) {
            return exeConfigurationViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    public final void setViewModel(@NotNull ExeConfigurationViewModel exeConfigurationViewModel) {
        Intrinsics.checkNotNullParameter((Object)exeConfigurationViewModel, (String)"<set-?>");
        this.viewModel = exeConfigurationViewModel;
    }

    protected void resetEditorFrom(@NotNull ExeConfiguration configuration) {
        ExeConfigurationParameters exeConfigurationParameters;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        ExeConfigurationParameters exeConfigurationParameters2 = exeConfigurationParameters = configuration.getParameters();
        boolean bl = false;
        this.getViewModel().reset(exeConfigurationParameters2.getExePath(), exeConfigurationParameters2.getProgramParameters(), exeConfigurationParameters2.getWorkingDirectory(), exeConfigurationParameters2.getEnvs(), exeConfigurationParameters2.isPassParentEnvs(), exeConfigurationParameters2.getTerminalMode(), exeConfigurationParameters2.getEnvFilePaths(), exeConfigurationParameters2.getMixedModeDebugging(), exeConfigurationParameters2.getRedirectInputPath());
    }

    protected void applyEditorTo(@NotNull ExeConfiguration configuration) {
        ExeConfigurationParameters exeConfigurationParameters;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        ExeConfigurationParameters exeConfigurationParameters2 = exeConfigurationParameters = configuration.getParameters();
        boolean bl = false;
        String string = FileUtil.toSystemIndependentName((String)((String)this.getViewModel().getExePathSelector().getPath().getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        exeConfigurationParameters2.setExePath(string);
        exeConfigurationParameters2.setProgramParameters((String)this.getViewModel().getProgramParametersEditor().getParametersString().getValue());
        String string2 = FileUtil.toSystemIndependentName((String)((String)this.getViewModel().getWorkingDirectorySelector().getPath().getValue()));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemIndependentName(...)");
        exeConfigurationParameters2.setWorkingDirectory(string2);
        exeConfigurationParameters2.setEnvs((Map)this.getViewModel().getEnvironmentVariablesEditor().getEnvs().getValue());
        exeConfigurationParameters2.setPassParentEnvs((Boolean)this.getViewModel().getEnvironmentVariablesEditor().isPassParentEnvs().getValue());
        exeConfigurationParameters2.setEnvFilePaths((List)this.getViewModel().getEnvironmentVariablesEditor().getEnvFilePaths().getValue());
        IProperty<String> iProperty = this.getViewModel().getRedirectInputFileSelector();
        exeConfigurationParameters2.setRedirectInputPath(iProperty != null && (iProperty = iProperty.getPath()) != null ? (String)iProperty.getValue() : null);
        IProperty<Boolean> iProperty2 = this.getViewModel().getMixedModeDebuggingCheckBox();
        exeConfigurationParameters2.setMixedModeDebugging(iProperty2 != null && (iProperty2 = iProperty2.isSelected()) != null ? ((Boolean)iProperty2.getValue()).booleanValue() : false);
        TerminalMode terminalMode = (TerminalMode)((Object)this.getViewModel().getTerminalModeSelector().getRawValue().getValueOrNull());
        if (terminalMode == null) {
            terminalMode = TerminalMode.Auto;
        }
        exeConfigurationParameters2.setTerminalMode(terminalMode);
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        PathSelector pathSelector = new PathSelector(RiderRunBundle.Companion.message("label.exe.path.with.colon", new Object[0]), "Exe_path", new FileChooserDescriptor(true, false, false, false, false, false), lifetime);
        String string = ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TerminalMode[] terminalModeArray = new TerminalMode[]{TerminalMode.DotNetAllowAnsiColorRedirection};
        this.setViewModel(new ExeConfigurationViewModel(lifetime, this.project, pathSelector, new ProgramParametersEditor(string, "Program_arguments", lifetime), new PathSelector(RiderRunBundle.Companion.message("label.working.directory.with.colon", new Object[0]), "Working_directory", FileChooserDescriptorFactory.createSingleFolderDescriptor(), lifetime), new EnvironmentVariablesEditor(RiderRunBundle.Companion.message("label.environment.variables.with.colon", new Object[0]), "Environment_variables", false, true, 4, null), new EnumSelector<TerminalMode>(RiderRunBundle.Companion.message("label.terminal.mode.selector", new Object[0]), "Terminal_Mode", TerminalMode.Companion.enumSetWithout(terminalModeArray), createEditor.1.INSTANCE), true, this.enableMixedModeCheckbox ? DotNetExeConfigurationEditorKt.createMixedModeRunEditorFlag() : null, new PathSelector(RiderRunBundle.Companion.message("label.redirect.input.from", new Object[0]), "Redirect_Input", FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), lifetime)));
        return new ControlViewBuilder(lifetime, this.project, "RunNativeExe").build(this.getViewModel());
    }
}

