/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.dotNetFile;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rider.run.RiderRunBundle;
import com.jetbrains.rider.run.configurations.ProtocolLifetimedSettingsEditor;
import com.jetbrains.rider.run.configurations.TerminalMode;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.EnumSelector;
import com.jetbrains.rider.run.configurations.controls.EnvironmentVariablesEditor;
import com.jetbrains.rider.run.configurations.controls.PathSelector;
import com.jetbrains.rider.run.configurations.controls.ProgramParametersEditor;
import com.jetbrains.rider.run.configurations.dotNetFile.DotNetFileRunConfiguration;
import com.jetbrains.rider.run.configurations.dotNetFile.DotNetFileRunConfigurationEditor;
import com.jetbrains.rider.run.configurations.dotNetFile.DotNetFileRunConfigurationOptions;
import com.jetbrains.rider.run.configurations.dotNetFile.DotNetFileRunConfigurationViewModel;
import java.util.Collection;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/run/configurations/dotNetFile/DotNetFileRunConfigurationEditor;", "Lcom/jetbrains/rider/run/configurations/ProtocolLifetimedSettingsEditor;", "Lcom/jetbrains/rider/run/configurations/dotNetFile/DotNetFileRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "DotNetFileRunConfigurationEditor", "(Lcom/intellij/openapi/project/Project;)V", "viewModel", "Lcom/jetbrains/rider/run/configurations/dotNetFile/DotNetFileRunConfigurationViewModel;", "getViewModel", "()Lcom/jetbrains/rider/run/configurations/dotNetFile/DotNetFileRunConfigurationViewModel;", "setViewModel", "(Lcom/jetbrains/rider/run/configurations/dotNetFile/DotNetFileRunConfigurationViewModel;)V", "resetEditorFrom", "", "configuration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rider"})
public final class DotNetFileRunConfigurationEditor
extends ProtocolLifetimedSettingsEditor<DotNetFileRunConfiguration> {
    @NotNull
    private final Project project;
    public DotNetFileRunConfigurationViewModel viewModel;

    public DotNetFileRunConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final DotNetFileRunConfigurationViewModel getViewModel() {
        DotNetFileRunConfigurationViewModel dotNetFileRunConfigurationViewModel = this.viewModel;
        if (dotNetFileRunConfigurationViewModel != null) {
            return dotNetFileRunConfigurationViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    public final void setViewModel(@NotNull DotNetFileRunConfigurationViewModel dotNetFileRunConfigurationViewModel) {
        Intrinsics.checkNotNullParameter((Object)dotNetFileRunConfigurationViewModel, (String)"<set-?>");
        this.viewModel = dotNetFileRunConfigurationViewModel;
    }

    protected void resetEditorFrom(@NotNull DotNetFileRunConfiguration configuration) {
        DotNetFileRunConfigurationOptions dotNetFileRunConfigurationOptions;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        DotNetFileRunConfigurationOptions dotNetFileRunConfigurationOptions2 = dotNetFileRunConfigurationOptions = configuration.getDotNetFileOptions();
        boolean bl = false;
        this.getViewModel().reset(dotNetFileRunConfigurationOptions2.getFilePath(), dotNetFileRunConfigurationOptions2.getProgramParameters(), dotNetFileRunConfigurationOptions2.getWorkingDirectory(), dotNetFileRunConfigurationOptions2.getEnvs(), dotNetFileRunConfigurationOptions2.isPassParentEnvs(), dotNetFileRunConfigurationOptions2.getEnvFilePaths(), dotNetFileRunConfigurationOptions2.getTerminalMode(), dotNetFileRunConfigurationOptions2.getRedirectInputPath());
    }

    protected void applyEditorTo(@NotNull DotNetFileRunConfiguration configuration) {
        IProperty<String> iProperty;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        configuration.getDotNetFileOptions().setFilePath((String)this.getViewModel().getFilePathSelector().getPath().getValue());
        configuration.getDotNetFileOptions().setProgramParameters((String)this.getViewModel().getProgramParametersEditor().getParametersString().getValue());
        configuration.getDotNetFileOptions().setWorkingDirectory((String)this.getViewModel().getWorkingDirectorySelector().getPath().getValue());
        configuration.getDotNetFileOptions().setEnvs((Map)this.getViewModel().getEnvironmentVariablesEditor().getEnvs().getValue());
        configuration.getDotNetFileOptions().setPassParentEnvs((Boolean)this.getViewModel().getEnvironmentVariablesEditor().isPassParentEnvs().getValue());
        configuration.getDotNetFileOptions().setEnvFilePaths(CollectionsKt.toMutableList((Collection)((Collection)this.getViewModel().getEnvironmentVariablesEditor().getEnvFilePaths().getValue())));
        DotNetFileRunConfigurationOptions dotNetFileRunConfigurationOptions = configuration.getDotNetFileOptions();
        TerminalMode terminalMode = (TerminalMode)((Object)this.getViewModel().getTerminalModeSelector().getRawValue().getValueOrNull());
        if (terminalMode == null) {
            terminalMode = TerminalMode.Auto;
        }
        dotNetFileRunConfigurationOptions.setTerminalMode(terminalMode);
        configuration.getDotNetFileOptions().setRedirectInputPath((iProperty = this.getViewModel().getRedirectInputFileSelector()) != null && (iProperty = iProperty.getPath()) != null ? (String)iProperty.getValue() : null);
    }

    @NotNull
    public JComponent createEditor(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        PathSelector pathSelector = new PathSelector(RiderRunBundle.Companion.message("label.file.path.with.colon", new Object[0]), "Cs_file_path", new FileChooserDescriptor(){
            {
                this.withExtensionFilter("cs");
            }

            public void validateSelectedFiles(VirtualFile[] files) {
                Intrinsics.checkNotNullParameter((Object)files, (String)"files");
                VirtualFile virtualFile = (VirtualFile)ArraysKt.singleOrNull((Object[])files);
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl = false;
                    String string = virtualFile2.getExtension();
                    boolean bl2 = string != null ? !StringsKt.equals((String)string, (String)"cs", (boolean)true) : false;
                    if (bl2) {
                        throw new RuntimeConfigurationError(RiderRunBundle.Companion.message("dialog.message.only.cs.files.are.supported", new Object[0]));
                    }
                    if (!virtualFile2.exists()) {
                        CharSequence charSequence;
                        Object[] objectArray;
                        RiderRunBundle.Companion companion = RiderRunBundle.Companion;
                        String string2 = "dialog.message.invalid.csFile.path";
                        Object[] objectArray2 = objectArray = new Object[1];
                        int n = 0;
                        CharSequence charSequence2 = virtualFile2.getPath();
                        if (StringsKt.isBlank((CharSequence)charSequence2)) {
                            int n2 = n;
                            Object[] objectArray3 = objectArray2;
                            String string3 = string2;
                            RiderRunBundle.Companion companion2 = companion;
                            boolean bl3 = false;
                            String string4 = "<empty>";
                            companion = companion2;
                            string2 = string3;
                            objectArray2 = objectArray3;
                            n = n2;
                            charSequence = string4;
                        } else {
                            charSequence = charSequence2;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"ifBlank(...)");
                        objectArray2[n] = charSequence;
                        String string5 = companion.message(string2, objectArray);
                        throw new RuntimeConfigurationError(string5);
                    }
                }
            }

            protected boolean matchesFilters(VirtualFile file2) {
                return true;
            }
        }, lifetime);
        String string = ExecutionBundle.message((String)"run.configuration.program.parameters", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setViewModel(new DotNetFileRunConfigurationViewModel(lifetime, this.project, pathSelector, new ProgramParametersEditor(string, "Program_arguments", lifetime), new PathSelector(RiderRunBundle.Companion.message("label.working.directory.with.colon", new Object[0]), "Working_directory", FileChooserDescriptorFactory.createSingleFolderDescriptor(), lifetime), new EnvironmentVariablesEditor(RiderRunBundle.Companion.message("label.environment.variables.with.colon", new Object[0]), "Environment_variables", false, true, 4, null), new EnumSelector<TerminalMode>(RiderRunBundle.Companion.message("label.terminal.mode.selector", new Object[0]), "Terminal_Mode", TerminalMode.Companion.getEnumSet(), createEditor.2.INSTANCE), new PathSelector(RiderRunBundle.Companion.message("label.redirect.input.from", new Object[0]), "Redirect_Input", FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), lifetime), false, 256, null));
        return new ControlViewBuilder(lifetime, this.project, "RunDotNetFile").build(this.getViewModel());
    }
}

