/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.controls;

import com.intellij.execution.impl.statistics.RunConfigurationOptionUsagesCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.util.TlsBoxed;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rider.cpp.RiderCppCoreBundle;
import com.jetbrains.rider.run.configurations.ProjectPropertiesMacroUtils;
import com.jetbrains.rider.run.configurations.controls.EditorWithMacroSupport;
import icons.RiderIcons;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JH\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000b2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J8\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\f0\u000b2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\u000f\u001a\u00020\u0011JO\u0010\u0014\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u000b2\u0011\u0010\u0016\u001a\r\u0012\t\u0012\u00070\r\u00a2\u0006\u0002\b\u00170\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000b2\u0006\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport;", "", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "EditorWithMacroSupport", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "installFileCompletionCapabilities", "", "macros", "Lcom/jetbrains/rd/util/reactive/IProperty;", "", "", "rootDirectory", "textField", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "Ljavax/swing/JTextField;", "descriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "installTextEditingCapabilities", "text", "tooltip", "Lorg/jetbrains/annotations/Nls;", "mixedValue", "", "fusOptionId", "runConfigId", "MacroFilter", "MacroFinder", "MacroLookup", "TextFieldWithCompletion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nEditorWithMacroSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorWithMacroSupport.kt\ncom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport\n+ 2 Boxed.kt\ncom/jetbrains/rd/util/BoxedKt\n*L\n1#1,331:1\n13#2,6:332\n13#2,6:338\n*S KotlinDebug\n*F\n+ 1 EditorWithMacroSupport.kt\ncom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport\n*L\n111#1:332,6\n126#1:338,6\n*E\n"})
public final class EditorWithMacroSupport {
    @NotNull
    private final Project project;
    @NotNull
    private final Lifetime lifetime;

    public EditorWithMacroSupport(@NotNull Project project, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.project = project;
        this.lifetime = lifetime;
    }

    public final void installFileCompletionCapabilities(@NotNull IProperty<Map<String, String>> macros, @NotNull IProperty<String> rootDirectory, @NotNull ComponentWithBrowseButton<JTextField> textField2, @Nullable FileChooserDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(macros, (String)"macros");
        Intrinsics.checkNotNullParameter(rootDirectory, (String)"rootDirectory");
        Intrinsics.checkNotNullParameter(textField2, (String)"textField");
        if (descriptor2 != null) {
            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0014J\u0014\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"com/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$installFileCompletionCapabilities$BrowseFolderListener", "Lcom/intellij/openapi/ui/TextBrowseFolderListener;", "fileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "EditorWithMacroSupport$installFileCompletionCapabilities$BrowseFolderListener", "(Lcom/jetbrains/rd/util/reactive/IProperty;Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;Lcom/intellij/openapi/project/Project;)V", "innerMacros", "", "", "resetMacroMap", "", "macroMap", "expandPath", "path", "setOwnerComponent", "component", "Lcom/intellij/openapi/ui/ComponentWithBrowseButton;", "Ljavax/swing/JTextField;", "intellij.rider"})
            @SourceDebugExtension(value={"SMAP\nEditorWithMacroSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorWithMacroSupport.kt\ncom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$installFileCompletionCapabilities$BrowseFolderListener\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,331:1\n126#2:332\n153#2,3:333\n*S KotlinDebug\n*F\n+ 1 EditorWithMacroSupport.kt\ncom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$installFileCompletionCapabilities$BrowseFolderListener\n*L\n48#1:332\n48#1:333,3\n*E\n"})
            public final class BrowseFolderListener
            extends TextBrowseFolderListener {
                private Map<String, String> innerMacros;
                final /* synthetic */ IProperty<String> $rootDirectory;

                public BrowseFolderListener(IProperty<String> $rootDirectory, FileChooserDescriptor fileChooserDescriptor, Project project) {
                    Intrinsics.checkNotNullParameter((Object)fileChooserDescriptor, (String)"fileChooserDescriptor");
                    this.$rootDirectory = $rootDirectory;
                    super(fileChooserDescriptor, project);
                    this.innerMacros = MapsKt.emptyMap();
                }

                public final void resetMacroMap(Map<String, String> macroMap) {
                    Intrinsics.checkNotNullParameter(macroMap, (String)"macroMap");
                    Map<String, String> map2 = macroMap;
                    BrowseFolderListener browseFolderListener = this;
                    boolean bl = false;
                    Map<String, String> map3 = map2;
                    Collection collection = new ArrayList<E>(map2.size());
                    boolean bl2 = false;
                    Iterator<Map.Entry<String, String>> iterator2 = map3.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry<String, String> entry2;
                        Map.Entry<String, String> entry3 = entry2 = iterator2.next();
                        Collection collection2 = collection;
                        boolean bl3 = false;
                        String string = entry3.getKey().substring(2, entry3.getKey().length() - 1);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        collection2.add(TuplesKt.to((Object)string, (Object)entry3.getValue()));
                    }
                    browseFolderListener.innerMacros = MapsKt.toMap((Iterable)((List)collection));
                }

                protected String expandPath(String path) {
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    String string = ProjectPropertiesMacroUtils.Companion.processMacros(path, this.innerMacros);
                    String string2 = (String)this.$rootDirectory.getValue();
                    if (string2 != null) {
                        String string3 = FilesKt.resolve((File)new File(string2), (String)string).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                        string = string3;
                    }
                    String string4 = super.expandPath(string);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"expandPath(...)");
                    return string4;
                }

                public final void setOwnerComponent(ComponentWithBrowseButton<JTextField> component2) {
                    Intrinsics.checkNotNullParameter(component2, (String)"component");
                    this.myTextComponent = component2.getChildComponent();
                }
            }
            BrowseFolderListener browseFolderListener = new BrowseFolderListener(rootDirectory, descriptor2, this.project);
            browseFolderListener.setOwnerComponent(textField2);
            textField2.addActionListener((ActionListener)((Object)browseFolderListener));
            macros.advise(this.lifetime, arg_0 -> EditorWithMacroSupport.x(browseFolderListener, arg_0));
        }
        JComponent jComponent = textField2.getChildComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getChildComponent(...)");
        this.installFileCompletionCapabilities(macros, rootDirectory, (JTextField)jComponent);
    }

    public final void installFileCompletionCapabilities(@NotNull IProperty<Map<String, String>> macros, @NotNull IProperty<String> rootDirectory, @NotNull JTextField textField2) {
        Intrinsics.checkNotNullParameter(macros, (String)"macros");
        Intrinsics.checkNotNullParameter(rootDirectory, (String)"rootDirectory");
        Intrinsics.checkNotNullParameter((Object)textField2, (String)"textField");
        TextFieldWithCompletion textFieldWithCompletion = new TextFieldWithCompletion(textField2, new MacroFinder(textField2), null);
        macros.advise(this.lifetime, arg_0 -> EditorWithMacroSupport.x(textFieldWithCompletion, arg_0));
        rootDirectory.advise(this.lifetime, arg_0 -> EditorWithMacroSupport.x(textFieldWithCompletion, arg_0));
    }

    public final void installTextEditingCapabilities(@NotNull IProperty<String> text, @NotNull IProperty<String> tooltip, @NotNull IProperty<Boolean> mixedValue, @NotNull String fusOptionId, @Nullable String runConfigId, @NotNull JTextField textField2) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter(mixedValue, (String)"mixedValue");
        Intrinsics.checkNotNullParameter((Object)fusOptionId, (String)"fusOptionId");
        Intrinsics.checkNotNullParameter((Object)textField2, (String)"textField");
        UIUtil.addUndoRedoActions((JTextComponent)textField2);
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getGlobalScheme(...)");
        EditorColorsScheme editorColorsScheme2 = editorColorsScheme;
        TextAttributes textAttributes = editorColorsScheme2.getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
        Color color = textField2.getForeground();
        Color color2 = textField2.getBackground();
        TlsBoxed tlsBoxed = new TlsBoxed((Object)false);
        text.advise(this.lifetime, arg_0 -> EditorWithMacroSupport.x(textField2, mixedValue, tlsBoxed, arg_0));
        tooltip.advise(this.lifetime, arg_0 -> EditorWithMacroSupport.x(text, textField2, arg_0));
        mixedValue.advise(this.lifetime, arg_0 -> EditorWithMacroSupport.x(mixedValue, textField2, text, tlsBoxed, textAttributes, color, color2, arg_0));
        textField2.addFocusListener(new FocusListener(mixedValue, (TlsBoxed<Boolean>)tlsBoxed, textField2, textAttributes, color, color2){
            final /* synthetic */ IProperty<Boolean> $mixedValue;
            final /* synthetic */ TlsBoxed<Boolean> $guard;
            final /* synthetic */ JTextField $textField;
            final /* synthetic */ TextAttributes $placeholderAttributes;
            final /* synthetic */ Color $originalForeground;
            final /* synthetic */ Color $originalBackground;
            {
                this.$mixedValue = $mixedValue;
                this.$guard = $guard;
                this.$textField = $textField;
                this.$placeholderAttributes = $placeholderAttributes;
                this.$originalForeground = $originalForeground;
                this.$originalBackground = $originalBackground;
            }

            public void focusLost(FocusEvent p0) {
                if (((Boolean)this.$mixedValue.getValue()).booleanValue()) {
                    EditorWithMacroSupport.access$installTextEditingCapabilities$installPlaceholder(this.$guard, this.$textField, this.$placeholderAttributes, this.$originalForeground, this.$originalBackground, true);
                }
            }

            public void focusGained(FocusEvent p0) {
                if (((Boolean)this.$mixedValue.getValue()).booleanValue()) {
                    EditorWithMacroSupport.access$installTextEditingCapabilities$installPlaceholder(this.$guard, this.$textField, this.$placeholderAttributes, this.$originalForeground, this.$originalBackground, false);
                    this.$textField.setText("");
                }
            }
        });
        textField2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((TlsBoxed<Boolean>)tlsBoxed, runConfigId, text, textField2, this, fusOptionId, mixedValue){
            final /* synthetic */ TlsBoxed<Boolean> $guard;
            final /* synthetic */ String $runConfigId;
            final /* synthetic */ IProperty<String> $text;
            final /* synthetic */ JTextField $textField;
            final /* synthetic */ EditorWithMacroSupport this$0;
            final /* synthetic */ String $fusOptionId;
            final /* synthetic */ IProperty<Boolean> $mixedValue;
            {
                this.$guard = $guard;
                this.$runConfigId = $runConfigId;
                this.$text = $text;
                this.$textField = $textField;
                this.this$0 = $receiver;
                this.$fusOptionId = $fusOptionId;
                this.$mixedValue = $mixedValue;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (((Boolean)this.$guard.getValue()).booleanValue()) {
                    return;
                }
                if (this.$runConfigId != null && !Intrinsics.areEqual((Object)this.$text.getValue(), (Object)this.$textField.getText())) {
                    RunConfigurationOptionUsagesCollector.logModifyOption((Project)EditorWithMacroSupport.access$getProject$p(this.this$0), (String)this.$fusOptionId, (String)this.$runConfigId, null);
                }
                this.$mixedValue.set((Object)false);
                String string = this.$textField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.$text.set((Object)string);
            }
        });
    }

    private static final Unit x(installFileCompletionCapabilities.BrowseFolderListener browseFolderListener, Map map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"it");
        browseFolderListener.resetMacroMap(map2);
        return Unit.INSTANCE;
    }

    private static final Unit x(TextFieldWithCompletion textFieldWithCompletion, Map map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"it");
        textFieldWithCompletion.resetMacroMap(map2);
        return Unit.INSTANCE;
    }

    private static final Unit x(TextFieldWithCompletion textFieldWithCompletion, String string) {
        textFieldWithCompletion.resetRootDirectory(string);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit x(JTextField jTextField, IProperty iProperty, TlsBoxed tlsBoxed, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"it");
        if (!Intrinsics.areEqual((Object)jTextField.getText(), (Object)string) && !((Boolean)iProperty.getValue()).booleanValue()) {
            TlsBoxed tlsBoxed2 = tlsBoxed;
            boolean bl = false;
            if (!((Boolean)tlsBoxed2.getValue() == false)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            tlsBoxed2.setValue((Object)true);
            try {
                boolean bl2 = false;
                jTextField.setText(string);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                tlsBoxed2.setValue((Object)false);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit x(IProperty iProperty, JTextField jTextField, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"it");
        if (Intrinsics.areEqual((Object)string, (Object)iProperty.getValue())) {
            jTextField.setToolTipText(null);
        } else if (!Intrinsics.areEqual((Object)jTextField.getToolTipText(), (Object)string)) {
            jTextField.setToolTipText(string);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void x(TlsBoxed<Boolean> tlsBoxed, JTextField jTextField, TextAttributes textAttributes, Color color, Color color2, boolean bl) {
        TlsBoxed<Boolean> tlsBoxed2 = tlsBoxed;
        boolean bl2 = false;
        if (!((Boolean)tlsBoxed2.getValue() == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        tlsBoxed2.setValue((Object)true);
        try {
            boolean bl3 = false;
            if (bl) {
                jTextField.setText(RiderCppCoreBundle.Companion.message("cpp.run.configuration.DifferentOptions", new Object[0]));
                jTextField.setForeground(textAttributes.getForegroundColor());
                jTextField.setBackground(textAttributes.getBackgroundColor());
            } else {
                jTextField.setForeground(color);
                jTextField.setBackground(color2);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            tlsBoxed2.setValue((Object)false);
        }
    }

    private static final Unit x(IProperty iProperty, JTextField jTextField, IProperty iProperty2, TlsBoxed tlsBoxed, TextAttributes textAttributes, Color color, Color color2, boolean bl) {
        EditorWithMacroSupport.x((TlsBoxed<Boolean>)tlsBoxed, jTextField, textAttributes, color, color2, (Boolean)iProperty.getValue());
        if (!((Boolean)iProperty.getValue()).booleanValue()) {
            jTextField.setText((String)iProperty2.getValue());
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$installTextEditingCapabilities$installPlaceholder(TlsBoxed guard, JTextField $textField, TextAttributes placeholderAttributes, Color originalForeground, Color originalBackground, boolean value2) {
        EditorWithMacroSupport.x((TlsBoxed<Boolean>)guard, $textField, placeholderAttributes, originalForeground, originalBackground, value2);
    }

    public static final /* synthetic */ Project access$getProject$p(EditorWithMacroSupport $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$MacroFilter;", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFilter;", "EditorWithMacroSupport$MacroFilter", "()V", "isAccepted", "", "file", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFile;", "intellij.rider"})
    public static final class MacroFilter
    implements FileLookup.LookupFilter {
        public boolean isAccepted(@Nullable FileLookup.LookupFile file2) {
            FileLookup.LookupFile lookupFile = file2;
            return (lookupFile != null ? lookupFile.getMacro() : null) != null || file2 != null && file2.exists();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$MacroFinder;", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$Finder;", "textField", "Ljavax/swing/JTextField;", "EditorWithMacroSupport$MacroFinder", "(Ljavax/swing/JTextField;)V", "getTextField", "()Ljavax/swing/JTextField;", "macros", "", "", "rootDirectory", "resetMacroMap", "", "macroMap", "resetRootDirectory", "dir", "normalize", "path", "getSeparator", "find", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFile;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nEditorWithMacroSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorWithMacroSupport.kt\ncom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$MacroFinder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,331:1\n126#2:332\n153#2,3:333\n*S KotlinDebug\n*F\n+ 1 EditorWithMacroSupport.kt\ncom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$MacroFinder\n*L\n183#1:332\n183#1:333,3\n*E\n"})
    public static final class MacroFinder
    implements FileLookup.Finder {
        @NotNull
        private final JTextField textField;
        @NotNull
        private Map<String, String> macros;
        @Nullable
        private String rootDirectory;

        public MacroFinder(@NotNull JTextField textField2) {
            Intrinsics.checkNotNullParameter((Object)textField2, (String)"textField");
            this.textField = textField2;
            this.macros = MapsKt.emptyMap();
        }

        @NotNull
        public final JTextField getTextField() {
            return this.textField;
        }

        public final void resetMacroMap(@NotNull Map<String, String> macroMap) {
            Intrinsics.checkNotNullParameter(macroMap, (String)"macroMap");
            Map<String, String> map2 = macroMap;
            MacroFinder macroFinder = this;
            boolean bl = false;
            Map<String, String> map3 = map2;
            Collection collection = new ArrayList(map2.size());
            boolean bl2 = false;
            Iterator<Map.Entry<String, String>> iterator2 = map3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> entry2;
                Map.Entry<String, String> entry3 = entry2 = iterator2.next();
                Collection collection2 = collection;
                boolean bl3 = false;
                String string = entry3.getKey().substring(2, entry3.getKey().length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                collection2.add(TuplesKt.to((Object)string, (Object)entry3.getValue()));
            }
            macroFinder.macros = MapsKt.toMap((Iterable)((List)collection));
        }

        public final void resetRootDirectory(@Nullable String dir) {
            this.rootDirectory = dir;
        }

        @NotNull
        public String normalize(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return path;
        }

        @NotNull
        public String getSeparator() {
            String string = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
            return string;
        }

        @Nullable
        public FileLookup.LookupFile find(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            IntRange intRange = TextFieldWithCompletion.Companion.getCompletionPrefixRange(this.textField);
            String string = this.textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = 0;
            int n2 = intRange.getFirst();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String string4 = string3;
            if (Intrinsics.areEqual((Object)path, (Object)"$") && !StringsKt.startsWith$default((String)TextFieldWithCompletion.Companion.getCompletionPrefixText(this.textField), (String)"$", (boolean)false, (int)2, null)) {
                return null;
            }
            return new MacroLookup(string4, path, this.macros, this.rootDirectory);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0016J\b\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$MacroLookup;", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFile;", "prefix", "", "text", "macros", "", "rootDirectory", "EditorWithMacroSupport$MacroLookup", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "getText", "getMacros", "()Ljava/util/Map;", "macroName", "getIcon", "Ljavax/swing/Icon;", "isDirectory", "", "getParent", "setMacro", "", "macro", "getChildren", "", "filter", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFilter;", "getName", "getMacro", "getAbsolutePath", "exists", "intellij.rider"})
    public static final class MacroLookup
    implements FileLookup.LookupFile {
        @NotNull
        private final String prefix;
        @NotNull
        private final String text;
        @NotNull
        private final Map<String, String> macros;
        @Nullable
        private final String rootDirectory;
        @Nullable
        private String macroName;

        public MacroLookup(@NotNull String prefix, @NotNull String text, @NotNull Map<String, String> macros, @Nullable String rootDirectory) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(macros, (String)"macros");
            this.prefix = prefix;
            this.text = text;
            this.macros = macros;
            this.rootDirectory = rootDirectory;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Map<String, String> getMacros() {
            return this.macros;
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = RiderIcons.Nodes.FolderResources;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FolderResources");
            return icon;
        }

        public boolean isDirectory() {
            return true;
        }

        @Nullable
        public FileLookup.LookupFile getParent() {
            if (((CharSequence)this.text).length() > 0) {
                return new MacroLookup(this.prefix, "", this.macros, this.rootDirectory);
            }
            return null;
        }

        public void setMacro(@Nullable String macro) {
            this.macroName = macro;
        }

        @NotNull
        public List<FileLookup.LookupFile> getChildren(@Nullable FileLookup.LookupFilter filter2) {
            if (((CharSequence)this.text).length() == 0) {
                File file2;
                String string = ProjectPropertiesMacroUtils.Companion.processMacros(this.prefix, this.macros);
                File file3 = file2 = this.rootDirectory != null ? FilesKt.resolve((File)new File(this.rootDirectory), (String)string) : new File(string);
                if (LocalFileSystem.getInstance().findFileByIoFile(file2) != null) {
                    List list2 = new LocalFsFinder.IoFile(file2.toPath()).getChildren(filter2);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
                    return list2;
                }
            }
            return new ArrayList();
        }

        @NotNull
        public String getName() {
            String string = this.macroName;
            if (string == null) {
                string = "";
            }
            return string;
        }

        @NotNull
        public String getMacro() {
            String string = this.macroName;
            if (string == null) {
                string = "";
            }
            return string;
        }

        @NotNull
        public String getAbsolutePath() {
            return this.text;
        }

        public boolean exists() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$TextFieldWithCompletion;", "Lcom/intellij/openapi/fileChooser/ex/FileTextFieldImpl;", "textField", "Ljavax/swing/JTextField;", "fileFinder", "Lcom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$MacroFinder;", "parent", "Lcom/intellij/openapi/Disposable;", "EditorWithMacroSupport$TextFieldWithCompletion", "(Ljavax/swing/JTextField;Lcom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$MacroFinder;Lcom/intellij/openapi/Disposable;)V", "getParent", "()Lcom/intellij/openapi/Disposable;", "getSelectedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCompletionBase", "", "resetMacroMap", "", "macroMap", "", "resetRootDirectory", "dir", "setTextToFile", "file", "Lcom/intellij/openapi/fileChooser/ex/FileLookup$LookupFile;", "getPathVariablesSeparatorText", "Companion", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nEditorWithMacroSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorWithMacroSupport.kt\ncom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$TextFieldWithCompletion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,331:1\n126#2:332\n153#2,3:333\n*S KotlinDebug\n*F\n+ 1 EditorWithMacroSupport.kt\ncom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$TextFieldWithCompletion\n*L\n306#1:332\n306#1:333,3\n*E\n"})
    public static final class TextFieldWithCompletion
    extends FileTextFieldImpl {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final JTextField textField;
        @NotNull
        private final MacroFinder fileFinder;
        @Nullable
        private final Disposable parent;

        public TextFieldWithCompletion(@NotNull JTextField textField2, @NotNull MacroFinder fileFinder, @Nullable Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)textField2, (String)"textField");
            Intrinsics.checkNotNullParameter((Object)fileFinder, (String)"fileFinder");
            super(textField2, (FileLookup.Finder)fileFinder, (FileLookup.LookupFilter)new MacroFilter(), MapsKt.emptyMap(), parent);
            this.textField = textField2;
            this.fileFinder = fileFinder;
            this.parent = parent;
            this.myAutopopup = true;
        }

        @Nullable
        public final Disposable getParent() {
            return this.parent;
        }

        @Nullable
        public VirtualFile getSelectedFile() {
            VirtualFile virtualFile;
            if (this.getFile() != null) {
                FileLookup.LookupFile lookupFile = this.getFile();
                Intrinsics.checkNotNull((Object)lookupFile, (String)"null cannot be cast to non-null type com.intellij.openapi.fileChooser.ex.LocalFsFinder.VfsFile");
                virtualFile = ((LocalFsFinder.VfsFile)lookupFile).getFile();
            } else {
                virtualFile = null;
            }
            return virtualFile;
        }

        @NotNull
        public String getCompletionBase() {
            return Companion.getCompletionPrefixText(this.textField);
        }

        public void resetMacroMap(@NotNull Map<String, String> macroMap) {
            Intrinsics.checkNotNullParameter(macroMap, (String)"macroMap");
            Map<String, String> map2 = macroMap;
            TextFieldWithCompletion textFieldWithCompletion = this;
            boolean bl = false;
            Map<String, String> map3 = map2;
            Collection collection = new ArrayList(map2.size());
            boolean bl2 = false;
            Iterator<Map.Entry<String, String>> iterator2 = map3.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> entry2;
                Map.Entry<String, String> entry3 = entry2 = iterator2.next();
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(TuplesKt.to((Object)entry3.getKey(), (Object)"$"));
            }
            super.resetMacroMap(MapsKt.toMap((Iterable)((List)collection)));
            this.fileFinder.resetMacroMap(macroMap);
        }

        public final void resetRootDirectory(@Nullable String dir) {
            this.fileFinder.resetRootDirectory(dir);
        }

        protected void setTextToFile(@NotNull FileLookup.LookupFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            IntRange intRange = Companion.getCompletionPrefixRange(this.textField);
            Object object = file2.getMacro();
            if (object == null) {
                object = !file2.isDirectory() ? file2.getName() : file2.getName() + File.separator;
            }
            String string = object;
            String string2 = this.textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String string3 = string2;
            int n = intRange.getFirst();
            int n2 = this.textField.getText().length();
            Intrinsics.checkNotNull((Object)string);
            CharSequence charSequence = string;
            this.setText(((Object)StringsKt.replaceRange((CharSequence)string3, (int)n, (int)n2, (CharSequence)charSequence)).toString(), true, TextFieldWithCompletion::x);
            this.textField.setCaretPosition(intRange.getFirst() + string.length());
        }

        @NotNull
        protected String getPathVariablesSeparatorText() {
            return "";
        }

        private static final void x() {
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/run/configurations/controls/EditorWithMacroSupport$TextFieldWithCompletion$Companion;", "", "EditorWithMacroSupport$TextFieldWithCompletion$Companion", "()V", "getCompletionPrefixRange", "Lkotlin/ranges/IntRange;", "textField", "Ljavax/swing/JTextField;", "getCompletionPrefixText", "", "intellij.rider"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final IntRange getCompletionPrefixRange(@NotNull JTextField textField2) {
                int n;
                Intrinsics.checkNotNullParameter((Object)textField2, (String)"textField");
                Object object = new Character[]{Character.valueOf('\\'), Character.valueOf('/'), Character.valueOf(' '), Character.valueOf(')')};
                List list2 = CollectionsKt.listOf((Object[])object);
                String string = textField2.getText();
                if (string == null) {
                    return IntRange.Companion.getEMPTY();
                }
                object = string;
                int n2 = textField2.getCaretPosition() - 1;
                if (n2 >= ((String)object).length()) {
                    n2 = ((String)object).length();
                }
                for (n = n2 + 1; n != 0 && !list2.contains(Character.valueOf(((String)object).charAt(n - 1))); --n) {
                }
                return new IntRange(n, n2);
            }

            @NotNull
            public final String getCompletionPrefixText(@NotNull JTextField textField2) {
                Intrinsics.checkNotNullParameter((Object)textField2, (String)"textField");
                String string = textField2.getText();
                if (string == null) {
                    string = "";
                }
                String string2 = string;
                IntRange intRange = this.getCompletionPrefixRange(textField2);
                return intRange.isEmpty() ? "" : StringsKt.substring((String)string2, (IntRange)intRange);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

