/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run;

import com.intellij.execution.configurations.CommandLineWithSuspendedProcessCallback;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.run.ExternalConsoleProcessHandler;
import com.jetbrains.rider.run.ProcessWatchDog;
import com.jetbrains.rider.run.WinProcessWatchDog;
import com.jetbrains.rider.shared.run.IORedirectionMode;
import com.jetbrains.rider.shared.run.WindowsProcess;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.LongConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler;", "Lcom/jetbrains/rider/run/ExternalConsoleProcessHandler;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "WinExternalConsoleProcessHandler", "(Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "pid", "", "getPid", "()I", "watchDog", "Lcom/jetbrains/rider/run/ProcessWatchDog;", "getWatchDog", "()Lcom/jetbrains/rider/run/ProcessWatchDog;", "handle", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "getHandle", "()Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "process", "Lcom/jetbrains/rider/shared/run/WindowsProcess;", "destroyProcessImpl", "", "killProcess", "Companion", "Kernel32Ex", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nExternalConsoleMediator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalConsoleMediator.kt\ncom/jetbrains/rider/run/WinExternalConsoleProcessHandler\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,436:1\n13#2:437\n13#3:438\n*S KotlinDebug\n*F\n+ 1 ExternalConsoleMediator.kt\ncom/jetbrains/rider/run/WinExternalConsoleProcessHandler\n*L\n143#1:437\n143#1:438\n*E\n"})
public final class WinExternalConsoleProcessHandler
extends ExternalConsoleProcessHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int pid;
    @NotNull
    private final ProcessWatchDog watchDog;
    @NotNull
    private final WinNT.HANDLE handle;
    @NotNull
    private final WindowsProcess process;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<LongConsumer> SUSPENDED_PROCESS_CALLBACK;

    public WinExternalConsoleProcessHandler(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        super(commandLine);
        if (!SystemInfo.isWindows) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Path path = commandLine.getWorkingDirectory();
        String string = path != null ? ((Object)path).toString() : null;
        LongConsumer longConsumer = null;
        longConsumer = commandLine instanceof CommandLineWithSuspendedProcessCallback ? ((CommandLineWithSuspendedProcessCallback)commandLine).getWinSuspendedProcessCallback() : (LongConsumer)commandLine.getUserData(SUSPENDED_PROCESS_CALLBACK);
        this.process = new WindowsProcess(true, IORedirectionMode.ExternalConsole, this.getCommandLineString(), commandLine.getEffectiveEnvironment(), string, longConsumer);
        WinNT.HANDLE hANDLE = this.process.getProcessInfo().hProcess;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)"hProcess");
        this.handle = hANDLE;
        this.pid = this.process.getProcessInfo().dwProcessId.intValue();
        this.getLifetimeDefinition().getLifetime().onTermination(() -> WinExternalConsoleProcessHandler.x(this));
        this.watchDog = new WinProcessWatchDog(this.handle, this.getPresentableName(commandLine), (Function0<Integer>)((Function0)() -> WinExternalConsoleProcessHandler.x(this)));
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.getWatchDog().setTerminationCallback((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>((Object)this){

                    public final void invoke(int p0) {
                        ((WinExternalConsoleProcessHandler)((Object)this.receiver)).notifyProcessTerminated(p0);
                    }
                }));
            }
        });
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    @NotNull
    protected ProcessWatchDog getWatchDog() {
        return this.watchDog;
    }

    @NotNull
    public final WinNT.HANDLE getHandle() {
        return this.handle;
    }

    protected void destroyProcessImpl() {
        this.executeOnPooledThread(() -> WinExternalConsoleProcessHandler.x(this));
    }

    public void killProcess() {
        if (!Kernel32.INSTANCE.TerminateProcess(this.handle, -1)) {
            int n = Kernel32.INSTANCE.GetLastError();
            throw new RuntimeException("TerminateProcess failed with error code: " + n);
        }
    }

    private static final Unit x(WinExternalConsoleProcessHandler winExternalConsoleProcessHandler) {
        winExternalConsoleProcessHandler.process.dispose();
        return Unit.INSTANCE;
    }

    private static final int x(WinExternalConsoleProcessHandler winExternalConsoleProcessHandler) {
        IntByReference intByReference = new IntByReference();
        if (!Kernel32.INSTANCE.GetExitCodeProcess(winExternalConsoleProcessHandler.handle, intByReference)) {
            throw new RuntimeException("Failed to get exit code for process " + winExternalConsoleProcessHandler.getPid());
        }
        return intByReference.getValue();
    }

    private static final void x(WinExternalConsoleProcessHandler winExternalConsoleProcessHandler) {
        try {
            OSProcessUtil.terminateProcessGracefully((int)winExternalConsoleProcessHandler.getPid());
        }
        catch (Exception exception) {
            logger.warn("Failed to terminate process gracefully, so it will be terminated forcefully", (Throwable)exception);
            winExternalConsoleProcessHandler.killProcess();
        }
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(WinExternalConsoleProcessHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        WinExternalConsoleProcessHandler.logger = logger;
        Key key = Key.create((String)"SUSPENDED_PROCESS_CALLBACK");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SUSPENDED_PROCESS_CALLBACK = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler$Companion;", "", "WinExternalConsoleProcessHandler$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "SUSPENDED_PROCESS_CALLBACK", "Lcom/intellij/openapi/util/Key;", "Ljava/util/function/LongConsumer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getSUSPENDED_PROCESS_CALLBACK", "()Lcom/intellij/openapi/util/Key;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<LongConsumer> getSUSPENDED_PROCESS_CALLBACK() {
            return SUSPENDED_PROCESS_CALLBACK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "ResumeThread", "", "hThread", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "Companion", "intellij.rider"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean ResumeThread(@NotNull WinNT.HANDLE var1);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler$Kernel32Ex$Companion;", "", "WinExternalConsoleProcessHandler$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rider/run/WinExternalConsoleProcessHandler$Kernel32Ex;", "intellij.rider"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            static {
                $$INSTANCE = new Companion();
                Library library = Native.load((String)"kernel32", Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
                INSTANCE = (Kernel32Ex)library;
            }
        }
    }
}

