/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.roslyn.visualizer.tree.listeners;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.RdNodeAndFilePathsFrontend;
import com.jetbrains.rider.model.RdRoslynSyntaxTreeEntryFrontend;
import com.jetbrains.rider.model.RoslynFrontendModel;
import com.jetbrains.rider.roslyn.RoslynHost;
import com.jetbrains.rider.roslyn.visualizer.tree.RoslynSyntaxTree;
import com.jetbrains.rider.roslyn.visualizer.tree.RoslynSyntaxTreeEntry;
import com.jetbrains.rider.roslyn.visualizer.tree.actions.RoslynToggleToCaretAction;
import com.jetbrains.rider.roslyn.visualizer.tree.utils.UtilsKt;
import com.jetbrains.rider.roslyn.visualizer.window.RoslynVisualizerPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J0\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/roslyn/visualizer/tree/listeners/RoslynTreeClickListener;", "Ljava/awt/event/MouseAdapter;", "tree", "Ljavax/swing/JTree;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "RoslynTreeClickListener", "(Ljavax/swing/JTree;Lcom/intellij/openapi/wm/ToolWindow;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "x", "node", "Lcom/jetbrains/rider/roslyn/visualizer/tree/RoslynSyntaxTreeEntry;", "G", "x", "editor", "Lcom/intellij/openapi/editor/Editor;", "startLine", "", "startColumn", "endLine", "endColumn", "intellij.rider"})
public final class RoslynTreeClickListener
extends MouseAdapter {
    @NotNull
    private final JTree tree;
    @NotNull
    private final ToolWindow toolWindow;

    public RoslynTreeClickListener(@NotNull JTree tree2, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        this.tree = tree2;
        this.toolWindow = toolWindow;
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent e) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = this.toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RoslynFrontendModel roslynFrontendModel = RoslynHost.Companion.getInstance(project).getModel();
        RdRoslynSyntaxTreeEntryFrontend rdRoslynSyntaxTreeEntryFrontend = (RdRoslynSyntaxTreeEntryFrontend)roslynFrontendModel.getRoslynSyntaxTree().getValueOrNull();
        Boolean bl2 = rdRoslynSyntaxTreeEntryFrontend != null && (rdRoslynSyntaxTreeEntryFrontend = rdRoslynSyntaxTreeEntryFrontend.isActive()) != null ? (Boolean)rdRoslynSyntaxTreeEntryFrontend.getValueOrNull() : (bl = null);
        if (!Intrinsics.areEqual((Object)bl, (Object)true)) {
            return;
        }
        int n = e.getClickCount();
        TreePath treePath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (treePath == null) {
            return;
        }
        Object object = treePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        if (defaultMutableTreeNode2.getUserObject() == null) {
            return;
        }
        switch (n) {
            case 1: {
                Object object2 = defaultMutableTreeNode2.getUserObject();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.rider.roslyn.visualizer.tree.RoslynSyntaxTreeEntry");
                this.x((RoslynSyntaxTreeEntry)object2);
                break;
            }
            case 2: {
                Object object3 = defaultMutableTreeNode2.getUserObject();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type com.jetbrains.rider.roslyn.visualizer.tree.RoslynSyntaxTreeEntry");
                this.G((RoslynSyntaxTreeEntry)object3);
            }
        }
    }

    private final void x(RoslynSyntaxTreeEntry roslynSyntaxTreeEntry) {
        block2: {
            RoslynVisualizerPanel roslynVisualizerPanel;
            Project project = this.toolWindow.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            RoslynFrontendModel roslynFrontendModel = RoslynHost.Companion.getInstance(project).getModel();
            Editor editor2 = FileEditorManager.getInstance((Project)this.toolWindow.getProject()).getSelectedTextEditor();
            if (editor2 == null || (editor2 = editor2.getVirtualFile()) == null) {
                return;
            }
            Editor editor3 = editor2;
            RdRoslynSyntaxTreeEntryFrontend rdRoslynSyntaxTreeEntryFrontend = (RdRoslynSyntaxTreeEntryFrontend)roslynFrontendModel.getRoslynSyntaxTree().getValueOrNull();
            if (!(rdRoslynSyntaxTreeEntryFrontend != null && (rdRoslynSyntaxTreeEntryFrontend = rdRoslynSyntaxTreeEntryFrontend.isActive()) != null ? Intrinsics.areEqual((Object)rdRoslynSyntaxTreeEntryFrontend.getValueOrNull(), (Object)true) : false)) break block2;
            IAsyncSignal iAsyncSignal = ((RdRoslynSyntaxTreeEntryFrontend)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)roslynFrontendModel.getRoslynSyntaxTree()))).getGetSyntaxNodeData();
            List<Integer> list2 = roslynSyntaxTreeEntry.getPathToNode();
            String string = editor3.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            iAsyncSignal.fire((Object)new RdNodeAndFilePathsFrontend(list2, string));
            Project project2 = this.toolWindow.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            RoslynVisualizerPanel roslynVisualizerPanel2 = roslynVisualizerPanel = UtilsKt.getRoslynPanel(project2);
            if (roslynVisualizerPanel2 != null) {
                roslynVisualizerPanel2.showTable();
            }
        }
    }

    private final void G(RoslynSyntaxTreeEntry roslynSyntaxTreeEntry) {
        Project project = this.toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Editor editor2 = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        AnAction anAction = ActionManager.getInstance().getAction("RoslynVisualizerToggleToCaret");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.jetbrains.rider.roslyn.visualizer.tree.actions.RoslynToggleToCaretAction");
        RoslynToggleToCaretAction roslynToggleToCaretAction = (RoslynToggleToCaretAction)anAction;
        roslynToggleToCaretAction.disable();
        this.x(editor3, roslynSyntaxTreeEntry.getSpan().getStartLine(), roslynSyntaxTreeEntry.getSpan().getStartColumn(), roslynSyntaxTreeEntry.getSpan().getEndLine(), roslynSyntaxTreeEntry.getSpan().getEndColumn());
        roslynToggleToCaretAction.enable();
    }

    private final void x(Editor editor2, int n, int n2, int n3, int n4) {
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        SelectionModel selectionModel = editor2.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        ScrollingModel scrollingModel = editor2.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModel, (String)"getScrollingModel(...)");
        ScrollingModel scrollingModel2 = scrollingModel;
        JTree jTree = this.tree;
        Intrinsics.checkNotNull((Object)jTree, (String)"null cannot be cast to non-null type com.jetbrains.rider.roslyn.visualizer.tree.RoslynSyntaxTree");
        if (((RoslynSyntaxTree)((Object)jTree)).getVersion() != document2.getLineCount()) {
            return;
        }
        int n5 = document2.getLineStartOffset(n) + n2;
        int n6 = document2.getLineStartOffset(n3) + n4;
        selectionModel2.setSelection(n5, n6);
        caretModel2.moveToOffset(n5);
        scrollingModel2.scrollToCaret(ScrollType.CENTER);
    }
}

