/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.solutionExplorer.rootProviders;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rd.ide.model.RdExistingSolution;
import com.jetbrains.rd.ide.model.RdSolutionDescription;
import com.jetbrains.rd.ide.model.RdVirtualSolution;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.views.impl.SolutionViewLoadingNode;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerRootProvider;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerViewSettings;
import com.jetbrains.rider.projectView.views.solutionExplorer.nodes.SolutionExplorerModelNode;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/projectView/views/solutionExplorer/rootProviders/SolutionRootProvider;", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerRootProvider;", "project", "Lcom/intellij/openapi/project/Project;", "SolutionRootProvider", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRoots", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "settings", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewSettings;", "x", "Lcom/jetbrains/rider/projectView/views/impl/SolutionViewLoadingNode;", "text", "", "intellij.rider"})
public final class SolutionRootProvider
implements SolutionExplorerRootProvider {
    @NotNull
    private final Project project;

    public SolutionRootProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public List<AbstractTreeNode<?>> getRoots(@NotNull SolutionExplorerViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        RdSolutionDescription rdSolutionDescription = SolutionHostExtensionsKt.getSolutionDescription((Project)this.project);
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getSolutionEntity((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project));
        if (rdSolutionDescription instanceof RdExistingSolution) {
            if (projectModelEntity == null) {
                return this.x(RiderProjectViewBundle.Companion.message("SolutionRootProvider.loading.solution", new Object[0]));
            }
            SolutionExplorerModelNode solutionExplorerModelNode = new SolutionExplorerModelNode(this.project, ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)projectModelEntity), settings, false, 8, null);
            return CollectionsKt.listOf((Object)solutionExplorerModelNode);
        }
        if (rdSolutionDescription instanceof RdVirtualSolution && CollectionsKt.any((Iterable)((RdVirtualSolution)rdSolutionDescription).getProjectFilePaths())) {
            List list2;
            Object object = projectModelEntity;
            List list3 = object != null && (object = object.getChildrenEntities()) != null ? CollectionsKt.toList((Iterable)((Iterable)object)) : (list2 = null);
            if (list2 == null || list2.isEmpty()) {
                return this.x(RiderProjectViewBundle.Companion.message("SolutionRootProvider.loading.projects", new Object[0]));
            }
            List list4 = new ArrayList();
            for (ProjectModelEntity projectModelEntity2 : list2) {
                SolutionExplorerModelNode solutionExplorerModelNode = new SolutionExplorerModelNode(this.project, ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)projectModelEntity2), settings, false, 8, null);
                list4.add(solutionExplorerModelNode);
            }
            return list4;
        }
        return CollectionsKt.emptyList();
    }

    private final List<SolutionViewLoadingNode> x(@Nls String string) {
        SolutionViewLoadingNode solutionViewLoadingNode = new SolutionViewLoadingNode(this.project, string, AllIcons.Actions.Refresh);
        return CollectionsKt.listOf((Object)((Object)solutionViewLoadingNode));
    }
}

