/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.solutionExplorer.nodes;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.projectView.ProjectModelIconsKt;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.views.NestingNode;
import com.jetbrains.rider.projectView.views.NestingNodeKt;
import com.jetbrains.rider.projectView.views.SolutionViewNode;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerCustomization;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerViewSettings;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0012\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\fH\u0016J\b\u0010\u001d\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0012\u0010\"\u001a\f0#\u00a2\u0006\u0002\b$\u00a2\u0006\u0002\b%H\u0016J\u0012\u0010&\u001a\f0#\u00a2\u0006\u0002\b$\u00a2\u0006\u0002\b%H\u0016J\u0012\u0010'\u001a\f0#\u00a2\u0006\u0002\b$\u00a2\u0006\u0002\b%H\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0014R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0014\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/projectView/views/solutionExplorer/nodes/SolutionExplorerFileNode;", "Lcom/jetbrains/rider/projectView/views/SolutionViewNode;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "nestedNodes", "", "Lcom/jetbrains/rider/projectView/views/NestingNode;", "settings", "Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewSettings;", "isRoot", "", "isAttachedFolder", "SolutionExplorerFileNode", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewSettings;ZZ)V", "getNestedNodes", "()Ljava/util/List;", "getSettings", "()Lcom/jetbrains/rider/projectView/views/solutionExplorer/SolutionExplorerViewSettings;", "()Z", "calculateChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "canNavigateToSource", "getVirtualFile", "contains", "file", "getBackgroundColor", "Ljava/awt/Color;", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getTestPresentation", "toString", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSolutionExplorerFileNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionExplorerFileNode.kt\ncom/jetbrains/rider/projectView/views/solutionExplorer/nodes/SolutionExplorerFileNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,89:1\n774#2:90\n865#2,2:91\n774#2:93\n865#2,2:94\n1761#2,3:100\n13805#3,2:96\n13805#3,2:98\n*S KotlinDebug\n*F\n+ 1 SolutionExplorerFileNode.kt\ncom/jetbrains/rider/projectView/views/solutionExplorer/nodes/SolutionExplorerFileNode\n*L\n32#1:90\n32#1:91,2\n33#1:93\n33#1:94,2\n81#1:100,3\n50#1:96,2\n67#1:98,2\n*E\n"})
public final class SolutionExplorerFileNode
extends SolutionViewNode<VirtualFile> {
    @NotNull
    private final List<NestingNode<VirtualFile>> nestedNodes;
    @NotNull
    private final SolutionExplorerViewSettings settings;
    private final boolean isRoot;
    private final boolean isAttachedFolder;

    public SolutionExplorerFileNode(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull List<NestingNode<VirtualFile>> nestedNodes, @NotNull SolutionExplorerViewSettings settings, boolean isRoot, boolean isAttachedFolder) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(nestedNodes, (String)"nestedNodes");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(project, virtualFile);
        this.nestedNodes = nestedNodes;
        this.settings = settings;
        this.isRoot = isRoot;
        this.isAttachedFolder = isAttachedFolder;
    }

    @NotNull
    public final List<NestingNode<VirtualFile>> getNestedNodes() {
        return this.nestedNodes;
    }

    @NotNull
    public final SolutionExplorerViewSettings getSettings() {
        return this.settings;
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public final boolean isAttachedFolder() {
        return this.isAttachedFolder;
    }

    @Override
    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        Object object;
        Object object2;
        SolutionExplorerCustomization[] solutionExplorerCustomizationArray;
        List list2 = new ArrayList();
        if (!this.getVirtualFile().isValid()) {
            return list2;
        }
        if (this.getVirtualFile().isDirectory()) {
            Object object3;
            Object object422;
            solutionExplorerCustomizationArray = SolutionViewUtilsKt.getChildrenForSolutionView(this.getVirtualFile());
            Iterable iterable = (Iterable)solutionExplorerCustomizationArray;
            boolean bl = false;
            Iterable iterable2 = iterable;
            object2 = new ArrayList();
            boolean bl2 = false;
            for (Object object422 : iterable2) {
                object3 = (VirtualFile)object422;
                boolean bl3 = false;
                if (!object3.isDirectory()) continue;
                object2.add(object422);
            }
            List object5 = (List)object2;
            List<NestingNode<VirtualFile>> list3 = (Iterable)solutionExplorerCustomizationArray;
            boolean bl4 = false;
            object2 = list3;
            Collection collection = new ArrayList();
            boolean bl5 = false;
            object422 = object2.iterator();
            while (object422.hasNext()) {
                Object object6 = object3 = object422.next();
                boolean bl3 = false;
                if (!(!object6.isDirectory())) continue;
                collection.add(object3);
            }
            iterable = (List)collection;
            for (VirtualFile virtualFile : object5) {
                Project project = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                list2.add(new SolutionExplorerFileNode(project, virtualFile, CollectionsKt.emptyList(), this.settings, false, this.isAttachedFolder));
            }
            list3 = NestingNodeKt.mapNestedVirtualFiles((List<? extends VirtualFile>)iterable);
            object = list3.iterator();
            while (object.hasNext()) {
                object2 = (NestingNode)object.next();
                Project project = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                list2.add(new SolutionExplorerFileNode(project, (VirtualFile)((NestingNode)object2).getValue(), ((NestingNode)object2).getChildren(), this.settings, false, this.isAttachedFolder));
            }
        } else {
            for (NestingNode bl : this.nestedNodes) {
                Project project = this.myProject;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                list2.add(new SolutionExplorerFileNode(project, (VirtualFile)bl.getValue(), bl.getChildren(), this.settings, false, this.isAttachedFolder));
            }
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        solutionExplorerCustomizationArray = SolutionExplorerCustomization.Companion.getExtensions(project);
        boolean bl = false;
        int n = solutionExplorerCustomizationArray.length;
        for (int j = 0; j < n; ++j) {
            object2 = object = solutionExplorerCustomizationArray[j];
            boolean bl7 = false;
            ((SolutionExplorerCustomization)object2).modifyChildren(this.getVirtualFile(), this.settings, list2);
        }
        return list2;
    }

    @Override
    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        if (!this.getVirtualFile().isValid()) {
            return;
        }
        presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        VirtualFile virtualFile = this.getVirtualFile();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        presentation.setIcon(ProjectModelIconsKt.calculateFileSystemIcon((VirtualFile)virtualFile, (Project)project));
        if (this.isRoot && this.isAttachedFolder) {
            SolutionViewUtilsKt.addAdditionalText(presentation, RiderProjectViewBundle.Companion.message("SolutionExplorerFileNode.label.attached", new Object[0]));
            presentation.setIcon(AllIcons.Actions.MenuOpen);
        }
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        SolutionViewUtilsKt.addAdditionalMark$default(presentation, project2, this.getVirtualFile(), false, 4, null);
        Project project3 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
        SolutionExplorerCustomization[] solutionExplorerCustomizationArray = SolutionExplorerCustomization.Companion.getExtensions(project3);
        boolean bl = false;
        int n = solutionExplorerCustomizationArray.length;
        for (int j = 0; j < n; ++j) {
            SolutionExplorerCustomization solutionExplorerCustomization;
            SolutionExplorerCustomization solutionExplorerCustomization2 = solutionExplorerCustomization = solutionExplorerCustomizationArray[j];
            boolean bl2 = false;
            solutionExplorerCustomization2.updateNode(presentation, this.getVirtualFile());
        }
    }

    public boolean canNavigateToSource() {
        return !this.getVirtualFile().isDirectory();
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        Object object = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (VirtualFile)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        NestingNode nestingNode;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (VfsUtil.isAncestor((VirtualFile)this.getVirtualFile(), (VirtualFile)file2, (boolean)false)) return true;
        Iterable iterable = this.nestedNodes;
        boolean bl = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator iterator2 = iterable.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object t = iterator2.next();
            nestingNode = (NestingNode)t;
            boolean bl2 = false;
        } while (!Intrinsics.areEqual(nestingNode.getValue(), (Object)file2));
        return true;
    }

    @Override
    @Nullable
    public Color getBackgroundColor() {
        VirtualFile virtualFile = this.getVirtualFile();
        Project project = this.getProject();
        Intrinsics.checkNotNull((Object)project);
        return ProjectModelNodeExtensionKt.getScopeColor((VirtualFile)virtualFile, (Project)project, (Boolean)false, (!this.isAttachedFolder ? 1 : 0) != 0);
    }

    @NotNull
    public String getName() {
        String string = this.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String getTestPresentation() {
        String string = this.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }
}

