/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.search;

import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.editorHeaderActions.PrevNextOccurrenceAction;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.projectView.views.SolutionViewPaneBase;
import com.jetbrains.rider.projectView.views.SolutionViewStatistic;
import com.jetbrains.rider.projectView.views.impl.SolutionViewSpeedSearch;
import com.jetbrains.rider.projectView.views.impl.SolutionViewTreeModel;
import com.jetbrains.rider.projectView.views.search.SolutionSearchFilter;
import com.jetbrains.rider.projectView.views.search.SolutionSearchView;
import com.jetbrains.rider.projectView.workspace.impl.WorkspaceEntityExpandSupport;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 72\u00020\u0001:\u0006789:;<B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020 H\u0002J\u0006\u0010%\u001a\u00020 J\u0006\u0010&\u001a\u00020 J\u0006\u0010'\u001a\u00020#J\u0006\u0010(\u001a\u00020#J\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020 H\u0002J\u0006\u0010-\u001a\u00020#J\u0006\u0010.\u001a\u00020#J\u0006\u0010/\u001a\u00020 J\u0006\u00100\u001a\u00020#J$\u00101\u001a\u00020 2\u0006\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u0002042\n\u00105\u001a\u0006\u0012\u0002\b\u000306H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\u00a8\u0006="}, d2={"Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "pane", "Lcom/jetbrains/rider/projectView/views/SolutionViewPaneBase;", "project", "Lcom/intellij/openapi/project/Project;", "filters", "", "Lcom/jetbrains/rider/projectView/views/search/SolutionSearchFilter;", "SolutionSearchView", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/projectView/views/SolutionViewPaneBase;Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "searchComponent", "Lcom/intellij/find/SearchReplaceComponent;", "getSearchComponent", "()Lcom/intellij/find/SearchReplaceComponent;", "resultsLockObject", "Ljava/lang/Object;", "index", "", "speedSearch", "Lcom/jetbrains/rider/projectView/views/impl/SolutionViewSpeedSearch;", "searchAlarm", "Lcom/intellij/util/Alarm;", "sessionLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "session", "Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView$FindSession;", "isVisible", "", "()Z", "x", "", "x", "canNext", "canPrevious", "next", "previous", "x", "path", "Ljavax/swing/tree/TreePath;", "G", "show", "close", "isFocused", "updateSearchSession", "x", "findModel", "matcher", "Lcom/intellij/ui/SpeedSearchComparator;", "node", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "Companion", "FindSession", "Listener", "MyStatusTextAction", "MyPrevOccurrenceAction", "MyNextOccurrenceAction", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSolutionSearchView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionSearchView.kt\ncom/jetbrains/rider/projectView/views/search/SolutionSearchView\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,502:1\n37#2,2:503\n13#3:505\n13#3:511\n1#4:506\n1761#5,3:507\n13#6:510\n*S KotlinDebug\n*F\n+ 1 SolutionSearchView.kt\ncom/jetbrains/rider/projectView/views/search/SolutionSearchView\n*L\n85#1:503,2\n182#1:505\n307#1:511\n337#1:507,3\n307#1:510\n*E\n"})
public final class SolutionSearchView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final SolutionViewPaneBase pane;
    @NotNull
    private final Project project;
    @NotNull
    private final List<SolutionSearchFilter> filters;
    @NotNull
    private final SearchReplaceComponent searchComponent;
    @NotNull
    private final Object resultsLockObject;
    private int index;
    @NotNull
    private final SolutionViewSpeedSearch speedSearch;
    @NotNull
    private final Alarm searchAlarm;
    @NotNull
    private final SequentialLifetimes sessionLifetimes;
    @NotNull
    private FindSession session;
    private static final int DELAY = 500;

    public SolutionSearchView(@NotNull Lifetime lifetime, @NotNull SolutionViewPaneBase pane2, @NotNull Project project, @NotNull List<? extends SolutionSearchFilter> filters) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)pane2), (String)"pane");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        this.lifetime = lifetime;
        this.pane = pane2;
        this.project = project;
        this.filters = filters;
        this.resultsLockObject = new Object();
        this.index = -1;
        this.searchAlarm = new Alarm((Disposable)this.pane);
        this.sessionLifetimes = new SequentialLifetimes(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.pane.getProject())));
        this.session = new FindSession((Lifetime)this.sessionLifetimes.next(), "");
        MyPrevOccurrenceAction myPrevOccurrenceAction = new MyPrevOccurrenceAction(this, false, 1, null);
        MyNextOccurrenceAction myNextOccurrenceAction = new MyNextOccurrenceAction(this, false, 1, null);
        Object[] objectArray = new AnAction[]{new MyStatusTextAction(), myPrevOccurrenceAction, myNextOccurrenceAction};
        List list2 = CollectionsKt.mutableListOf((Object[])objectArray);
        list2.addAll((Collection)this.filters);
        boolean bl = ExperimentalUI.Companion.isNewUI();
        Collection collection = list2;
        boolean bl2 = false;
        Collection collection2 = collection;
        Object object = collection2.toArray(new AnAction[0]);
        SearchReplaceComponent.Builder builder = SearchReplaceComponent.buildFor((Project)this.project, (JComponent)this.pane.getTree(), null).addPrimarySearchActions(Arrays.copyOf(object, ((AnAction[])object).length)).withMultilineEnabled(false).withMaximizeLeftPanelOnResize().withAddSearchResultsToGlobalSearch(false).withUseSearchField(!bl, !bl);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"withUseSearchField(...)");
        SearchReplaceComponent.Builder builder2 = builder;
        if (bl) {
            builder2.withoutSeparator();
        }
        SearchReplaceComponent searchReplaceComponent = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)searchReplaceComponent, (String)"build(...)");
        this.searchComponent = searchReplaceComponent;
        this.searchComponent.setVisible(false);
        this.searchComponent.addListener((SearchReplaceComponent.Listener)new Listener());
        JTextComponent jTextComponent = this.searchComponent.getSearchTextComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jTextComponent, (String)"getSearchTextComponent(...)");
        final JTextComponent jTextComponent2 = jTextComponent;
        jTextComponent2.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                KeyEvent keyEvent = e;
                boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 40 : false;
                if (bl) {
                    SolutionViewStatistic.findPanelNext.log(((Object)((Object)pane)).getClass(), (Object)SolutionViewStatistic.FindPanelActionSource.Keyboard);
                    this.next();
                    e.consume();
                }
                KeyEvent keyEvent2 = e;
                boolean bl2 = keyEvent2 != null ? keyEvent2.getKeyCode() == 38 : false;
                if (bl2) {
                    SolutionViewStatistic.findPanelPrev.log(((Object)((Object)pane)).getClass(), (Object)SolutionViewStatistic.FindPanelActionSource.Keyboard);
                    this.previous();
                    e.consume();
                }
                KeyEvent keyEvent3 = e;
                boolean bl3 = keyEvent3 != null ? keyEvent3.getKeyCode() == 27 : false;
                if (bl3) {
                    SolutionViewStatistic.findPanelClosed.log(((Object)((Object)pane)).getClass(), (Object)SolutionViewStatistic.FindPanelActionSource.Keyboard);
                    this.close();
                }
                KeyEvent keyEvent4 = e;
                boolean bl4 = keyEvent4 != null ? keyEvent4.getKeyCode() == 10 : false;
                if (bl4) {
                    AbstractTreeNode abstractTreeNode = (AbstractTreeNode)CollectionsKt.singleOrNull(pane.getSelectedNodes());
                    if (abstractTreeNode == null) {
                        return;
                    }
                    AbstractTreeNode abstractTreeNode2 = abstractTreeNode;
                    if (abstractTreeNode2.canNavigateToSource()) {
                        SolutionViewStatistic.findPanelOpenEditor.log(((Object)((Object)pane)).getClass());
                        abstractTreeNode2.navigate(false);
                    }
                    IdeFocusManager.getInstance((Project)project).requestFocus((Component)pane.getTree(), false);
                }
            }
        });
        jTextComponent2.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ClientProperty.put((JComponent)pane.getTree(), (Key)Tree.AUTO_SCROLL_FROM_SOURCE_BLOCKED, (Object)true);
            }

            @Override
            public void focusLost(FocusEvent e) {
                ClientProperty.put((JComponent)pane.getTree(), (Key)Tree.AUTO_SCROLL_FROM_SOURCE_BLOCKED, (Object)false);
            }
        });
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.close();
            }
        }.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"EditorEscape"), (JComponent)jTextComponent2);
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CharSequence charSequence = jTextComponent2.getSelectedText();
                if (charSequence == null || charSequence.length() == 0) {
                    int n = jTextComponent2.getCaretPosition();
                    String string = jTextComponent2.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    String string2 = string;
                    int n2 = n + 1;
                    jTextComponent2.setText(((Object)StringsKt.removeRange((CharSequence)string2, (int)n, (int)n2)).toString());
                    jTextComponent2.setCaretPosition(n);
                } else {
                    jTextComponent2.replaceSelection("");
                }
            }
        }.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"EditorDelete"), (JComponent)jTextComponent2);
        object = this.pane.getTree();
        this.speedSearch = new SolutionViewSpeedSearch((JTree)object){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public boolean isPopupActive() {
                if (super.isPopupActive()) {
                    return true;
                }
                return this.isVisible();
            }

            public boolean isObjectFilteredOut(Object o) {
                if (o instanceof AbstractTreeNode) {
                    boolean bl;
                    block5: {
                        Iterable iterable = filters;
                        boolean bl2 = false;
                        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object t : iterable) {
                                SolutionSearchFilter solutionSearchFilter = (SolutionSearchFilter)((Object)t);
                                boolean bl3 = false;
                                if (!solutionSearchFilter.filterOut((AbstractTreeNode)o)) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (bl && this.isVisible()) {
                        return true;
                    }
                }
                return false;
            }
        };
        if (bl) {
            if (jTextComponent2 instanceof ComponentWithEmptyText) {
                ((ComponentWithEmptyText)jTextComponent2).getEmptyText().setText(RiderProjectViewBundle.Companion.message("SolutionSearchView.empty.text", new Object[0]));
                jTextComponent2.putClientProperty("StatusVisibleFunction", SolutionSearchView::x);
            } else {
                boolean bl3 = false;
                Logger logger = Logger.getInstance(SolutionSearchView.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("SolutionSearchView text field does not support empty text");
            }
        }
        myPrevOccurrenceAction.registerCustomShortcutSet(myPrevOccurrenceAction.getShortcutSet(), this.pane.getTree());
        myNextOccurrenceAction.registerCustomShortcutSet(myNextOccurrenceAction.getShortcutSet(), this.pane.getTree());
        this.x();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final SearchReplaceComponent getSearchComponent() {
        return this.searchComponent;
    }

    public final boolean isVisible() {
        return this.searchComponent.isVisible();
    }

    private final void x() {
        this.searchComponent.updateActions();
    }

    private final boolean x() {
        return this.searchComponent == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canNext() {
        boolean bl;
        Object object = this.resultsLockObject;
        synchronized (object) {
            bl = false;
            bl = CollectionsKt.any((Iterable)this.session.getResults()) && this.index < ((Collection)this.session.getResults()).size() - 1;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean canPrevious() {
        boolean bl;
        Object object = this.resultsLockObject;
        synchronized (object) {
            bl = false;
            bl = CollectionsKt.any((Iterable)this.session.getResults()) && this.index > 0;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void next() {
        Object object = this.resultsLockObject;
        synchronized (object) {
            boolean bl = false;
            ApplicationKt.getApplication().assertIsDispatchThread();
            if (this.index < ((Collection)this.session.getResults()).size() - 1) {
                int n = this.index;
                this.index = n + 1;
                TreePath treePath = this.session.getResults().get(this.index);
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"get(...)");
                this.x(treePath);
            }
            this.x();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void previous() {
        Object object = this.resultsLockObject;
        synchronized (object) {
            boolean bl = false;
            ApplicationKt.getApplication().assertIsDispatchThread();
            if (this.index > 0) {
                int n = this.index;
                this.index = n + -1;
                TreePath treePath = this.session.getResults().get(this.index);
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"get(...)");
                this.x(treePath);
            }
            this.x();
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void x(TreePath treePath) {
        TreeVisitor.ByTreePath byTreePath = new TreeVisitor.ByTreePath(treePath, SolutionSearchView::x);
        this.pane.select((TreeVisitor)byTreePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean G() {
        Object object = this.resultsLockObject;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.session.getResults().size() > 0;
            return bl2;
        }
    }

    public final void show() {
        this.searchComponent.setVisible(true);
        this.searchComponent.requestFocusInTheSearchFieldAndSelectContent(this.project);
        this.updateSearchSession();
    }

    public final void close() {
        IdeFocusManager.getInstance((Project)this.project).requestFocus((Component)this.pane.getTree(), false);
        this.searchComponent.setVisible(false);
        this.sessionLifetimes.terminateCurrent();
        this.speedSearch.getComparator().matchingFragments("", "");
        this.pane.updatePresentationsFromRoot();
    }

    public final boolean isFocused() {
        return this.searchComponent.hasFocus() || this.searchComponent.getSearchTextComponent().hasFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateSearchSession() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        String string = this.searchComponent.getSearchTextComponent().getText();
        Lifetime lifetime = this.sessionLifetimes.next().getLifetime();
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        FindSession findSession = new FindSession(lifetime, string2);
        Object object = this.resultsLockObject;
        synchronized (object) {
            boolean bl = false;
            this.session = findSession;
            this.index = -1;
            Unit unit = Unit.INSTANCE;
        }
        this.x();
        this.speedSearch.getComparator().matchingFragments("", "");
        this.pane.updatePresentationsFromRoot();
        this.searchAlarm.cancelAllRequests();
        Intrinsics.checkNotNull((Object)string);
        if (((CharSequence)string).length() == 0) {
            return;
        }
        findSession.setSearchIsInProgress(true);
        LifetimeDefinition lifetimeDefinition = lifetime.createNested();
        object = new ApplicationListener(this){
            final /* synthetic */ SolutionSearchView this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeWriteActionStart(Object action2) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                SolutionSearchView.access$getSessionLifetimes$p(this.this$0).terminateCurrent();
                EdtExecutorService.getScheduledExecutorInstance().schedule(() -> updateSearchSession.listener.1.x(this.this$0), 1L, TimeUnit.SECONDS);
            }

            private static final void x(SolutionSearchView solutionSearchView) {
                solutionSearchView.updateSearchSession();
            }
        };
        ApplicationKt.getApplication().addApplicationListener((ApplicationListener)object, LifetimeDisposableExKt.createNestedDisposable((Lifetime)((Lifetime)lifetimeDefinition), (String)"SolutionSearchView:Session:SearchLifetime"));
        this.searchAlarm.addRequest(() -> SolutionSearchView.x(this, findSession, lifetimeDefinition), 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean x(FindSession findSession, SpeedSearchComparator speedSearchComparator, AbstractTreeNode<?> abstractTreeNode) {
        Iterable iterable;
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        Object object4;
        block13: {
            boolean bl3;
            boolean bl4 = bl3 = !ApplicationKt.getApplication().isDispatchThread();
            if (_Assertions.ENABLED && !bl3) {
                boolean bl5 = false;
                String string = "Search should be executed on a background thread";
                throw new AssertionError((Object)string);
            }
            if (RLifetimeKt.isNotAlive((Lifetime)findSession.getLifetime())) {
                return false;
            }
            object4 = this.filters;
            boolean bl6 = false;
            if (object4 instanceof Collection && ((Collection)object4).isEmpty()) {
                bl2 = false;
            } else {
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    object = (SolutionSearchFilter)((Object)object2);
                    bl = false;
                    if (!object.filterOut(abstractTreeNode)) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            return true;
        }
        object4 = abstractTreeNode.getName();
        if (object4 != null && (iterable = speedSearchComparator.matchingFragments(findSession.getStringToFind(), (String)object4)) != null && CollectionsKt.any((Iterable)iterable)) {
            object3 = TreePathUtil.pathToCustomNode(abstractTreeNode, SolutionSearchView::G);
            object = this.resultsLockObject;
            synchronized (object) {
                bl = false;
                if (RLifetimeKt.isAlive((Lifetime)findSession.getLifetime())) {
                    findSession.getResults().add((TreePath)object3);
                    if (((Collection)findSession.getResults()).size() == 1) {
                        ApplicationKt.getApplication().invokeLater(() -> SolutionSearchView.x(findSession, this));
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        SolutionViewTreeModel solutionViewTreeModel = this.pane.getModel();
        Collection collection = abstractTreeNode.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChildren(...)");
        SmartList<AbstractTreeNode<?>> smartList = solutionViewTreeModel.sortChildren(collection);
        Iterator iterator2 = smartList.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
        object3 = iterator2;
        while (object3.hasNext()) {
            object2 = (AbstractTreeNode)object3.next();
            if (this.x(findSession, speedSearchComparator, (AbstractTreeNode<?>)object2)) continue;
            return false;
        }
        return true;
    }

    private static final boolean x(JTextComponent jTextComponent) {
        String string = jTextComponent.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((CharSequence)string).length() == 0;
    }

    private static final Object x(Object object) {
        return object;
    }

    private static final void x(SolutionSearchView solutionSearchView, FindSession findSession, LifetimeDefinition lifetimeDefinition) {
        solutionSearchView.pane.getModel().runOrInvokeLater((Function0<Unit>)((Function0)() -> SolutionSearchView.x(solutionSearchView, findSession, lifetimeDefinition)));
    }

    private static final Unit x(SolutionSearchView solutionSearchView, FindSession findSession, LifetimeDefinition lifetimeDefinition) {
        boolean bl;
        if (solutionSearchView.pane.searchInLazyLoadedNodes()) {
            WorkspaceEntityExpandSupport.Companion.getInstance(solutionSearchView.project).requestExpandAll();
        }
        try {
            SpeedSearchComparator speedSearchComparator = solutionSearchView.speedSearch.getComparator();
            Intrinsics.checkNotNullExpressionValue((Object)speedSearchComparator, (String)"getComparator(...)");
            bl = solutionSearchView.x(findSession, speedSearchComparator, solutionSearchView.pane.getModel().getRoot());
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (Exception exception) {
            boolean bl2 = false;
            boolean bl3 = false;
            Logger logger = Logger.getInstance(SolutionSearchView.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)exception);
            bl = true;
        }
        boolean bl4 = bl;
        if (bl4) {
            ApplicationKt.getApplication().invokeLater(() -> SolutionSearchView.x(findSession, solutionSearchView, lifetimeDefinition));
        }
        return Unit.INSTANCE;
    }

    private static final void x(FindSession findSession, SolutionSearchView solutionSearchView, LifetimeDefinition lifetimeDefinition) {
        if (RLifetimeKt.isAlive((Lifetime)findSession.getLifetime())) {
            SolutionViewStatistic.findPanelPerformed.log(((Object)((Object)solutionSearchView.pane)).getClass());
            findSession.setSearchIsInProgress(false);
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
            solutionSearchView.pane.updatePresentationsFromRoot();
            solutionSearchView.x();
            solutionSearchView.searchComponent.addTextToRecent(solutionSearchView.searchComponent.getSearchTextComponent());
        }
    }

    private static final Object G(Object object) {
        AbstractTreeNode abstractTreeNode = object instanceof AbstractTreeNode ? (AbstractTreeNode)object : null;
        return abstractTreeNode != null ? abstractTreeNode.getParent() : null;
    }

    private static final void x(FindSession findSession, SolutionSearchView solutionSearchView) {
        if (RLifetimeKt.isAlive((Lifetime)findSession.getLifetime())) {
            solutionSearchView.next();
        }
    }

    public static final /* synthetic */ SequentialLifetimes access$getSessionLifetimes$p(SolutionSearchView $this) {
        return $this.sessionLifetimes;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView$Companion;", "", "SolutionSearchView$Companion", "()V", "DELAY", "", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView$FindSession;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "stringToFind", "", "SolutionSearchView$FindSession", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getStringToFind", "()Ljava/lang/String;", "results", "Ljava/util/ArrayList;", "Ljavax/swing/tree/TreePath;", "Lkotlin/collections/ArrayList;", "getResults", "()Ljava/util/ArrayList;", "searchIsInProgress", "", "getSearchIsInProgress", "()Z", "setSearchIsInProgress", "(Z)V", "intellij.rider"})
    public static final class FindSession {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final String stringToFind;
        @NotNull
        private final ArrayList<TreePath> results;
        private boolean searchIsInProgress;

        public FindSession(@NotNull Lifetime lifetime, @NotNull String stringToFind) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)stringToFind, (String)"stringToFind");
            this.lifetime = lifetime;
            this.stringToFind = stringToFind;
            this.results = new ArrayList();
        }

        @NotNull
        public final Lifetime getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final String getStringToFind() {
            return this.stringToFind;
        }

        @NotNull
        public final ArrayList<TreePath> getResults() {
            return this.results;
        }

        public final boolean getSearchIsInProgress() {
            return this.searchIsInProgress;
        }

        public final void setSearchIsInProgress(boolean bl) {
            this.searchIsInProgress = bl;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView$Listener;", "Lcom/intellij/find/SearchReplaceComponent$Listener;", "SolutionSearchView$Listener", "(Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView;)V", "searchFieldDocumentChanged", "", "replaceFieldDocumentChanged", "multilineStateChanged", "intellij.rider"})
    public final class Listener
    implements SearchReplaceComponent.Listener {
        public void searchFieldDocumentChanged() {
            SolutionSearchView.this.updateSearchSession();
        }

        public void replaceFieldDocumentChanged() {
        }

        public void multilineStateChanged() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0014J\u0010\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView$MyNextOccurrenceAction;", "Lcom/intellij/find/editorHeaderActions/PrevNextOccurrenceAction;", "Lcom/intellij/openapi/actionSystem/RightAlignedToolbarAction;", "search", "", "SolutionSearchView$MyNextOccurrenceAction", "(Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView;Z)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getDefaultShortcuts", "", "Lcom/intellij/openapi/actionSystem/Shortcut;", "getSingleLineShortcuts", "intellij.rider"})
    public final class MyNextOccurrenceAction
    extends PrevNextOccurrenceAction
    implements RightAlignedToolbarAction {
        final /* synthetic */ SolutionSearchView this$0;

        @JvmOverloads
        public MyNextOccurrenceAction(SolutionSearchView this$0, boolean search) {
            this.this$0 = this$0;
            super("NextOccurence", search);
        }

        public /* synthetic */ MyNextOccurrenceAction(SolutionSearchView solutionSearchView, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(solutionSearchView, bl);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation presentation2 = presentation;
            presentation2.setEnabled(!this.this$0.x() && this.this$0.isVisible() && this.this$0.canNext());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.this$0.G()) {
                return;
            }
            SolutionViewStatistic.findPanelNext.log(((Object)((Object)this.this$0.pane)).getClass(), (Object)SolutionViewStatistic.INSTANCE.getActionSource(e));
            this.this$0.next();
        }

        @NotNull
        protected List<Shortcut> getDefaultShortcuts() {
            List list2 = Utils.shortcutsOf((String)"FindNext");
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"shortcutsOf(...)");
            return list2;
        }

        @NotNull
        protected List<Shortcut> getSingleLineShortcuts() {
            List list2;
            if (this.mySearch) {
                Shortcut[] shortcutArray = CommonShortcuts.ENTER.getShortcuts();
                List list3 = ContainerUtil.append((List)Utils.shortcutsOf((String)"EditorDown"), (Object[])Arrays.copyOf(shortcutArray, shortcutArray.length));
                Intrinsics.checkNotNull((Object)list3);
                list2 = list3;
            } else {
                List list4 = Utils.shortcutsOf((String)"EditorDown");
                Intrinsics.checkNotNull((Object)list4);
                list2 = list4;
            }
            return list2;
        }

        @JvmOverloads
        public MyNextOccurrenceAction(SolutionSearchView this$0) {
            this(this$0, false, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView$MyPrevOccurrenceAction;", "Lcom/intellij/find/editorHeaderActions/PrevNextOccurrenceAction;", "Lcom/intellij/openapi/actionSystem/RightAlignedToolbarAction;", "search", "", "SolutionSearchView$MyPrevOccurrenceAction", "(Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView;Z)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getDefaultShortcuts", "", "Lcom/intellij/openapi/actionSystem/Shortcut;", "getSingleLineShortcuts", "intellij.rider"})
    public final class MyPrevOccurrenceAction
    extends PrevNextOccurrenceAction
    implements RightAlignedToolbarAction {
        final /* synthetic */ SolutionSearchView this$0;

        @JvmOverloads
        public MyPrevOccurrenceAction(SolutionSearchView this$0, boolean search) {
            this.this$0 = this$0;
            super("PreviousOccurence", search);
        }

        public /* synthetic */ MyPrevOccurrenceAction(SolutionSearchView solutionSearchView, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(solutionSearchView, bl);
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation presentation2 = presentation;
            presentation2.setEnabled(!this.this$0.x() && this.this$0.isVisible() && this.this$0.canPrevious());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!this.this$0.G()) {
                return;
            }
            SolutionViewStatistic.findPanelPrev.log(((Object)((Object)this.this$0.pane)).getClass(), (Object)SolutionViewStatistic.INSTANCE.getActionSource(e));
            this.this$0.previous();
        }

        @NotNull
        protected List<Shortcut> getDefaultShortcuts() {
            List list2 = Utils.shortcutsOf((String)"FindPrevious");
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"shortcutsOf(...)");
            return list2;
        }

        @NotNull
        protected List<Shortcut> getSingleLineShortcuts() {
            List list2;
            if (this.mySearch) {
                Object[] objectArray = new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(10, 64), null)};
                List list3 = ContainerUtil.append((List)Utils.shortcutsOf((String)"EditorUp"), (Object[])objectArray);
                Intrinsics.checkNotNull((Object)list3);
                list2 = list3;
            } else {
                List list4 = Utils.shortcutsOf((String)"EditorUp");
                Intrinsics.checkNotNull((Object)list4);
                list2 = list4;
            }
            return list2;
        }

        @JvmOverloads
        public MyPrevOccurrenceAction(SolutionSearchView this$0) {
            this(this$0, false, 1, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView$MyStatusTextAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/actionSystem/RightAlignedToolbarAction;", "SolutionSearchView$MyStatusTextAction", "(Lcom/jetbrains/rider/projectView/views/search/SolutionSearchView;)V", "panel", "Ljavax/swing/JPanel;", "label", "Ljavax/swing/JLabel;", "progressIcon", "Lcom/intellij/util/ui/AsyncProcessIcon;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "intellij.rider"})
    public final class MyStatusTextAction
    extends DumbAwareAction
    implements CustomComponentAction,
    RightAlignedToolbarAction {
        @NotNull
        private final JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        @NotNull
        private final JLabel label = new JLabel("0");
        @NotNull
        private final AsyncProcessIcon progressIcon = new AsyncProcessIcon("Search in progress");

        public MyStatusTextAction() {
            this.label.setToolTipText(RiderProjectViewBundle.Companion.message("SolutionSearchView.search.results.description", new Object[0]));
            this.progressIcon.setToolTipText(this.label.getToolTipText());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (SolutionSearchView.this.x()) {
                return;
            }
            String string = null;
            boolean bl = false;
            Object object = SolutionSearchView.this.resultsLockObject;
            SolutionSearchView solutionSearchView = SolutionSearchView.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl2 = false;
                string = ((CharSequence)solutionSearchView.session.getStringToFind()).length() == 0 ? (ExperimentalUI.Companion.isNewUI() ? "" : "-/-") : (solutionSearchView.index >= 0 && solutionSearchView.session.getResults().size() > 0 ? solutionSearchView.index + 1 + "/" + solutionSearchView.session.getResults().size() : (ExperimentalUI.Companion.isNewUI() ? RiderProjectViewBundle.Companion.message("SolutionSearchView.no.results", new Object[0]) : "0"));
                bl = solutionSearchView.session.getSearchIsInProgress();
                Unit unit = Unit.INSTANCE;
            }
            this.label.setText(string);
            Comparable comparable = ComparatorUtil.max((Comparable)Integer.valueOf(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width), (Comparable)Integer.valueOf(new JLabel((String)string).getPreferredSize().width));
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"max(...)");
            this.label.setMinimumSize(new Dimension(((Number)((Object)comparable)).intValue(), this.progressIcon.getPreferredSize().height));
            this.label.setForeground(JBUI.CurrentTheme.Label.disabledForeground());
            this.label.setPreferredSize(this.label.getMinimumSize());
            this.progressIcon.setMinimumSize(this.label.getMinimumSize());
            this.progressIcon.setPreferredSize(this.label.getMinimumSize());
            this.progressIcon.setVisible(bl);
            this.label.setVisible(!bl);
            super.update(e);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            this.label.setMinimumSize(new Dimension(ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE.width, this.progressIcon.getPreferredSize().height));
            this.label.setPreferredSize(this.label.getMinimumSize());
            this.label.setHorizontalAlignment(4);
            this.label.setOpaque(false);
            this.panel.add(this.label);
            this.panel.add((Component)this.progressIcon);
            this.panel.setOpaque(false);
            this.progressIcon.setVisible(false);
            return this.panel;
        }
    }
}

