/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.fileSystemExplorer;

import com.intellij.ide.projectView.NodeSortKey;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.GroupByTypeComparator;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.containers.DistinctRootsCollection;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.ideaInterop.RiderScratchProjectViewPane;
import com.jetbrains.rider.projectView.utils.ComparisonExtensionsKt;
import com.jetbrains.rider.projectView.utils.ProjectViewUtils;
import com.jetbrains.rider.projectView.views.FileSystemNodeBase;
import com.jetbrains.rider.projectView.views.ProjectViewFSRootNodeService;
import com.jetbrains.rider.projectView.views.SolutionViewRootNodeBase;
import com.jetbrains.rider.projectView.views.fileSystemExplorer.FileSystemExplorerNode;
import com.jetbrains.rider.projectView.views.solutionExplorer.rootProviders.ScratchRootProvider;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.workspaceModel.WorkspaceUserModelUpdater;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007H\u0014J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0010j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b`\u0011H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerRootNode;", "Lcom/jetbrains/rider/projectView/views/SolutionViewRootNodeBase;", "project", "Lcom/intellij/openapi/project/Project;", "FileSystemExplorerRootNode", "(Lcom/intellij/openapi/project/Project;)V", "calculateChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "x", "Lcom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerNode;", "file", "Ljava/io/File;", "fallback", "Lcom/intellij/ide/projectView/impl/GroupByTypeComparator;", "createComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nFileSystemExplorerRootNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemExplorerRootNode.kt\ncom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerRootNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n774#2:88\n865#2,2:89\n1563#2:91\n1634#2,3:92\n774#2:95\n865#2,2:96\n*S KotlinDebug\n*F\n+ 1 FileSystemExplorerRootNode.kt\ncom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerRootNode\n*L\n45#1:88\n45#1:89,2\n46#1:91\n46#1:92,3\n52#1:95\n52#1:96,2\n*E\n"})
public final class FileSystemExplorerRootNode
extends SolutionViewRootNodeBase {
    @NotNull
    private final GroupByTypeComparator fallback;

    public FileSystemExplorerRootNode(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.fallback = new GroupByTypeComparator(project, "FileSystemExplorer");
    }

    @Override
    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        boolean bl;
        Object object;
        Object t;
        Object object2;
        File file2;
        if (ProjectViewUtils.INSTANCE.isRepositoryViewEnabled()) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            VirtualFile virtualFile = ProjectViewFSRootNodeService.Companion.getInstance(project).getRoot();
            file2 = virtualFile != null ? DocumentUtilKt.toIOFile((VirtualFile)virtualFile) : null;
        } else {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            file2 = SolutionHostExtensionsKt.getSolutionDirectory((Project)project);
        }
        File file3 = file2;
        Object object3 = new File[]{file3};
        Object object4 = object3;
        DistinctRootsCollection<File> distinctRootsCollection = new DistinctRootsCollection<File>((File[])object4){

            protected boolean isAncestor(File ancestor, File t) {
                Intrinsics.checkNotNullParameter((Object)ancestor, (String)"ancestor");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return FileUtil.isAncestor((File)ancestor, (File)t, (boolean)false);
            }
        };
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        object4 = WorkspaceModelExtensionsKt.findProjects((WorkspaceModel)WorkspaceModel.Companion.getInstance(project));
        object3 = object4.iterator();
        while (object3.hasNext()) {
            VirtualFile virtualFile;
            object2 = (ProjectModelEntity)object3.next();
            if (ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)object2) == null) continue;
            distinctRootsCollection.add((Object)DocumentUtilKt.toIOFile((VirtualFile)virtualFile));
        }
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        object2 = (Iterable)WorkspaceUserModelUpdater.Companion.getInstance(project2).getAttachedFolders();
        boolean bl2 = false;
        Object object52 = object2;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        Object object6 = object52.iterator();
        while (object6.hasNext()) {
            t = object6.next();
            object = (File)t;
            bl = false;
            if (!((File)object).exists()) continue;
            collection.add(t);
        }
        object2 = (List)collection;
        bl2 = false;
        object52 = object2;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        bl3 = false;
        object6 = object52.iterator();
        while (object6.hasNext()) {
            t = object6.next();
            object = (File)t;
            Collection collection2 = collection;
            bl = false;
            collection2.add(((File)object).isDirectory() ? object : ((File)object).getParentFile());
        }
        object3 = (List)collection;
        object2 = object3.iterator();
        while (object2.hasNext()) {
            File file4 = (File)object2.next();
            distinctRootsCollection.add((Object)file4);
        }
        object2 = new ArrayList();
        object52 = (Iterable)distinctRootsCollection;
        boolean bl4 = false;
        Object object7 = object52;
        object6 = new ArrayList();
        boolean bl5 = false;
        object = object7.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            File file5 = (File)e;
            boolean bl6 = false;
            if (!file5.isDirectory()) continue;
            object6.add(e);
        }
        for (Object object52 : (List)object6) {
            FileSystemExplorerNode fileSystemExplorerNode;
            Intrinsics.checkNotNull((Object)object52);
            if (this.x((File)object52) == null) continue;
            object2.add(fileSystemExplorerNode);
        }
        Project project3 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
        if (ScratchRootProvider.Companion.shouldShowScratches(project3)) {
            Project project4 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"myProject");
            Iterator iterator2 = RiderScratchProjectViewPane.Companion.createNode(project4);
            object2.add(iterator2);
        }
        return object2;
    }

    private final FileSystemExplorerNode x(File file2) {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file2, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return new FileSystemExplorerNode(project, virtualFile2, CollectionsKt.emptyList(), true);
    }

    @Override
    @NotNull
    public Comparator<AbstractTreeNode<?>> createComparator() {
        return (arg_0, arg_1) -> FileSystemExplorerRootNode.x(this, arg_0, arg_1);
    }

    private static final int x(FileSystemExplorerRootNode fileSystemExplorerRootNode, AbstractTreeNode abstractTreeNode, AbstractTreeNode abstractTreeNode2) {
        FileSystemNodeBase fileSystemNodeBase;
        FileSystemNodeBase fileSystemNodeBase2 = abstractTreeNode instanceof FileSystemNodeBase ? (FileSystemNodeBase)abstractTreeNode : null;
        FileSystemNodeBase fileSystemNodeBase3 = fileSystemNodeBase = abstractTreeNode2 instanceof FileSystemNodeBase ? (FileSystemNodeBase)abstractTreeNode2 : null;
        if (fileSystemNodeBase2 == null && fileSystemNodeBase == null) {
            return fileSystemExplorerRootNode.fallback.compare((NodeDescriptor)abstractTreeNode, (NodeDescriptor)abstractTreeNode2);
        }
        if (fileSystemNodeBase2 == null) {
            return 1;
        }
        if (fileSystemNodeBase == null) {
            return -1;
        }
        boolean bl = ProjectView.getInstance((Project)fileSystemExplorerRootNode.myProject).isFoldersAlwaysOnTop("FileSystemExplorer");
        NodeSortKey nodeSortKey = ProjectView.getInstance((Project)fileSystemExplorerRootNode.getProject()).getSortKey("FileSystemExplorer");
        Intrinsics.checkNotNullExpressionValue((Object)nodeSortKey, (String)"getSortKey(...)");
        NodeSortKey nodeSortKey2 = nodeSortKey;
        return ComparisonExtensionsKt.compareFiles(fileSystemNodeBase2.getVirtualFile(), fileSystemNodeBase.getVirtualFile(), bl, nodeSortKey2);
    }
}

