/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views.fileSystemExplorer;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.utils.ProjectViewUtils;
import com.jetbrains.rider.projectView.views.SolutionViewPaneBase;
import com.jetbrains.rider.projectView.views.fileSystemExplorer.FileSystemExplorerRootNode;
import com.jetbrains.rider.projectView.views.impl.SolutionViewSelectInTargetBase;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.RiderIcons;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0015\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerPane;", "Lcom/jetbrains/rider/projectView/views/SolutionViewPaneBase;", "project", "Lcom/intellij/openapi/project/Project;", "FileSystemExplorerPane", "(Lcom/intellij/openapi/project/Project;)V", "getId", "", "getWeight", "", "getTitle", "getIcon", "Ljavax/swing/Icon;", "isInitiallyVisible", "", "createSelectInTarget", "Lcom/jetbrains/rider/projectView/views/impl/SolutionViewSelectInTargetBase;", "initializeTree", "", "tree", "Ljavax/swing/JTree;", "myShowScratches", "getMyShowScratches", "()Z", "setMyShowScratches", "(Z)V", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "Companion", "intellij.rider"})
public final class FileSystemExplorerPane
extends SolutionViewPaneBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean myShowScratches;
    @NotNull
    public static final String ID = "FileSystemExplorer";
    @NotNull
    private static final String SHOW_SCRATCHES_OPTION = "show-scratches";
    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    private static final String Title = ProjectViewUtils.INSTANCE.isRepositoryViewEnabled() ? RiderProjectViewBundle.Companion.message("FileSystemExplorerPane.title.files", new Object[0]) : RiderProjectViewBundle.Companion.message("FileSystemExplorerPane.title.file.system", new Object[0]);
    private static final int Weight = 6;
    @NotNull
    private static final Icon Icon;

    public FileSystemExplorerPane(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, new FileSystemExplorerRootNode(project));
        this.myShowScratches = true;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    public int getWeight() {
        return Weight;
    }

    @NotNull
    public String getTitle() {
        return Title;
    }

    @NotNull
    public Icon getIcon() {
        return Icon;
    }

    public boolean isInitiallyVisible() {
        return !SolutionHostExtensionsKt.isTemporarySolution((Project)this.getProject());
    }

    @NotNull
    public SolutionViewSelectInTargetBase createSelectInTarget() {
        Project project = this.getProject();
        return new SolutionViewSelectInTargetBase(project){

            public void selectIn(SelectInContext context, boolean requestFocus) {
                block0: {
                    SelectInContext selectInContext = context;
                    if (selectInContext == null) break block0;
                    SelectInContext selectInContext2 = selectInContext;
                    boolean bl = false;
                    this.select(selectInContext2, null, requestFocus);
                }
            }

            public String toString() {
                return FileSystemExplorerPane.Companion.getTitle();
            }

            public String getMinorViewId() {
                return "FileSystemExplorer";
            }

            public float getWeight() {
                return FileSystemExplorerPane.Companion.getWeight();
            }
        };
    }

    @Override
    public void initializeTree(@NotNull JTree tree2) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        TreeUtil.promiseSelectFirst((JTree)tree2).onSuccess(arg_0 -> FileSystemExplorerPane.u((Function1)new Function1<TreePath, Unit>((Object)tree2){

            public final void invoke(TreePath p0) {
                ((JTree)this.receiver).expandPath(p0);
            }
        }, arg_0));
    }

    public final boolean getMyShowScratches() {
        return this.myShowScratches;
    }

    public final void setMyShowScratches(boolean bl) {
        this.myShowScratches = bl;
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.readExternal(element);
        String string = JDOMExternalizerUtil.readField((Element)element, (String)SHOW_SCRATCHES_OPTION);
        this.myShowScratches = string != null ? Boolean.parseBoolean(string) : true;
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"show-all-files", (String)String.valueOf(this.myShowScratches));
    }

    private static final void u(Function1 function1, Object object) {
        function1.invoke(object);
    }

    static {
        Icon icon = RiderIcons.Toolwindows.ToolwindowFileSystem;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolwindowFileSystem");
        Icon = icon;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerPane$Companion;", "", "FileSystemExplorerPane$Companion", "()V", "ID", "", "SHOW_SCRATCHES_OPTION", "Title", "getTitle", "()Ljava/lang/String;", "Weight", "", "getWeight", "()I", "Icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "getInstance", "Lcom/jetbrains/rider/projectView/views/fileSystemExplorer/FileSystemExplorerPane;", "project", "Lcom/intellij/openapi/project/Project;", "tryGetInstance", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTitle() {
            return Title;
        }

        public final int getWeight() {
            return Weight;
        }

        @NotNull
        public final Icon getIcon() {
            return Icon;
        }

        @NotNull
        public final FileSystemExplorerPane getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            FileSystemExplorerPane fileSystemExplorerPane = this.tryGetInstance(project);
            Intrinsics.checkNotNull((Object)((Object)fileSystemExplorerPane));
            return fileSystemExplorerPane;
        }

        @Nullable
        public final FileSystemExplorerPane tryGetInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (project.isDisposed()) {
                return null;
            }
            AbstractProjectViewPane abstractProjectViewPane = ProjectView.getInstance((Project)project).getProjectViewPaneById(FileSystemExplorerPane.ID);
            return abstractProjectViewPane instanceof FileSystemExplorerPane ? (FileSystemExplorerPane)abstractProjectViewPane : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

