/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ui.tree.TreeVisitor;
import com.jetbrains.rider.projectView.views.SolutionViewCustomEntityContainer;
import com.jetbrains.rider.projectView.views.SolutionViewEntitiesOwner;
import com.jetbrains.rider.projectView.views.SolutionViewEntityOwner;
import com.jetbrains.rider.projectView.views.SolutionViewVisitor;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0014J\u001e\u0010\u0011\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000bj\b\u0012\u0004\u0012\u00020\t`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/projectView/views/SolutionViewVisitorByEntity;", "Lcom/jetbrains/rider/projectView/views/SolutionViewVisitor;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "findAllPaths", "", "SolutionViewVisitorByEntity", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;Z)V", "entityPointer", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "pathEntityPointer", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "visit", "Lcom/intellij/ui/tree/TreeVisitor$Action;", "node", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "x", "nodeEntityReference", "intellij.rider"})
final class SolutionViewVisitorByEntity
extends SolutionViewVisitor {
    @NotNull
    private final ProjectModelEntityReference entityPointer;
    @NotNull
    private final HashSet<ProjectModelEntityReference> pathEntityPointer;

    public SolutionViewVisitorByEntity(@NotNull ProjectModelEntity entity, boolean findAllPaths) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        super(findAllPaths);
        this.entityPointer = ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)entity);
        this.pathEntityPointer = new HashSet();
        for (ProjectModelEntity projectModelEntity = entity; projectModelEntity != null; projectModelEntity = projectModelEntity.getParentEntity()) {
            this.pathEntityPointer.add(ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)projectModelEntity));
        }
        SolutionViewVisitor.Companion.getLog().trace("Path nodes: " + CollectionsKt.joinToString$default((Iterable)this.pathEntityPointer, (CharSequence)",", null, null, (int)0, null, SolutionViewVisitorByEntity::x, (int)30, null));
    }

    @Override
    @NotNull
    protected TreeVisitor.Action visit(@NotNull AbstractTreeNode<?> node) {
        Intrinsics.checkNotNullParameter(node, (String)"node");
        if (node instanceof SolutionViewCustomEntityContainer && ((SolutionViewCustomEntityContainer)node).contains(this.entityPointer)) {
            SolutionViewVisitor.Companion.getLog().trace("-> node '" + node + "' (probably) contains entity '" + this.entityPointer + "': CONTINUE");
            return TreeVisitor.Action.CONTINUE;
        }
        if (node instanceof SolutionViewEntitiesOwner) {
            for (ProjectModelEntityReference projectModelEntityReference : ((SolutionViewEntitiesOwner)node).getEntityPointers()) {
                TreeVisitor.Action action2 = this.x(node, projectModelEntityReference);
                if (action2 == TreeVisitor.Action.SKIP_CHILDREN) continue;
                return action2;
            }
            return TreeVisitor.Action.SKIP_CHILDREN;
        }
        if (node instanceof SolutionViewEntityOwner) {
            return this.x(node, ((SolutionViewEntityOwner)node).getEntityReference());
        }
        return TreeVisitor.Action.SKIP_CHILDREN;
    }

    private final TreeVisitor.Action x(AbstractTreeNode<?> abstractTreeNode, ProjectModelEntityReference projectModelEntityReference) {
        if (projectModelEntityReference == null) {
            return TreeVisitor.Action.SKIP_CHILDREN;
        }
        if (Intrinsics.areEqual((Object)this.entityPointer, (Object)projectModelEntityReference)) {
            SolutionViewVisitor.Companion.getLog().trace("-> node '" + abstractTreeNode + "' found: INTERRUPT");
            return TreeVisitor.Action.INTERRUPT;
        }
        if (this.pathEntityPointer.contains(projectModelEntityReference)) {
            SolutionViewVisitor.Companion.getLog().trace("-> node '" + abstractTreeNode + "' is a path node: CONTINUE");
            return TreeVisitor.Action.CONTINUE;
        }
        return TreeVisitor.Action.SKIP_CHILDREN;
    }

    private static final CharSequence x(ProjectModelEntityReference projectModelEntityReference) {
        Intrinsics.checkNotNullParameter((Object)projectModelEntityReference, (String)"it");
        return "'" + projectModelEntityReference + "'";
    }
}

