/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.ProjectViewInplaceCommentProducerImplKt;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.InplaceCommentAppender;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.projectView.ProjectViewOpenedFileLogUsageCollector;
import com.jetbrains.rider.projectView.utils.NavigationUtilKt;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001*B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00030\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0017H&J\u0012\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u001fH$J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H$J\b\u0010#\u001a\u00020\u0011H\u0014J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0014J\n\u0010(\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010)\u001a\u00020\u0011H\u0016\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/projectView/views/SolutionViewNode;", "T", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "project", "Lcom/intellij/openapi/project/Project;", "value", "SolutionViewNode", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "getChildren", "", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getFileStatusColor", "Ljava/awt/Color;", "status", "ignoreFileStatus", "", "navigate", "", "requestFocus", "canNavigate", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAllVirtualFiles", "", "allowAutoExpand", "expandOnDoubleClick", "contains", "file", "calculateChildren", "", "update", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "showInplaceComments", "appendInplaceComments", "appender", "Lcom/intellij/ide/util/treeView/InplaceCommentAppender;", "postprocess", "getBackgroundColor", "processDoubleClick", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSolutionViewNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolutionViewNode.kt\ncom/jetbrains/rider/projectView/views/SolutionViewNode\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,88:1\n13#2:89\n13#3:90\n*S KotlinDebug\n*F\n+ 1 SolutionViewNode.kt\ncom/jetbrains/rider/projectView/views/SolutionViewNode\n*L\n20#1:89\n20#1:90\n*E\n"})
public abstract class SolutionViewNode<T>
extends AbstractTreeNode<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public SolutionViewNode(@NotNull Project project, @NotNull T value2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        super(project, value2);
    }

    @NotNull
    public final Collection<? extends AbstractTreeNode<?>> getChildren() {
        List<AbstractTreeNode<?>> list2 = this.calculateChildren();
        for (AbstractTreeNode<?> abstractTreeNode : list2) {
            abstractTreeNode.setParent((AbstractTreeNode)this);
        }
        return list2;
    }

    @NotNull
    public FileStatus getFileStatus() {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"NOT_CHANGED");
            return fileStatus;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (this.ignoreFileStatus()) {
            FileStatus fileStatus = FileStatus.NOT_CHANGED;
            Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"NOT_CHANGED");
            return fileStatus;
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile2);
        Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getStatus(...)");
        return fileStatus;
    }

    @Nullable
    public Color getFileStatusColor(@Nullable FileStatus status) {
        if (this.ignoreFileStatus()) {
            return null;
        }
        return super.getFileStatusColor(status);
    }

    protected boolean ignoreFileStatus() {
        return false;
    }

    public void navigate(boolean requestFocus) {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ProjectViewOpenedFileLogUsageCollector.INSTANCE.logFileManuallyOpen(virtualFile2, project);
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        NavigationUtilKt.navigate(virtualFile2, project2, requestFocus);
    }

    public boolean canNavigate() {
        return this.canNavigateToSource();
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return null;
    }

    @NotNull
    public Set<VirtualFile> getAllVirtualFiles() {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return SetsKt.emptySet();
        }
        VirtualFile virtualFile2 = virtualFile;
        return SetsKt.setOf((Object)virtualFile2);
    }

    public boolean allowAutoExpand() {
        return true;
    }

    public boolean expandOnDoubleClick() {
        VirtualFile virtualFile = this.getVirtualFile();
        return virtualFile == null || virtualFile.isDirectory();
    }

    public abstract boolean contains(@NotNull VirtualFile var1);

    @NotNull
    protected abstract List<AbstractTreeNode<?>> calculateChildren();

    protected abstract void update(@NotNull PresentationData var1);

    protected boolean showInplaceComments() {
        return true;
    }

    protected void appendInplaceComments(@NotNull InplaceCommentAppender appender) {
        Intrinsics.checkNotNullParameter((Object)appender, (String)"appender");
        if (this.showInplaceComments() && UISettings.Companion.getInstance().getShowInplaceComments()) {
            ProjectViewInplaceCommentProducerImplKt.appendInplaceComments((InplaceCommentAppender)appender, (Project)this.getProject(), (VirtualFile)this.getVirtualFile());
        }
    }

    protected void postprocess(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.postprocess(presentation);
        presentation.setBackground(this.getBackgroundColor());
    }

    @Nullable
    public Color getBackgroundColor() {
        return null;
    }

    public boolean processDoubleClick() {
        return false;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(SolutionViewNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SolutionViewNode.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/projectView/views/SolutionViewNode$Companion;", "", "SolutionViewNode$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

