/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.views;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.views.NestingNode;
import com.jetbrains.rider.projectView.views.NestingNodeKt;
import com.jetbrains.rider.projectView.views.SolutionViewEntitiesOwner;
import com.jetbrains.rider.projectView.views.SolutionViewEntityOwner;
import com.jetbrains.rider.projectView.views.SolutionViewNode;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.views.assemblyExplorer.AssemblyExplorerHost;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B+\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030 0\u001fH\u0014J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J$\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00022\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\tH&J\b\u0010&\u001a\u00020\u001dH\u0016J\b\u0010'\u001a\u00020\u0002H\u0016J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0012\u0010)\u001a\f0*\u00a2\u0006\u0002\b+\u00a2\u0006\u0002\b,H\u0016J\u0012\u0010-\u001a\f0*\u00a2\u0006\u0002\b+\u00a2\u0006\u0002\b,H\u0016J\u0012\u0010.\u001a\f0*\u00a2\u0006\u0002\b+\u00a2\u0006\u0002\b,H\u0016R\u0011\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/projectView/views/FileSystemNodeBase;", "Lcom/jetbrains/rider/projectView/views/SolutionViewNode;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/rider/projectView/views/SolutionViewEntityOwner;", "Lcom/jetbrains/rider/projectView/views/SolutionViewEntitiesOwner;", "project", "Lcom/intellij/openapi/project/Project;", "file", "nestedFiles", "", "Lcom/jetbrains/rider/projectView/views/NestingNode;", "FileSystemNodeBase", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "entities", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getEntities", "()Ljava/util/List;", "entityPointers", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "getEntityPointers", "entity", "getEntity", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "entityReference", "getEntityReference", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "processDoubleClick", "", "calculateChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getVirtualFileChildren", "getBackgroundColor", "Ljava/awt/Color;", "createNode", "virtualFile", "canNavigateToSource", "getVirtualFile", "contains", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getTestPresentation", "toString", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nFileSystemNodeBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemNodeBase.kt\ncom/jetbrains/rider/projectView/views/FileSystemNodeBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n774#2:108\n865#2,2:109\n1563#2:111\n1634#2,3:112\n669#2,11:115\n1761#2,3:126\n*S KotlinDebug\n*F\n+ 1 FileSystemNodeBase.kt\ncom/jetbrains/rider/projectView/views/FileSystemNodeBase\n*L\n23#1:108\n23#1:109,2\n27#1:111\n27#1:112,3\n32#1:115,11\n101#1:126,3\n*E\n"})
public abstract class FileSystemNodeBase
extends SolutionViewNode<VirtualFile>
implements SolutionViewEntityOwner,
SolutionViewEntitiesOwner {
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final List<NestingNode<VirtualFile>> nestedFiles;

    public FileSystemNodeBase(@NotNull Project project, @NotNull VirtualFile file2, @NotNull List<NestingNode<VirtualFile>> nestedFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(nestedFiles, (String)"nestedFiles");
        super(project, file2);
        this.file = file2;
        this.nestedFiles = nestedFiles;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public List<ProjectModelEntity> getEntities() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        Iterable iterable = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)this.file, (Project)project2);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t : iterable2) {
            ProjectModelEntity projectModelEntity = (ProjectModelEntity)t;
            boolean bl3 = false;
            if (!(ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)projectModelEntity) || ProjectModelEntityExtensionsKt.isProjectFolder((ProjectModelEntity)projectModelEntity) || ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)projectModelEntity) || ProjectModelEntityExtensionsKt.isUnloadedProject((ProjectModelEntity)projectModelEntity) || ProjectModelEntityExtensionsKt.isSolution((ProjectModelEntity)projectModelEntity))) continue;
            collection.add(t);
        }
        return CollectionsKt.toList((Iterable)((List)collection));
    }

    @Override
    @NotNull
    public List<ProjectModelEntityReference> getEntityPointers() {
        Iterable iterable = this.getEntities();
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            ProjectModelEntity projectModelEntity = (ProjectModelEntity)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)projectModelEntity));
        }
        return CollectionsKt.toList((Iterable)((List)collection));
    }

    @Override
    @Nullable
    public ProjectModelEntity getEntity() {
        ProjectModelEntity projectModelEntity;
        ProjectModelEntity projectModelEntity2 = (ProjectModelEntity)CollectionsKt.singleOrNull(this.getEntities());
        if (projectModelEntity2 == null) {
            Object v1;
            block5: {
                Iterable iterable = this.getEntities();
                boolean bl = false;
                Object var4_3 = null;
                boolean bl2 = false;
                for (Object t : iterable) {
                    ProjectModelEntity projectModelEntity3 = (ProjectModelEntity)t;
                    boolean bl3 = false;
                    if (!ProjectModelEntityExtensionsKt.isFromSharedProject((ProjectModelEntity)projectModelEntity3)) continue;
                    if (bl2) {
                        v1 = null;
                        break block5;
                    }
                    var4_3 = t;
                    bl2 = true;
                }
                v1 = !bl2 ? null : var4_3;
            }
            projectModelEntity2 = v1;
        }
        if ((projectModelEntity = projectModelEntity2) != null) {
            if (ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)projectModelEntity) && !this.file.isDirectory()) {
                return null;
            }
            return projectModelEntity;
        }
        return null;
    }

    @Override
    @Nullable
    public ProjectModelEntityReference getEntityReference() {
        ProjectModelEntity projectModelEntity = this.getEntity();
        return projectModelEntity != null ? ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)projectModelEntity) : null;
    }

    @Override
    public boolean processDoubleClick() {
        if (this.getVirtualFile().exists() && Intrinsics.areEqual((Object)this.getVirtualFile().getExtension(), (Object)"dll")) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            AssemblyExplorerHost.Companion.getInstance(project).add(CollectionsKt.listOf((Object)this.getVirtualFile()));
            return true;
        }
        return super.processDoubleClick();
    }

    @Override
    @NotNull
    protected List<AbstractTreeNode<?>> calculateChildren() {
        List list2 = new ArrayList();
        if (this.file.isDirectory()) {
            List list3 = new ArrayList();
            List list4 = new ArrayList();
            for (VirtualFile object2 : this.getVirtualFileChildren()) {
                if (ApplicationKt.getApplication().isUnitTestMode() && Intrinsics.areEqual((Object)object2.getName(), (Object)".idea")) continue;
                boolean bl = object2.isDirectory() ? list3.add(object2) : list4.add(object2);
            }
            for (VirtualFile virtualFile : list3) {
                list2.add(this.createNode(virtualFile, CollectionsKt.emptyList()));
            }
            List<NestingNode<VirtualFile>> list5 = NestingNodeKt.mapNestedVirtualFiles(list4);
            Iterator iterator2 = list5.iterator();
            while (iterator2.hasNext()) {
                NestingNode nestingNode = (NestingNode)iterator2.next();
                list2.add(this.createNode((VirtualFile)nestingNode.getValue(), nestingNode.getChildren()));
            }
        } else {
            for (NestingNode<VirtualFile> nestingNode : this.nestedFiles) {
                list2.add(this.createNode(nestingNode.getValue(), nestingNode.getChildren()));
            }
        }
        return list2;
    }

    @NotNull
    public List<VirtualFile> getVirtualFileChildren() {
        return SolutionViewUtilsKt.getChildrenForSolutionView(this.getVirtualFile());
    }

    @Override
    @Nullable
    public Color getBackgroundColor() {
        VirtualFile virtualFile = this.getVirtualFile();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return ProjectModelNodeExtensionKt.getScopeColor((VirtualFile)virtualFile, (Project)project, (Boolean)false, (boolean)false);
    }

    @NotNull
    public abstract FileSystemNodeBase createNode(@NotNull VirtualFile var1, @NotNull List<NestingNode<VirtualFile>> var2);

    public boolean canNavigateToSource() {
        return !this.file.isDirectory();
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        return this.file;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (VfsUtil.isAncestor((VirtualFile)this.file, (VirtualFile)file2, (boolean)false)) {
                return true;
            }
            Iterable iterable = this.nestedFiles;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    NestingNode nestingNode = (NestingNode)t;
                    boolean bl3 = false;
                    if (!nestingNode.contains(arg_0 -> FileSystemNodeBase.x(file2, arg_0))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String getName() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String getTestPresentation() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String toString() {
        String string = this.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private static final boolean x(VirtualFile virtualFile, NestingNode nestingNode) {
        Intrinsics.checkNotNullParameter((Object)nestingNode, (String)"node");
        return Intrinsics.areEqual(nestingNode.getValue(), (Object)virtualFile);
    }
}

