/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"isSolutionFile", "", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "withSymlink", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolveSymlinkedSolutionFile", "intellij.rider"})
public final class ProjectModelViewUtilKt {
    public static final boolean isSolutionFile(@NotNull File $this$isSolutionFile, @NotNull Project project, boolean withSymlink) {
        Intrinsics.checkNotNullParameter((Object)$this$isSolutionFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
        Path path = $this$isSolutionFile.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        if (CollectionsKt.any((Iterable)WorkspaceModelExtensionsKt.getProjectModelIds((WorkspaceModel)workspaceModel, (Path)path, (Project)project))) {
            return true;
        }
        if (withSymlink) {
            VirtualFile virtualFile = DocumentUtilKt.toVirtualFile((File)$this$isSolutionFile, (boolean)true);
            if (virtualFile == null) {
                return false;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (virtualFile2.getCanonicalPath() == null) {
                return false;
            }
            return !Intrinsics.areEqual((Object)ProjectRootUtil.findSymlinkedFileInContent((Project)project, (VirtualFile)virtualFile2), (Object)virtualFile2);
        }
        return false;
    }

    public static final boolean isSolutionFile(@NotNull VirtualFile $this$isSolutionFile, @NotNull Project project, boolean withSymlink) {
        Intrinsics.checkNotNullParameter((Object)$this$isSolutionFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectModelViewUtilKt.isSolutionFile(DocumentUtilKt.toIOFile((VirtualFile)$this$isSolutionFile), project, withSymlink);
    }

    @Nullable
    public static final VirtualFile resolveSymlinkedSolutionFile(@NotNull VirtualFile $this$resolveSymlinkedSolutionFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveSymlinkedSolutionFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ProjectModelViewUtilKt.isSolutionFile($this$resolveSymlinkedSolutionFile, project, false)) {
            return $this$resolveSymlinkedSolutionFile;
        }
        if ($this$resolveSymlinkedSolutionFile.getCanonicalPath() == null) {
            return null;
        }
        return ProjectRootUtil.findSymlinkedFileInContent((Project)project, (VirtualFile)$this$resolveSymlinkedSolutionFile);
    }
}

