/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.scopes;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.jetbrains.rider.projectView.scopes.FileSystemNode;
import com.jetbrains.rider.projectView.scopes.FileSystemPatternPackageSet;
import com.jetbrains.rider.projectView.scopes.FileSystemTreeModelBuilder;
import com.jetbrains.rider.projectView.utils.ProjectViewUtils;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.RiderIcons;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J#\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\f0\u0005\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b#H\u0016\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/projectView/scopes/FileSystemPatternProvider;", "Lcom/intellij/packageDependencies/ui/PatternDialectProvider;", "FileSystemPatternProvider", "()V", "getDisplayName", "", "Lcom/intellij/openapi/util/NlsActions$ActionText;", "getShortName", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "createTreeModel", "Lcom/intellij/packageDependencies/ui/TreeModel;", "project", "Lcom/intellij/openapi/project/Project;", "marker", "Lcom/intellij/packageDependencies/ui/Marker;", "deps", "", "Lcom/intellij/psi/PsiFile;", "settings", "Lcom/intellij/packageDependencies/ui/DependenciesPanel$DependencyPanelSettings;", "createActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "update", "Ljava/lang/Runnable;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Runnable;)[Lcom/intellij/openapi/actionSystem/AnAction;", "createPackageSet", "Lcom/intellij/psi/search/scope/packageSet/PackageSet;", "node", "Lcom/intellij/packageDependencies/ui/PackageDependenciesNode;", "recursively", "", "getHintMessage", "Lorg/jetbrains/annotations/Nls;", "intellij.rider"})
public final class FileSystemPatternProvider
extends PatternDialectProvider {
    @Nullable
    public String getDisplayName() {
        return ProjectViewUtils.INSTANCE.isRepositoryViewEnabled() ? RiderProjectViewBundle.Companion.message("FileSystemExplorerPane.title.files", new Object[0]) : RiderProjectViewBundle.Companion.message("FileSystemExplorerPane.title.file.system", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "filesystem";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = RiderIcons.Toolwindows.ToolwindowFileSystem;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolwindowFileSystem");
        return icon;
    }

    @NotNull
    public TreeModel createTreeModel(@NotNull Project project, @NotNull Marker marker) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        return this.createTreeModel(project, SetsKt.emptySet(), marker, new DependenciesPanel.DependencyPanelSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TreeModel createTreeModel(@NotNull Project project, @NotNull Set<? extends PsiFile> deps, @NotNull Marker marker, @NotNull DependenciesPanel.DependencyPanelSettings settings) {
        TreeModel treeModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(deps, (String)"deps");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        FileSystemPatternProvider fileSystemPatternProvider = this;
        synchronized (fileSystemPatternProvider) {
            boolean bl = false;
            treeModel = new FileSystemTreeModelBuilder(project, marker, settings).build(project);
        }
        return treeModel;
    }

    @NotNull
    public AnAction[] createActions(@NotNull Project project, @NotNull Runnable update) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return AnAction.EMPTY_ARRAY;
    }

    @Nullable
    public PackageSet createPackageSet(@NotNull PackageDependenciesNode node, boolean recursively) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        FileSystemNode fileSystemNode = node instanceof FileSystemNode ? (FileSystemNode)node : null;
        if (fileSystemNode == null) {
            return null;
        }
        FileSystemNode fileSystemNode2 = fileSystemNode;
        String string = fileSystemNode2.getRelativePath();
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (fileSystemNode2.getVirtualFile().isDirectory()) {
            String string3 = ((CharSequence)string2).length() > 0 ? (recursively ? "//*" : "/*") : (recursively ? "*/" : "*");
            object = string2 + string3;
        } else {
            object = string2;
        }
        String string4 = object;
        return (PackageSet)new FileSystemPatternPackageSet(string4);
    }

    @NotNull
    public String getHintMessage() {
        String string = LangBundle.message((String)"package.pattern.provider.hint.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

