/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.projectTemplates.templateTypes;

import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.RdProjectTemplate;
import com.jetbrains.rider.projectView.projectTemplates.NewProjectDialogContext;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesCollector;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesSharedModel;
import com.jetbrains.rider.projectView.projectTemplates.generators.TypeListBasedProjectTemplateGenerator;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.PredefinedProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.utils.ExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.RiderIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/WebAppProjectTemplateType;", "Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/PredefinedProjectTemplateType;", "WebAppProjectTemplateType", "()V", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "order", "", "getOrder", "()I", "acceptableForTemplate", "", "projectTemplate", "Lcom/jetbrains/rider/model/RdProjectTemplate;", "createGenerator", "Lcom/jetbrains/rider/projectView/projectTemplates/generators/TypeListBasedProjectTemplateGenerator;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "context", "Lcom/jetbrains/rider/projectView/projectTemplates/NewProjectDialogContext;", "sharedModel", "Lcom/jetbrains/rider/projectView/projectTemplates/ProjectTemplatesSharedModel;", "Companion", "intellij.rider"})
public final class WebAppProjectTemplateType
extends PredefinedProjectTemplateType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Icon icon;
    @NotNull
    private final String name;
    private final int order;

    public WebAppProjectTemplateType() {
        Icon icon = RiderIcons.Templates.TemplateWebApp;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TemplateWebApp");
        this.icon = icon;
        this.name = RiderProjectViewBundle.Companion.message("NewProjectDialog.WebAppProjectTemplateType.name", new Object[0]);
        this.order = 40;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean acceptableForTemplate(@NotNull RdProjectTemplate projectTemplate) {
        Intrinsics.checkNotNullParameter((Object)projectTemplate, (String)"projectTemplate");
        return this.checkId(projectTemplate) && Companion.acceptableForTemplateInternal$intellij_rider(projectTemplate);
    }

    @Override
    @NotNull
    public TypeListBasedProjectTemplateGenerator createGenerator(@NotNull Lifetime lifetime, @NotNull NewProjectDialogContext context, @NotNull ProjectTemplatesSharedModel sharedModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sharedModel, (String)"sharedModel");
        IOptProperty<Set<RdProjectTemplate>> iOptProperty = this.getProjectTemplates();
        return new TypeListBasedProjectTemplateGenerator(lifetime, context, sharedModel, iOptProperty){
            private final String defaultName;
            private final ProjectTemplatesCollector.ProjectType projectType;
            private final Set<String> mustSeeOptions;
            {
                this.defaultName = "WebApp1";
                this.projectType = ProjectTemplatesCollector.ProjectType.Web;
                Object[] objectArray = new String[]{"Hosted", "InteractivityPlatform", "InteractivityLocation", "IncludeSampleContent", "Auth", "SupportPagesAndViews"};
                this.mustSeeOptions = SetsKt.plus(super.getMustSeeOptions(), (Iterable)SetsKt.setOf((Object[])objectArray));
            }

            public String getDefaultName() {
                return this.defaultName;
            }

            protected ProjectTemplatesCollector.ProjectType getProjectType() {
                return this.projectType;
            }

            protected Set<String> getMustSeeOptions() {
                return this.mustSeeOptions;
            }

            public List<TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon> getPredefinedTypes() {
                Object[] objectArray = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon[9];
                Icon icon = RiderIcons.Templates.TemplateBlazor;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TemplateBlazor");
                objectArray[0] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Blazor Web App", icon, false, 4, null);
                Icon icon2 = RiderIcons.Templates.TemplateBlazor;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"TemplateBlazor");
                objectArray[1] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Blazor WebAssembly Standalone App", icon2, false, 4, null);
                Icon icon3 = RiderIcons.Templates.TemplateProject;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"TemplateProject");
                objectArray[2] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Empty", icon3, false, 4, null);
                Icon icon4 = RiderIcons.Templates.TemplateRazor;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"TemplateRazor");
                objectArray[3] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Razor Class Library", icon4, false, 4, null);
                Icon icon5 = RiderIcons.Templates.TemplateEndpoint;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"TemplateEndpoint");
                objectArray[4] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Web API", icon5, false, 4, null);
                Icon icon6 = RiderIcons.Templates.TemplateEndpoint;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"TemplateEndpoint");
                objectArray[5] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Web API (native AOT)", icon6, false, 4, null);
                Icon icon7 = RiderIcons.Templates.TemplateWebApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"TemplateWebApp");
                objectArray[6] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Web App (Model-View-Controller)", icon7, false, 4, null);
                Icon icon8 = RiderIcons.Templates.TemplateWebApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"TemplateWebApp");
                objectArray[7] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Web App (Razor Pages)", icon8, false, 4, null);
                Icon icon9 = RiderIcons.Templates.TemplateGRPC;
                Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"TemplateGRPC");
                objectArray[8] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("gRPC Service", icon9, false, 4, null);
                return CollectionsKt.listOf((Object[])objectArray);
            }

            protected Icon tryFindIcon(String name) {
                Icon icon;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (StringsKt.contains((CharSequence)name, (CharSequence)"Blazor", (boolean)true)) {
                    Icon icon2 = RiderIcons.Templates.TemplateBlazor;
                    icon = icon2;
                    Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"TemplateBlazor");
                } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Razor", (boolean)true)) {
                    Icon icon3 = RiderIcons.Templates.TemplateRazor;
                    icon = icon3;
                    Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"TemplateRazor");
                } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Web API", (boolean)true)) {
                    Icon icon4 = RiderIcons.Templates.TemplateEndpoint;
                    icon = icon4;
                    Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"TemplateEndpoint");
                } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Web APP", (boolean)true)) {
                    Icon icon5 = RiderIcons.Templates.TemplateWebApp;
                    icon = icon5;
                    Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"TemplateWebApp");
                } else if (StringsKt.contains((CharSequence)name, (CharSequence)"Angular", (boolean)true)) {
                    Icon icon6 = RiderIcons.Templates.TemplateAngular;
                    icon = icon6;
                    Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"TemplateAngular");
                } else if (StringsKt.contains((CharSequence)name, (CharSequence)"React.js and Redux", (boolean)true)) {
                    Icon icon7 = RiderIcons.Templates.TemplateRedux;
                    icon = icon7;
                    Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"TemplateRedux");
                } else if (StringsKt.contains((CharSequence)name, (CharSequence)"React.js", (boolean)true)) {
                    Icon icon8 = RiderIcons.Templates.TemplateReactJS;
                    icon = icon8;
                    Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"TemplateReactJS");
                } else if (StringsKt.contains((CharSequence)name, (CharSequence)"gRPC", (boolean)true)) {
                    Icon icon9 = RiderIcons.Templates.TemplateGRPC;
                    icon = icon9;
                    Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"TemplateGRPC");
                } else {
                    Icon icon10 = RiderIcons.Templates.TemplateProject;
                    icon = icon10;
                    Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"TemplateProject");
                }
                return icon;
            }

            public String getType(RdProjectTemplate template2) {
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                return StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)template2.getName(), (CharSequence)"ASP.NET"))).toString(), (CharSequence)"Core"))).toString(), (String)"Application", (String)"App", (boolean)false, (int)4, null);
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/WebAppProjectTemplateType$Companion;", "", "WebAppProjectTemplateType$Companion", "()V", "acceptableForTemplateInternal", "", "projectTemplate", "Lcom/jetbrains/rider/model/RdProjectTemplate;", "acceptableForTemplateInternal$intellij_rider", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean acceptableForTemplateInternal$intellij_rider(@NotNull RdProjectTemplate projectTemplate) {
            Intrinsics.checkNotNullParameter((Object)projectTemplate, (String)"projectTemplate");
            return (ExtensionsKt.hasClassification(projectTemplate, "web") || ExtensionsKt.hasClassification(projectTemplate, "cloud")) && !ExtensionsKt.hasClassification(projectTemplate, "worker") && !ExtensionsKt.hasClassification(projectTemplate, "test") && !ExtensionsKt.hasClassification(projectTemplate, "AI");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

