/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.projectTemplates.templateTypes;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.RdProjectTemplate;
import com.jetbrains.rider.projectView.projectTemplates.NewProjectDialogContext;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesCollector;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesSharedModel;
import com.jetbrains.rider.projectView.projectTemplates.generators.TypeListBasedProjectTemplateGenerator;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.PredefinedProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.utils.ExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.RiderIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/DesktopProjectTemplateType;", "Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/PredefinedProjectTemplateType;", "DesktopProjectTemplateType", "()V", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "order", "", "getOrder", "()I", "shouldHide", "", "getShouldHide", "()Z", "acceptableForTemplate", "projectTemplate", "Lcom/jetbrains/rider/model/RdProjectTemplate;", "createGenerator", "Lcom/jetbrains/rider/projectView/projectTemplates/generators/TypeListBasedProjectTemplateGenerator;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "context", "Lcom/jetbrains/rider/projectView/projectTemplates/NewProjectDialogContext;", "sharedModel", "Lcom/jetbrains/rider/projectView/projectTemplates/ProjectTemplatesSharedModel;", "Companion", "intellij.rider"})
public final class DesktopProjectTemplateType
extends PredefinedProjectTemplateType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Icon icon;
    @NotNull
    private final String name;
    private final int order;

    public DesktopProjectTemplateType() {
        Icon icon = RiderIcons.Templates.TemplateDesktop;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TemplateDesktop");
        this.icon = icon;
        this.name = RiderProjectViewBundle.Companion.message("NewProjectDialog.DesktopProjectTemplateType.name", new Object[0]);
        this.order = 30;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean getShouldHide() {
        return !SystemInfo.isWindows;
    }

    @Override
    public boolean acceptableForTemplate(@NotNull RdProjectTemplate projectTemplate) {
        Intrinsics.checkNotNullParameter((Object)projectTemplate, (String)"projectTemplate");
        return this.checkId(projectTemplate) && Companion.acceptableForTemplateInternal$intellij_rider(projectTemplate);
    }

    @Override
    @NotNull
    public TypeListBasedProjectTemplateGenerator createGenerator(@NotNull Lifetime lifetime, @NotNull NewProjectDialogContext context, @NotNull ProjectTemplatesSharedModel sharedModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sharedModel, (String)"sharedModel");
        IOptProperty<Set<RdProjectTemplate>> iOptProperty = this.getProjectTemplates();
        return new TypeListBasedProjectTemplateGenerator(lifetime, context, sharedModel, iOptProperty){
            private final String defaultName;
            private final ProjectTemplatesCollector.ProjectType projectType;
            {
                this.defaultName = "DesktopApp1";
                this.projectType = ProjectTemplatesCollector.ProjectType.Desktop;
            }

            public String getDefaultName() {
                return this.defaultName;
            }

            protected ProjectTemplatesCollector.ProjectType getProjectType() {
                return this.projectType;
            }

            public List<TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon> getPredefinedTypes() {
                Object[] objectArray = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon[7];
                Icon icon = RiderIcons.Templates.FormsApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FormsApp");
                objectArray[0] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Windows Forms App", icon, false, 4, null);
                Icon icon2 = RiderIcons.Templates.FormsApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FormsApp");
                objectArray[1] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Windows Forms Class Library", icon2, false, 4, null);
                Icon icon3 = RiderIcons.Templates.FormsApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"FormsApp");
                objectArray[2] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Windows Forms Control Library", icon3, false, 4, null);
                Icon icon4 = RiderIcons.Templates.WpfApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"WpfApp");
                objectArray[3] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("WPF Application", icon4, false, 4, null);
                Icon icon5 = RiderIcons.Templates.WpfApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"WpfApp");
                objectArray[4] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("WPF Class Library", icon5, false, 4, null);
                Icon icon6 = RiderIcons.Templates.WpfApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"WpfApp");
                objectArray[5] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("WPF Custom Control Library", icon6, false, 4, null);
                Icon icon7 = RiderIcons.Templates.WpfApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"WpfApp");
                objectArray[6] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("WPF User Control Library", icon7, false, 4, null);
                return CollectionsKt.listOf((Object[])objectArray);
            }

            public String getType(RdProjectTemplate template2) {
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                return StringsKt.replace$default((String)template2.getName(), (String)"library", (String)"Library", (boolean)false, (int)4, null);
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/DesktopProjectTemplateType$Companion;", "", "DesktopProjectTemplateType$Companion", "()V", "acceptableForTemplateInternal", "", "projectTemplate", "Lcom/jetbrains/rider/model/RdProjectTemplate;", "acceptableForTemplateInternal$intellij_rider", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean acceptableForTemplateInternal$intellij_rider(@NotNull RdProjectTemplate projectTemplate) {
            Intrinsics.checkNotNullParameter((Object)projectTemplate, (String)"projectTemplate");
            return !ExtensionsKt.hasClassification(projectTemplate, "test") && (ExtensionsKt.hasClassification(projectTemplate, "desktop") || ExtensionsKt.hasClassification(projectTemplate, "WinForms") || ExtensionsKt.hasClassification(projectTemplate, "WPF"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

