/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.projectTemplates.components;

import com.jetbrains.rider.projectView.projectTemplates.components.ProjectTemplateSdk;
import com.jetbrains.rider.projectView.projectTemplates.utils.Version;
import com.jetbrains.wormhole.Equitable;
import java.util.Comparator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B$\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019J\u0013\u0010\u001a\u001a\u00020\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0003H\u0016R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/components/ProjectTemplateTargetFramework;", "Lcom/jetbrains/wormhole/Equitable;", "presentation", "", "Lcom/intellij/openapi/util/NlsSafe;", "value", "isNet", "", "ProjectTemplateTargetFramework", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getPresentation", "()Ljava/lang/String;", "getValue", "()Z", "isInstalled", "()Ljava/lang/Boolean;", "setInstalled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "version", "Lcom/jetbrains/rider/projectView/projectTemplates/utils/Version;", "getVersion", "()Lcom/jetbrains/rider/projectView/projectTemplates/utils/Version;", "isAcceptableForSdk", "sdk", "Lcom/jetbrains/rider/projectView/projectTemplates/components/ProjectTemplateSdk;", "equals", "other", "", "hashCode", "", "toString", "Companion", "intellij.rider"})
public final class ProjectTemplateTargetFramework
extends Equitable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String presentation;
    @NotNull
    private final String value;
    private final boolean isNet;
    @Nullable
    private Boolean isInstalled;
    @NotNull
    private final Version version;
    @NotNull
    private static final ProjectTemplateTargetFramework net100 = new ProjectTemplateTargetFramework("net10.0", "net10.0", true);
    @NotNull
    private static final ProjectTemplateTargetFramework net90 = new ProjectTemplateTargetFramework("net9.0", "net9.0", true);
    @NotNull
    private static final ProjectTemplateTargetFramework net80 = new ProjectTemplateTargetFramework("net8.0", "net8.0", true);
    @NotNull
    private static final ProjectTemplateTargetFramework v481 = new ProjectTemplateTargetFramework("v4.8.1", "v4.8.1", false);
    @NotNull
    private static final ProjectTemplateTargetFramework latest = net100;
    @NotNull
    private static final Set<ProjectTemplateTargetFramework> allPredefinedNet;
    @NotNull
    private static final Set<ProjectTemplateTargetFramework> allPredefinedFullFramework;
    @NotNull
    private static final Set<ProjectTemplateTargetFramework> allPredefined;
    @NotNull
    private static final Comparator<ProjectTemplateTargetFramework> comparator;

    public ProjectTemplateTargetFramework(@NotNull String presentation, @NotNull String value2, boolean isNet) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.presentation = presentation;
        this.value = value2;
        this.isNet = isNet;
        this.version = Version.Companion.tryParse(this.value);
    }

    @NotNull
    public final String getPresentation() {
        return this.presentation;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    public final boolean isNet() {
        return this.isNet;
    }

    @Nullable
    public final Boolean isInstalled() {
        return this.isInstalled;
    }

    public final void setInstalled(@Nullable Boolean bl) {
        this.isInstalled = bl;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    public final boolean isAcceptableForSdk(@NotNull ProjectTemplateSdk sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        if (Intrinsics.areEqual((Object)sdk, (Object)ProjectTemplateSdk.Companion.getFullFramework())) {
            return !this.isNet;
        }
        if (!this.isNet) {
            return false;
        }
        Version version = this.version;
        Version version2 = new Version(sdk.getValue().getMajor(), sdk.getValue().getMinor(), 0);
        return version2.compareTo(version) >= 0;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProjectTemplateTargetFramework cfr_ignored_0 = (ProjectTemplateTargetFramework)other;
        if (!Intrinsics.areEqual((Object)this.presentation, (Object)((ProjectTemplateTargetFramework)other).presentation)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.value, (Object)((ProjectTemplateTargetFramework)other).value)) {
            return false;
        }
        return this.isNet == ((ProjectTemplateTargetFramework)other).isNet;
    }

    @Override
    public int hashCode() {
        int n = this.presentation.hashCode();
        n = 31 * n + this.value.hashCode();
        n = 31 * n + Boolean.hashCode(this.isNet);
        return n;
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    private static final int x(ProjectTemplateTargetFramework projectTemplateTargetFramework, ProjectTemplateTargetFramework projectTemplateTargetFramework2) {
        if (projectTemplateTargetFramework.isNet && !projectTemplateTargetFramework2.isNet) {
            return -1;
        }
        if (!projectTemplateTargetFramework.isNet && projectTemplateTargetFramework2.isNet) {
            return 1;
        }
        if (projectTemplateTargetFramework2.version.compareTo(projectTemplateTargetFramework.version) == 0) {
            Boolean bl = projectTemplateTargetFramework2.isInstalled;
            Boolean bl2 = projectTemplateTargetFramework.isInstalled;
            return Boolean.compare(bl != null ? bl : true, bl2 != null ? bl2 : true);
        }
        return projectTemplateTargetFramework2.version.compareTo(projectTemplateTargetFramework.version);
    }

    static {
        Object[] objectArray = new ProjectTemplateTargetFramework[]{net100, net90, net80};
        allPredefinedNet = SetsKt.setOf((Object[])objectArray);
        allPredefinedFullFramework = SetsKt.setOf((Object)v481);
        allPredefined = SetsKt.plus(allPredefinedNet, (Iterable)allPredefinedFullFramework);
        comparator = ProjectTemplateTargetFramework::x;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R$\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0019j\b\u0012\u0004\u0012\u00020\u0005`\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/components/ProjectTemplateTargetFramework$Companion;", "", "ProjectTemplateTargetFramework$Companion", "()V", "net100", "Lcom/jetbrains/rider/projectView/projectTemplates/components/ProjectTemplateTargetFramework;", "getNet100", "()Lcom/jetbrains/rider/projectView/projectTemplates/components/ProjectTemplateTargetFramework;", "net90", "getNet90", "net80", "getNet80", "v481", "getV481", "latest", "getLatest", "allPredefinedNet", "", "getAllPredefinedNet", "()Ljava/util/Set;", "allPredefinedFullFramework", "getAllPredefinedFullFramework", "allPredefined", "getAllPredefined", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getComparator$intellij_rider", "()Ljava/util/Comparator;", "createFromProtocol", "presentation", "", "value", "isNet", "", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nTargetFrameworkSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetFrameworkSelector.kt\ncom/jetbrains/rider/projectView/projectTemplates/components/ProjectTemplateTargetFramework$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,429:1\n1#2:430\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectTemplateTargetFramework getNet100() {
            return net100;
        }

        @NotNull
        public final ProjectTemplateTargetFramework getNet90() {
            return net90;
        }

        @NotNull
        public final ProjectTemplateTargetFramework getNet80() {
            return net80;
        }

        @NotNull
        public final ProjectTemplateTargetFramework getV481() {
            return v481;
        }

        @NotNull
        public final ProjectTemplateTargetFramework getLatest() {
            return latest;
        }

        @NotNull
        public final Set<ProjectTemplateTargetFramework> getAllPredefinedNet() {
            return allPredefinedNet;
        }

        @NotNull
        public final Set<ProjectTemplateTargetFramework> getAllPredefinedFullFramework() {
            return allPredefinedFullFramework;
        }

        @NotNull
        public final Set<ProjectTemplateTargetFramework> getAllPredefined() {
            return allPredefined;
        }

        @NotNull
        public final Comparator<ProjectTemplateTargetFramework> getComparator$intellij_rider() {
            return comparator;
        }

        @NotNull
        public final ProjectTemplateTargetFramework createFromProtocol(@NotNull String presentation, @NotNull String value2, boolean isNet) {
            ProjectTemplateTargetFramework projectTemplateTargetFramework;
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            ProjectTemplateTargetFramework projectTemplateTargetFramework2 = projectTemplateTargetFramework = new ProjectTemplateTargetFramework(presentation, value2, isNet);
            boolean bl = false;
            projectTemplateTargetFramework2.setInstalled(true);
            return projectTemplateTargetFramework;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

