/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions.scaffolding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.RdAddScaffoldedItemRequest;
import com.jetbrains.rd.ide.model.RdAddScaffoldedItemResult;
import com.jetbrains.rd.ide.model.ScaffoldedItemKind;
import com.jetbrains.rd.ide.model.ScaffoldedItemStatus;
import com.jetbrains.rd.ide.model.ScaffoldingItemModel;
import com.jetbrains.rd.ide.model.ScaffoldingItemModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFolderDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.actions.ProjectViewActionBase;
import com.jetbrains.rider.projectView.actions.scaffolding.ScaffoldItemNameValidator;
import com.jetbrains.rider.projectView.actions.scaffolding.ScaffoldingDialogWithTemplates;
import com.jetbrains.rider.projectView.actions.scaffolding.ScaffoldingTemplate;
import com.jetbrains.rider.projectView.actions.scaffolding.fus.ScaffoldItemFUSLogger;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import java.awt.event.InputEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J&\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J6\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0001\u0010\u0011\u001a\u00020\u000e2\b\b\u0001\u0010\u001b\u001a\u00020\u000eH\u0002J(\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001fH\u0002J\u0016\u0010 \u001a\u00020\n2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001fH\u0002J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006&"}, d2={"Lcom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction;", "Lcom/jetbrains/rider/projectView/actions/ProjectViewActionBase;", "AddNewScaffoldedItemAction", "()V", "getItemInternal", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "entity", "project", "Lcom/intellij/openapi/project/Project;", "actionPerformedInternal", "", "x", "Lcom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction$ScaffoldingRequestData;", "template", "", "execute", "node", "itemName", "x", "", "descriptor", "Lcom/jetbrains/rider/model/RdProjectDescriptor;", "x", "Lcom/jetbrains/rd/ide/model/RdAddScaffoldedItemResult;", "targetNode", "itemKind", "Lcom/jetbrains/rd/ide/model/ScaffoldedItemKind;", "taskName", "x", "pathToOpen", "pathsToRefresh", "", "x", "x", "path", "Ljava/nio/file/Path;", "Companion", "ScaffoldingRequestData", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nAddNewScaffoldedItemAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddNewScaffoldedItemAction.kt\ncom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,214:1\n1563#2:215\n1634#2,3:216\n37#3,2:219\n13#4:221\n13#5:222\n*S KotlinDebug\n*F\n+ 1 AddNewScaffoldedItemAction.kt\ncom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction\n*L\n204#1:215\n204#1:216,3\n204#1:219,2\n42#1:221\n42#1:222\n*E\n"})
public final class AddNewScaffoldedItemAction
extends ProjectViewActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public AddNewScaffoldedItemAction() {
        super(false, false, 3, null);
    }

    @Override
    @Nullable
    protected ProjectModelEntity getItemInternal(@NotNull ProjectModelEntity entity, @NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
        if (rdProjectModelItemDescriptor instanceof RdProjectDescriptor) {
            object = (RdProjectDescriptor)rdProjectModelItemDescriptor;
        } else if (rdProjectModelItemDescriptor instanceof RdProjectFolderDescriptor) {
            RdProjectModelItemDescriptor rdProjectModelItemDescriptor2;
            ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
            Object object2 = rdProjectModelItemDescriptor2 = projectModelEntity != null ? projectModelEntity.getDescriptor() : null;
            object = rdProjectModelItemDescriptor2 instanceof RdProjectDescriptor ? (RdProjectDescriptor)rdProjectModelItemDescriptor2 : null;
        } else {
            object = null;
        }
        if (object == null) {
            return null;
        }
        RdProjectDescriptor rdProjectDescriptor = object;
        if (!this.x(rdProjectDescriptor)) {
            return null;
        }
        return entity;
    }

    @Override
    protected void actionPerformedInternal(@NotNull ProjectModelEntity entity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationKt.getApplication().assertIsDispatchThread();
        ApplicationKt.getApplication().saveAll();
        VirtualFile virtualFile = ProjectModelEntityExtensionsKt.getVirtualFileAsParent((ProjectModelEntity)entity);
        if (virtualFile == null) {
            throw new IllegalStateException(("Unable to get parent directory for item: " + ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)entity, (Project)project)).toString());
        }
        VirtualFile virtualFile2 = virtualFile;
        ScaffoldingDialogWithTemplates scaffoldingDialogWithTemplates = new ScaffoldingDialogWithTemplates(entity, virtualFile2);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)scaffoldingDialogWithTemplates), (JComponent)scaffoldingDialogWithTemplates.getNameField()).setTitle(RiderProjectViewBundle.Companion.message("popup.scaffolding.new_item.title", new Object[0])).setResizable(false).setModalContext(true).setFocusable(true).setRequestFocus(true).setMovable(true).setBelongsToGlobalPopupStack(true).setCancelKeyEnabled(true).setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true).addUserData((Object)"SIMPLE_WINDOW").createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup jBPopup2 = jBPopup;
        scaffoldingDialogWithTemplates.setApplyAction(arg_0 -> AddNewScaffoldedItemAction.x(arg_0 -> AddNewScaffoldedItemAction.x(scaffoldingDialogWithTemplates, jBPopup2, this, project, entity, arg_0), arg_0));
        Disposer.register((Disposable)((Disposable)jBPopup2), (Disposable)((Disposable)scaffoldingDialogWithTemplates));
        jBPopup2.showCenteredInCurrentWindow(project);
    }

    private final ScaffoldingRequestData x(String string) {
        String string2;
        ScaffoldedItemKind scaffoldedItemKind = ScaffoldingTemplate.INSTANCE.templateNameToKind(string);
        String string3 = string;
        if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcAreaName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_area", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcControllerEmptyName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_controller_empty", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcControllerReadWriteActionsName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_controller_read_write_actions", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcControllerEntityFrameworkName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_controller_entity_framework", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateApiControllerEmptyName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.api_controller_empty", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateApiControllerReadWriteActionsName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.api_controller_read_write_actions", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateApiControllerEntityFrameworkName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.api_controller_entity_framework", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcViewName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_view", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateRazorPageName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.razor_page", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateRazorPageEntityFrameworkName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.razor_page_entity_framework", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateRazorPageEntityFrameworkCRUDName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.razor_page_entity_framework_crud", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateIdentityName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.identity", var5_4);
        } else {
            throw new IllegalArgumentException("Unable to find Scaffolding kind for template with name '" + string + "'");
        }
        String string4 = string2;
        return new ScaffoldingRequestData(scaffoldedItemKind, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@NotNull Project project, @NotNull ProjectModelEntity node, @NotNull String template2, @NotNull String itemName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
        Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
        ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)node) ? node.getParentEntity() : node;
        if (projectModelEntity == null) {
            throw new IllegalStateException("Unable to get target Project Model node".toString());
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        ScaffoldingRequestData scaffoldingRequestData = this.x(template2);
        try {
            RdAddScaffoldedItemResult rdAddScaffoldedItemResult = this.x(project, projectModelEntity2, scaffoldingRequestData.getItemKind(), itemName, scaffoldingRequestData.getTaskName());
            if (rdAddScaffoldedItemResult != null && rdAddScaffoldedItemResult.getStatus() == ScaffoldedItemStatus.Succeeded) {
                this.x(project, rdAddScaffoldedItemResult.getPathToOpen(), rdAddScaffoldedItemResult.getPathsToRefresh());
            }
        }
        catch (CancellationException cancellationException) {
            logger.trace("Cancel scaffolding item task for template '" + template2 + "', item '" + itemName + "'.");
            ScaffoldItemFUSLogger.INSTANCE.onScaffoldingCanceled(project, ScaffoldingTemplate.INSTANCE.templateNameToKind(template2));
        }
        finally {
            ScaffoldingItemModel scaffoldingItemModel = ScaffoldingItemModel_PregeneratedKt.getScaffoldingItemModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
            scaffoldingItemModel.getScaffoldingGeneratorSession().getInitialized().fire((Object)false);
        }
    }

    private final boolean x(RdProjectDescriptor rdProjectDescriptor) {
        return rdProjectDescriptor.isDotNetCore() && rdProjectDescriptor.getSpecificType() == RdProjectType.Web;
    }

    private final RdAddScaffoldedItemResult x(Project project, ProjectModelEntity projectModelEntity, ScaffoldedItemKind scaffoldedItemKind, @NlsSafe String string, @Nls String string2) {
        ScaffoldingItemModel scaffoldingItemModel = ScaffoldingItemModel_PregeneratedKt.getScaffoldingItemModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
        Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)projectModelEntity, (Project)project);
        if (n == null) {
            throw new IllegalStateException("Unable to find target node Id for Scaffolding action.".toString());
        }
        int n2 = n;
        ScaffoldItemFUSLogger.INSTANCE.onSelectScaffoldingTemplate(project, scaffoldedItemKind);
        logger.info("Start waiting scaffolding action " + string + ".");
        RdAddScaffoldedItemResult rdAddScaffoldedItemResult = (RdAddScaffoldedItemResult)ExtensionsKt.runCommandUnderProgress$default((IRdCall)((IRdCall)scaffoldingItemModel.getAddScaffoldedItem()), (Object)new RdAddScaffoldedItemRequest(n2, scaffoldedItemKind, string), (Project)project, (String)string2, (boolean)true, (boolean)false, (boolean)false, (int)48, null);
        logger.info("Finish waiting scaffolding action " + string + ".");
        if (rdAddScaffoldedItemResult != null) {
            ScaffoldItemFUSLogger.INSTANCE.onGetScaffoldingResult(project, scaffoldedItemKind, rdAddScaffoldedItemResult.getStatus());
        }
        return rdAddScaffoldedItemResult;
    }

    private final void x(Project project, String string, List<String> list2) {
        if (!((Collection)list2).isEmpty()) {
            this.x(list2);
        }
        if (string != null) {
            Path path = Path.of(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            this.x(project, path);
        }
    }

    private final void x(List<String> list2) {
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            String string = (String)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(DocumentUtilKt.toIOFile((String)string));
        }
        iterable = (List)collection;
        bl = false;
        iterable2 = iterable;
        File[] fileArray = iterable2.toArray(new File[0]);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (File[])Arrays.copyOf(fileArray, fileArray.length));
    }

    private final void x(Project project, Path path) {
        VirtualFile virtualFile = VfsUtil.findFile((Path)path, (boolean)true);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        SolutionViewUtilsKt.navigateToSolutionView$default(project, virtualFile2, false, 2, null);
        FileEditorManager.getInstance((Project)project).openFile(virtualFile2, true);
    }

    private static final Unit x(ScaffoldingDialogWithTemplates scaffoldingDialogWithTemplates, JBPopup jBPopup, AddNewScaffoldedItemAction addNewScaffoldedItemAction, Project project, ProjectModelEntity projectModelEntity, InputEvent inputEvent) {
        String string = scaffoldingDialogWithTemplates.getEnteredName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEnteredName(...)");
        String string2 = string;
        String string3 = scaffoldingDialogWithTemplates.getSelectedTemplate();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSelectedTemplate(...)");
        String string4 = string3;
        ScaffoldItemNameValidator scaffoldItemNameValidator = scaffoldingDialogWithTemplates.getValidator();
        boolean bl = scaffoldItemNameValidator.checkInput(string2);
        if (bl) {
            jBPopup.closeOk(inputEvent);
            addNewScaffoldedItemAction.execute(project, projectModelEntity, string4, string2);
        } else {
            scaffoldingDialogWithTemplates.setError(scaffoldItemNameValidator.getErrorText(string2));
        }
        return Unit.INSTANCE;
    }

    private static final void x(Function1 function1, Object object) {
        function1.invoke(object);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(AddNewScaffoldedItemAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AddNewScaffoldedItemAction.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction$Companion;", "", "AddNewScaffoldedItemAction$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction$ScaffoldingRequestData;", "", "itemKind", "Lcom/jetbrains/rd/ide/model/ScaffoldedItemKind;", "taskName", "", "AddNewScaffoldedItemAction$ScaffoldingRequestData", "(Lcom/jetbrains/rd/ide/model/ScaffoldedItemKind;Ljava/lang/String;)V", "getItemKind", "()Lcom/jetbrains/rd/ide/model/ScaffoldedItemKind;", "getTaskName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    public static final class ScaffoldingRequestData {
        @NotNull
        private final ScaffoldedItemKind itemKind;
        @NotNull
        private final String taskName;

        public ScaffoldingRequestData(@NotNull ScaffoldedItemKind itemKind, @Nls @NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)itemKind, (String)"itemKind");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            this.itemKind = itemKind;
            this.taskName = taskName;
        }

        @NotNull
        public final ScaffoldedItemKind getItemKind() {
            return this.itemKind;
        }

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        @NotNull
        public final ScaffoldedItemKind component1() {
            return this.itemKind;
        }

        @NotNull
        public final String component2() {
            return this.taskName;
        }

        @NotNull
        public final ScaffoldingRequestData copy(@NotNull ScaffoldedItemKind itemKind, @Nls @NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)itemKind, (String)"itemKind");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return new ScaffoldingRequestData(itemKind, taskName);
        }

        public static /* synthetic */ ScaffoldingRequestData copy$default(ScaffoldingRequestData scaffoldingRequestData, ScaffoldedItemKind scaffoldedItemKind, String string, int n, Object object) {
            if ((n & 1) != 0) {
                scaffoldedItemKind = scaffoldingRequestData.itemKind;
            }
            if ((n & 2) != 0) {
                string = scaffoldingRequestData.taskName;
            }
            return scaffoldingRequestData.copy(scaffoldedItemKind, string);
        }

        @NotNull
        public String toString() {
            return "ScaffoldingRequestData(itemKind=" + this.itemKind + ", taskName=" + this.taskName + ")";
        }

        public int hashCode() {
            int n = this.itemKind.hashCode();
            n = n * 31 + this.taskName.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScaffoldingRequestData)) {
                return false;
            }
            ScaffoldingRequestData scaffoldingRequestData = (ScaffoldingRequestData)other;
            if (this.itemKind != scaffoldingRequestData.itemKind) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.taskName, (Object)scaffoldingRequestData.taskName);
        }
    }
}

