/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions.properties.configurations.table;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.model.RdEditConfigurationProjectInfo;
import com.jetbrains.rider.model.RdEditConfigurationTableRow;
import com.jetbrains.rider.projectView.actions.properties.configurations.EditConfigurationsAndPlatformsDialog;
import com.jetbrains.rider.projectView.actions.properties.configurations.EditConfigurationsAndPlatformsViewModel;
import com.jetbrains.rider.projectView.actions.properties.configurations.EditSolutionPropertiesContext;
import com.jetbrains.rider.projectView.actions.properties.configurations.ExtensionsKt;
import com.jetbrains.rider.projectView.actions.properties.configurations.table.ConfigurationAndPlatformRenderer;
import com.jetbrains.rider.projectView.actions.properties.configurations.table.ConfigurationRowModel;
import com.jetbrains.rider.ui.components.table.TablePopupCellEditor;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0010\u0011\u0012B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor;", "Lcom/jetbrains/rider/ui/components/table/TablePopupCellEditor;", "context", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/EditSolutionPropertiesContext;", "ConfigurationAndPlatformEditor", "(Lcom/jetbrains/rider/projectView/actions/properties/configurations/EditSolutionPropertiesContext;)V", "createActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "table", "Ljavax/swing/JTable;", "value", "", "createComponent", "Ljavax/swing/JComponent;", "isSelected", "", "SelectAction", "RemoveAction", "EditAction", "intellij.rider"})
public final class ConfigurationAndPlatformEditor
extends TablePopupCellEditor {
    @Nullable
    private final EditSolutionPropertiesContext context;

    public ConfigurationAndPlatformEditor(@Nullable EditSolutionPropertiesContext context) {
        this.context = context;
    }

    @Override
    @NotNull
    public DefaultActionGroup createActionGroup(@NotNull JTable table2, @NotNull Object value2) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        ConfigurationRowModel configurationRowModel = (ConfigurationRowModel)value2;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new EditAction(configurationRowModel, table2));
        defaultActionGroup.addSeparator();
        Set<RdConfigurationAndPlatform> set = configurationRowModel.getProjectConfigurations();
        for (RdConfigurationAndPlatform rdConfigurationAndPlatform : set) {
            defaultActionGroup.add((AnAction)new SelectAction(rdConfigurationAndPlatform, configurationRowModel, table2));
        }
        defaultActionGroup.addSeparator();
        defaultActionGroup.add((AnAction)new RemoveAction(configurationRowModel, table2));
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public JComponent createComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return (JComponent)ConfigurationAndPlatformRenderer.Companion.createComboBoxLabel((ConfigurationRowModel)value2, this.context);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$EditAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "model", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "ConfigurationAndPlatformEditor$EditAction", "(Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getModel", "()Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getTable", "()Ljavax/swing/JTable;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "MyViewModel", "intellij.rider"})
    public static final class EditAction
    extends AnAction {
        @NotNull
        private final ConfigurationRowModel model;
        @NotNull
        private final JTable table;

        public EditAction(@NotNull ConfigurationRowModel model, @NotNull JTable table2) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            super(RiderActionsBundle.Companion.message("ConfigurationAndPlatformRenderer.action.edit.text", new Object[0]), RiderActionsBundle.Companion.message("ConfigurationAndPlatformRenderer.action.edit.project.configurations.platforms.description", new Object[0]), AllIcons.Actions.Edit);
            this.model = model;
            this.table = table2;
        }

        @NotNull
        public final ConfigurationRowModel getModel() {
            return this.model;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(ExtensionsKt.isEditable(this.model));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            EditConfigurationsAndPlatformsDialog editConfigurationsAndPlatformsDialog = new EditConfigurationsAndPlatformsDialog(project2, this.model.getLifetime(), new MyViewModel(this.model, this.table));
            editConfigurationsAndPlatformsDialog.show();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001f\u001a\u00020\rH\u0014J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\rH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$EditAction$MyViewModel;", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/EditConfigurationsAndPlatformsViewModel;", "model", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "ConfigurationAndPlatformEditor$EditAction$MyViewModel", "(Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getModel", "()Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getTable", "()Ljavax/swing/JTable;", "affectAllProjects", "", "getAffectAllProjects", "()Z", "allValues", "", "Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "getAllValues", "()Ljava/util/Set;", "predefinedPlatforms", "", "", "getPredefinedPlatforms", "()Ljava/lang/Iterable;", "getDialogTitle", "addInternal", "", "new", "base", "forProjects", "removeInternal", "old", "intellij.rider"})
        private static final class MyViewModel
        extends EditConfigurationsAndPlatformsViewModel {
            @NotNull
            private final ConfigurationRowModel model;
            @NotNull
            private final JTable table;

            public MyViewModel(@NotNull ConfigurationRowModel model, @NotNull JTable table2) {
                Intrinsics.checkNotNullParameter((Object)model, (String)"model");
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                this.model = model;
                this.table = table2;
                this.getChanged().advise(this.model.getLifetime(), arg_0 -> MyViewModel.x(this, arg_0));
            }

            @NotNull
            public final ConfigurationRowModel getModel() {
                return this.model;
            }

            @NotNull
            public final JTable getTable() {
                return this.table;
            }

            @Override
            public boolean getAffectAllProjects() {
                return false;
            }

            @Override
            @NotNull
            public Set<RdConfigurationAndPlatform> getAllValues() {
                return this.model.getProjectConfigurations();
            }

            @Override
            @NotNull
            public Iterable<String> getPredefinedPlatforms() {
                Object[] objectArray = new String[]{"AnyCPU"};
                return CollectionsKt.arrayListOf((Object[])objectArray);
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                Object[] objectArray = new Object[]{this.model.getProjectName()};
                return RiderProjectViewBundle.Companion.message("ConfigurationAndPlatformEditor.dialog.title", objectArray);
            }

            @Override
            protected void addInternal(@NotNull RdConfigurationAndPlatform rdConfigurationAndPlatform, @Nullable RdConfigurationAndPlatform base, boolean forProjects) {
                RdEditConfigurationTableRow rdEditConfigurationTableRow;
                Intrinsics.checkNotNullParameter((Object)rdConfigurationAndPlatform, (String)"new");
                IMutableViewableMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> iMutableViewableMap = this.model.getProjectConfigurationsMap();
                ((Map)iMutableViewableMap).put(rdConfigurationAndPlatform, new RdEditConfigurationProjectInfo(base));
                RdEditConfigurationTableRow rdEditConfigurationTableRow2 = rdEditConfigurationTableRow = this.model.getRow();
                Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow2);
                rdEditConfigurationTableRow2.getConfigurationAndPlatform().set((Object)rdConfigurationAndPlatform);
            }

            @Override
            protected void removeInternal(@NotNull RdConfigurationAndPlatform old, boolean forProjects) {
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                IMutableViewableMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> iMutableViewableMap = this.model.getProjectConfigurationsMap();
                iMutableViewableMap.remove((Object)old);
                RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
                Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow);
                RdEditConfigurationTableRow rdEditConfigurationTableRow2 = rdEditConfigurationTableRow;
                if (Intrinsics.areEqual((Object)rdEditConfigurationTableRow2.getConfigurationAndPlatform().getValue(), (Object)old)) {
                    rdEditConfigurationTableRow2.getConfigurationAndPlatform().set(CollectionsKt.firstOrNull((Iterable)iMutableViewableMap.keySet()));
                }
            }

            private static final Unit x(MyViewModel myViewModel, Unit unit) {
                Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
                TableModel tableModel2 = myViewModel.table.getModel();
                Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
                ((AbstractTableModel)tableModel2).fireTableDataChanged();
                return Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$RemoveAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "model", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "ConfigurationAndPlatformEditor$RemoveAction", "(Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getModel", "()Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getTable", "()Ljavax/swing/JTable;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.rider"})
    public static final class RemoveAction
    extends AnAction {
        @NotNull
        private final ConfigurationRowModel model;
        @NotNull
        private final JTable table;

        public RemoveAction(@NotNull ConfigurationRowModel model, @NotNull JTable table2) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Object[] objectArray = new Object[]{ExtensionsKt.present((RdConfigurationAndPlatform)model.getContent().getConfigurationAndPlatform().getValue())};
            super(RiderActionsBundle.Companion.message("action.remove.text", new Object[0]), RiderActionsBundle.Companion.message("ConfigurationAndPlatformEditor.action.dont.specify.project.configuration", objectArray), AllIcons.General.Remove);
            this.model = model;
            this.table = table2;
        }

        @NotNull
        public final ConfigurationRowModel getModel() {
            return this.model;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
            Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow);
            boolean bl = rdEditConfigurationTableRow.getConfigurationAndPlatform().getValue() != null;
            e.getPresentation().setEnabledAndVisible(bl && ExtensionsKt.isEditable(this.model));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
            Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow);
            rdEditConfigurationTableRow.getConfigurationAndPlatform().set(null);
            TableModel tableModel2 = this.table.getModel();
            Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
            ((AbstractTableModel)tableModel2).fireTableDataChanged();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$SelectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "projectConfiguration", "Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "model", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "ConfigurationAndPlatformEditor$SelectAction", "(Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getProjectConfiguration", "()Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "getModel", "()Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getTable", "()Ljavax/swing/JTable;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.rider"})
    public static final class SelectAction
    extends AnAction {
        @NotNull
        private final RdConfigurationAndPlatform projectConfiguration;
        @NotNull
        private final ConfigurationRowModel model;
        @NotNull
        private final JTable table;

        public SelectAction(@NotNull RdConfigurationAndPlatform projectConfiguration, @NotNull ConfigurationRowModel model, @NotNull JTable table2) {
            Intrinsics.checkNotNullParameter((Object)projectConfiguration, (String)"projectConfiguration");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            this.projectConfiguration = projectConfiguration;
            this.model = model;
            this.table = table2;
        }

        @NotNull
        public final RdConfigurationAndPlatform getProjectConfiguration() {
            return this.projectConfiguration;
        }

        @NotNull
        public final ConfigurationRowModel getModel() {
            return this.model;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            ExtensionsKt.present(this.projectConfiguration, presentation);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
            Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow);
            rdEditConfigurationTableRow.getConfigurationAndPlatform().set((Object)this.projectConfiguration);
            TableModel tableModel2 = this.table.getModel();
            Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
            ((AbstractTableModel)tableModel2).fireTableDataChanged();
        }
    }
}

