/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions.properties.configurations;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rider.model.RdEditConfigurationProject;
import com.jetbrains.rider.model.RdEditConfigurationProjectInfo;
import com.jetbrains.rider.model.RdEditSolutionPropertiesContent;
import com.jetbrains.rider.projectView.actions.properties.configurations.EditSolutionPropertiesContext;
import com.jetbrains.rider.projectView.actions.properties.configurations.table.ConfigurationRowModel;
import com.jetbrains.rider.settings.tree.renderers.Common;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.ReSharperIcons;
import java.awt.Color;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u0005*\u0004\u0018\u00010\u0002H\u0007\u001a\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r0\f*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u000e\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0012\u00a8\u0006\u0017"}, d2={"present", "", "Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "", "getProjectConfigurations", "", "Lcom/jetbrains/rider/model/RdEditSolutionPropertiesContent;", "projectId", "", "getProjectConfigurationsMap", "Lcom/jetbrains/rd/util/reactive/IMutableViewableMap;", "Lcom/jetbrains/rider/model/RdEditConfigurationProjectInfo;", "toProjectStyleConfiguration", "toSolutionStyleConfiguration", "isEditable", "", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getBackgroundColor", "Ljava/awt/Color;", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/EditSolutionPropertiesContext;", "row", "intellij.rider"})
public final class ExtensionsKt {
    public static final void present(@Nullable RdConfigurationAndPlatform $this$present, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setText(StringsKt.replace$default((String)ExtensionsKt.present($this$present), (String)"_", (String)"__", (boolean)false, (int)4, null));
        if ($this$present == null) {
            presentation.setIcon(null);
        } else {
            presentation.setIcon(ReSharperIcons.ProjectModel.ProjectProperties);
        }
    }

    @Nls
    @NotNull
    public static final String present(@Nullable RdConfigurationAndPlatform $this$present) {
        if ($this$present == null) {
            return RiderProjectViewBundle.Companion.message("label.no.configuration", new Object[0]);
        }
        return $this$present.getConfiguration() + " | " + $this$present.getPlatform();
    }

    @NotNull
    public static final Set<RdConfigurationAndPlatform> getProjectConfigurations(@NotNull RdEditSolutionPropertiesContent $this$getProjectConfigurations, int projectId) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectConfigurations, (String)"<this>");
        return ExtensionsKt.getProjectConfigurationsMap($this$getProjectConfigurations, projectId).keySet();
    }

    @NotNull
    public static final IMutableViewableMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> getProjectConfigurationsMap(@NotNull RdEditSolutionPropertiesContent $this$getProjectConfigurationsMap, int projectId) {
        Intrinsics.checkNotNullParameter((Object)$this$getProjectConfigurationsMap, (String)"<this>");
        Object object = $this$getProjectConfigurationsMap.getView().getProjects().get((Object)projectId);
        Intrinsics.checkNotNull((Object)object);
        RdEditConfigurationProject rdEditConfigurationProject = (RdEditConfigurationProject)object;
        return rdEditConfigurationProject.getProjectConfigurationsAndPlatforms();
    }

    @NotNull
    public static final RdConfigurationAndPlatform toProjectStyleConfiguration(@NotNull RdConfigurationAndPlatform $this$toProjectStyleConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$toProjectStyleConfiguration, (String)"<this>");
        if (StringsKt.equals((String)"Any CPU", (String)$this$toProjectStyleConfiguration.getPlatform(), (boolean)true)) {
            return new RdConfigurationAndPlatform($this$toProjectStyleConfiguration.getConfiguration(), "AnyCPU");
        }
        return $this$toProjectStyleConfiguration;
    }

    @NotNull
    public static final RdConfigurationAndPlatform toSolutionStyleConfiguration(@NotNull RdConfigurationAndPlatform $this$toSolutionStyleConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$toSolutionStyleConfiguration, (String)"<this>");
        if (StringsKt.equals((String)"AnyCPU", (String)$this$toSolutionStyleConfiguration.getPlatform(), (boolean)true)) {
            return new RdConfigurationAndPlatform($this$toSolutionStyleConfiguration.getConfiguration(), "Any CPU");
        }
        return $this$toSolutionStyleConfiguration;
    }

    public static final boolean isEditable(@NotNull ConfigurationRowModel $this$isEditable) {
        Intrinsics.checkNotNullParameter((Object)$this$isEditable, (String)"<this>");
        RdEditConfigurationProject rdEditConfigurationProject = (RdEditConfigurationProject)$this$isEditable.getContent().getView().getProjects().get((Object)$this$isEditable.getProjectId());
        return (rdEditConfigurationProject != null ? rdEditConfigurationProject.isEditable() : false) && !$this$isEditable.getContent().isReadonly();
    }

    @NotNull
    public static final Color getBackgroundColor(@Nullable EditSolutionPropertiesContext $this$getBackgroundColor, @Nullable ConfigurationRowModel row) {
        if (row != null) {
            EditSolutionPropertiesContext editSolutionPropertiesContext = $this$getBackgroundColor;
            boolean bl = editSolutionPropertiesContext != null ? editSolutionPropertiesContext.isHighlighted(row) : false;
            if (bl) {
                return Common.Resources.getHighlightedBackgroundColor();
            }
        }
        Color color = UIUtil.getTableBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTableBackground(...)");
        return color;
    }
}

